(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     14967,        408]
NotebookOptionsPosition[     13811,        366]
NotebookOutlinePosition[     14232,        382]
CellTagsIndexPosition[     14189,        379]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the QP problem defined by:
min(0.5 * X.P.X + q.X + r) s.t.
G.x < h\
\>", "Subtitle",
 CellChangeTimes->{{3.6120025695124807`*^9, 3.612002582256736*^9}, {
  3.6244350915059814`*^9, 3.6244350944759855`*^9}, {3.6246346821084228`*^9, 
  3.624634684347997*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"myRootDir", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"myProblemId", " ", "=", " ", 
  RowBox[{"ToString", "[", "\"\<6\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<P\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "P", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Eigenvalues", "[", "P", "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], 
  StyleBox[";", "MR"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<q\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<r\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<G\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"h", "=", 
  RowBox[{"Import", "[", 
   RowBox[{
    RowBox[{"StringJoin", "[", 
     RowBox[{"{", 
      RowBox[{
      "myRootDir", ",", " ", "\"\<h\>\"", ",", "myProblemId", ",", 
       "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Length", "[", "h", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GX", "=", 
   RowBox[{"G", ".", "X"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"GX", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "<", 
      RowBox[{"h", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "h", "]"}]}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6244353638643665`*^9, 3.624435363974367*^9}, {
   3.624435405944426*^9, 3.624435411116433*^9}, {3.6244354694993596`*^9, 
   3.6244355230914354`*^9}, {3.624435582242519*^9, 3.624435595214537*^9}, {
   3.624435749153754*^9, 3.624435798998825*^9}, {3.624435838736881*^9, 
   3.6244359007829685`*^9}, 3.624436019603136*^9, {3.624437396807086*^9, 
   3.624437458389173*^9}, {3.6244375248032665`*^9, 3.624437529494273*^9}, 
   3.624437606393382*^9, {3.624634935988794*^9, 3.6246349379286776`*^9}, {
   3.624635791451316*^9, 3.6246358419288216`*^9}, {3.624687246883895*^9, 
   3.6246872911548786`*^9}, {3.6246874013525076`*^9, 
   3.6246874571301613`*^9}, {3.6246877560047255`*^9, 
   3.6246877801094484`*^9}, {3.6246881110199456`*^9, 
   3.6246881596503496`*^9}, {3.624709623456856*^9, 3.6247097216148405`*^9}, {
   3.625843473118153*^9, 3.6258434762990894`*^9}}],

Cell[BoxData["\<\"6\"\>"], "Output",
 CellChangeTimes->{
  3.6246876669360523`*^9, 3.6246877280988874`*^9, 3.6246878055332117`*^9, 
   3.624688227335088*^9, 3.6246885167444477`*^9, 3.6246929506248393`*^9, 
   3.624703683742199*^9, {3.624709630148923*^9, 3.6247096684943066`*^9}, {
   3.6247097069026933`*^9, 3.6247097245358696`*^9}, 3.624713276892234*^9}],

Cell[BoxData["16"], "Output",
 CellChangeTimes->{
  3.6246876669360523`*^9, 3.6246877280988874`*^9, 3.6246878055332117`*^9, 
   3.624688227335088*^9, 3.6246885167444477`*^9, 3.6246929506248393`*^9, 
   3.624703683742199*^9, {3.624709630148923*^9, 3.6247096684943066`*^9}, {
   3.6247097069026933`*^9, 3.6247097245358696`*^9}, 3.6247132769222326`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1000.0000000001`", ",", "0", ",", "4000.0000000001`", ",", "0", 
   ",", "10000.0000000001`", ",", "0", ",", "6000.0000000001`", ",", "0", ",",
    "8000.0000000001`", ",", "0", ",", "4000.0000000001`", ",", "0", ",", 
   "1000.0000000001`", ",", "0", ",", "5000.0000000001`", ",", "0", ",", 
   "8000.0000000001`", ",", "0", ",", "4000.0000000001`", ",", "0", ",", 
   "5000.0000000001`", ",", "0", ",", "5000.0000000001`", ",", "0", ",", 
   "1000.0000000001`", ",", "0", ",", "4000.0000000001`", ",", "0", ",", 
   "5000.0000000001`", ",", "0", ",", "9000.0000000001`", ",", 
   "6288.3931818997`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6246876669360523`*^9, 3.6246877280988874`*^9, 3.6246878055332117`*^9, 
   3.624688227335088*^9, 3.6246885167444477`*^9, 3.6246929506248393`*^9, 
   3.624703683742199*^9, {3.624709630148923*^9, 3.6247096684943066`*^9}, {
   3.6247097069026933`*^9, 3.6247097245358696`*^9}, 3.6247132770022306`*^9}],

Cell[BoxData["33"], "Output",
 CellChangeTimes->{
  3.6246876669360523`*^9, 3.6246877280988874`*^9, 3.6246878055332117`*^9, 
   3.624688227335088*^9, 3.6246885167444477`*^9, 3.6246929506248393`*^9, 
   3.624703683742199*^9, {3.624709630148923*^9, 3.6247096684943066`*^9}, {
   3.6247097069026933`*^9, 3.6247097245358696`*^9}, 3.6247132770022306`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["ret", "MR"], " ", "=", " ", 
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"0.5", " ", "*", " ", 
        RowBox[{"X", ".", "P", ".", "X"}]}], "+", 
       RowBox[{"q", ".", "X"}], "+", "r"}], ",", " ", "myConstraints"}], 
     "}"}], ",", "X"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.612000174244712*^9, 3.612000175314679*^9}, {
  3.6120003796164956`*^9, 3.6120003816884956`*^9}, {3.6120004869944954`*^9, 
  3.612000488224496*^9}, {3.6120006205324955`*^9, 3.6120006250834956`*^9}, {
  3.6244351084990053`*^9, 3.624435110480008*^9}, {3.6246329485479083`*^9, 
  3.624632963530208*^9}, {3.6246352615169477`*^9, 3.624635263496928*^9}, {
  3.6247131423992662`*^9, 3.6247131439392204`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4.241617285260076`*^10", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "\[Rule]", "1.6163744086904452`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "2", "]"}], "\[Rule]", "587.0961331914921`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "3", "]"}], "\[Rule]", "346.686261807316`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "4", "]"}], "\[Rule]", "1.3566155478258`*^-8"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "5", "]"}], "\[Rule]", "1.6170648003002348`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "6", "]"}], "\[Rule]", "245.4000720247262`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "7", "]"}], "\[Rule]", "531.7281221064933`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "8", "]"}], "\[Rule]", "1.3856095921190327`*^-8"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "9", "]"}], "\[Rule]", 
      RowBox[{"-", "3999.999999998483`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "10", "]"}], "\[Rule]", 
      RowBox[{"-", "2888.158356588817`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "11", "]"}], "\[Rule]", 
      RowBox[{"-", "3416.422829493631`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "12", "]"}], "\[Rule]", 
      RowBox[{"-", "3999.9999999865618`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "13", "]"}], "\[Rule]", 
      RowBox[{"-", "5999.999999998482`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "14", "]"}], "\[Rule]", 
      RowBox[{"-", "4232.7310305211895`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "15", "]"}], "\[Rule]", 
      RowBox[{"-", "4584.527072220935`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "16", "]"}], "\[Rule]", 
      RowBox[{"-", "8999.999999986365`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6246359253318276`*^9, 3.624687125175749*^9, 
  3.624687667266062*^9, 3.624687835447209*^9, 3.6246882564263353`*^9, 
  3.624688542295923*^9, 3.6246929753755913`*^9, 3.6247037066307755`*^9, 
  3.6247133049053936`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", " ", "=", " ", 
  RowBox[{"Flatten", "[", 
   RowBox[{"X", "/.", 
    RowBox[{"Take", "[", 
     RowBox[{"ret", ",", " ", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"Take", "[", 
   RowBox[{"ret", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.6163744086904452`*^-9", ",", "587.0961331914921`", ",", 
   "346.686261807316`", ",", "1.3566155478258`*^-8", ",", 
   "1.6170648003002348`*^-9", ",", "245.4000720247262`", ",", 
   "531.7281221064933`", ",", "1.3856095921190327`*^-8", ",", 
   RowBox[{"-", "3999.999999998483`"}], ",", 
   RowBox[{"-", "2888.158356588817`"}], ",", 
   RowBox[{"-", "3416.422829493631`"}], ",", 
   RowBox[{"-", "3999.9999999865618`"}], ",", 
   RowBox[{"-", "5999.999999998482`"}], ",", 
   RowBox[{"-", "4232.7310305211895`"}], ",", 
   RowBox[{"-", "4584.527072220935`"}], ",", 
   RowBox[{"-", "8999.999999986365`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6247133076703105`*^9}],

Cell[BoxData[
 RowBox[{"{", "4.241617285260076`*^10", "}"}]], "Output",
 CellChangeTimes->{3.6247133076703105`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}]}], "Input"],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\qp\\\\value6.txt\"\>"], "Output",
 CellChangeTimes->{3.6247133108302155`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\qp\\\\sol6.txt\"\>"], "Output",
 CellChangeTimes->{3.6247133108402157`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"G", ".", "mySol"}], "-", "h"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"G", ".", "mySol"}], "-", "h"}], "]"}]}], "Input",
 CellChangeTimes->{3.6247132718313856`*^9, 3.6247134768778625`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1.6163744086904452`*^-9"}], ",", 
   RowBox[{"-", "999.9999999984836`"}], ",", 
   RowBox[{"-", "3999.999999998483`"}], ",", 
   RowBox[{"-", "1.6170815797522664`*^-9"}], ",", 
   RowBox[{"-", "1.6170648003002348`*^-9"}], ",", 
   RowBox[{"-", "9999.999999998483`"}], ",", 
   RowBox[{"-", "5999.999999998482`"}], ",", 
   RowBox[{"-", "1.6179910744540393`*^-9"}], ",", 
   RowBox[{"-", "587.0961331914921`"}], ",", 
   RowBox[{"-", "7412.903866808608`"}], ",", 
   RowBox[{"-", "2888.158356588817`"}], ",", 
   RowBox[{"-", "1111.8416434112833`"}], ",", 
   RowBox[{"-", "245.4000720247262`"}], ",", 
   RowBox[{"-", "754.5999279753738`"}], ",", 
   RowBox[{"-", "4232.7310305211895`"}], ",", 
   RowBox[{"-", "767.2689694789105`"}], ",", 
   RowBox[{"-", "346.686261807316`"}], ",", 
   RowBox[{"-", "7653.3137381927845`"}], ",", 
   RowBox[{"-", "3416.422829493631`"}], ",", 
   RowBox[{"-", "583.577170506469`"}], ",", 
   RowBox[{"-", "531.7281221064933`"}], ",", 
   RowBox[{"-", "4468.271877893607`"}], ",", 
   RowBox[{"-", "4584.527072220935`"}], ",", 
   RowBox[{"-", "415.4729277791648`"}], ",", 
   RowBox[{"-", "1.3566155478258`*^-8"}], ",", 
   RowBox[{"-", "999.9999999865339`"}], ",", 
   RowBox[{"-", "3999.9999999865618`"}], ",", 
   RowBox[{"-", "1.3538283383240923`*^-8"}], ",", 
   RowBox[{"-", "1.3856095921190327`*^-8"}], ",", 
   RowBox[{"-", "4999.999999986244`"}], ",", 
   RowBox[{"-", "8999.999999986365`"}], ",", 
   RowBox[{"-", "1.3735188986174762`*^-8"}], ",", 
   RowBox[{"-", "5.9117155615240335`*^-9"}]}], "}"}]], "Output",
 CellChangeTimes->{3.624713313440138*^9, 3.624713478187849*^9}],

Cell[BoxData[
 RowBox[{"-", "1.6163744086904452`*^-9"}]], "Output",
 CellChangeTimes->{3.624713313440138*^9, 3.624713478187849*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 871},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 273, 7, 135, "Subtitle"],
Cell[CellGroupData[{
Cell[877, 33, 3651, 96, 313, "Input"],
Cell[4531, 131, 355, 5, 36, "Output"],
Cell[4889, 138, 350, 5, 36, "Output"],
Cell[5242, 145, 995, 16, 60, "Output"],
Cell[6240, 163, 350, 5, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6627, 173, 780, 17, 36, "Input"],
Cell[7410, 192, 2035, 51, 90, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9482, 248, 428, 13, 60, "Input"],
Cell[9913, 263, 714, 15, 68, "Output"],
Cell[10630, 280, 115, 2, 41, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10782, 287, 526, 14, 60, "Input"],
Cell[11311, 303, 182, 2, 36, "Output"],
Cell[11496, 307, 180, 2, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11713, 314, 254, 6, 60, "Input"],
Cell[11970, 322, 1679, 36, 115, "Output"],
Cell[13652, 360, 131, 2, 38, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
