(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    116294,       3202]
NotebookOptionsPosition[    115063,       3159]
NotebookOutlinePosition[    115484,       3175]
CellTagsIndexPosition[    115441,       3172]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the QP problem defined by:
min(0.5 * X.P.X) s.t.
G.x < h
lb <= x <= ub\
\>", "Subtitle",
 CellChangeTimes->{
  3.6157155673595924`*^9, 3.6244352891392612`*^9, {3.6244353215343065`*^9, 
   3.6244353216643066`*^9}, {3.6247068148144536`*^9, 3.6247068155144677`*^9}, 
   3.624794252155517*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myProblemId", " ", "=", " ", 
  RowBox[{"ToString", "[", "\"\<4\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<P\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "P", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Eigenvalues", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], 
  StyleBox[";", "MR"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"q", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<q\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<G\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<h\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lb", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<lb\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ub", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<ub\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GX", "=", 
   RowBox[{"G", ".", "X"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"GX", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "<", 
      RowBox[{"h", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "h", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LBConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[GreaterEqual]", 
      RowBox[{"lb", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UBConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[LessEqual]", " ", 
      RowBox[{"ub", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"myConstraints", " ", "=", " ", 
  RowBox[{"Join", "[", 
   RowBox[{
   "GConstraints", ",", " ", "LBConstraints", ",", " ", "UBConstraints"}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.6247062852568398`*^9, 3.6247062853268423`*^9}, {
   3.6247063489393873`*^9, 3.6247064123029222`*^9}, {3.6247065988861322`*^9, 
   3.6247066683185215`*^9}, 3.6247068554612665`*^9, {3.624706935964878*^9, 
   3.624706959139896*^9}, 3.6247070113293753`*^9, {3.624794259958832*^9, 
   3.6247942763224864`*^9}, {3.6247943469183164`*^9, 3.624794352429537*^9}, {
   3.6258434577954593`*^9, 3.62584346126639*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\qp\\\\\"\>"], "Output",
 CellChangeTimes->{3.6247946079348927`*^9}],

Cell[BoxData["\<\"4\"\>"], "Output",
 CellChangeTimes->{3.6247946079348927`*^9}],

Cell[BoxData["75"], "Output",
 CellChangeTimes->{3.6247946079748945`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "10.`", ",", "10.`", ",", "10.`", ",", "10.`", ",", "10.`", ",", "10.`", 
   ",", "10.`", ",", "10.`", ",", "10.`", ",", "10.`", ",", "10.`", ",", 
   "10.`", ",", "10.`", ",", "10.`", ",", "10.`", ",", "0.`", ",", "0.`", ",",
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{3.6247946079748945`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.731729`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.943571`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.692308`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.994035`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.856`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "16", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.611429`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.041786`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.692308`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.822`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "17", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.090226`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.857143`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.877193`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.940299`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.9997`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "18", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.506165`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.9225`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.997193`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.83`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99642`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "19", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.278195`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.5`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.192982`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"0.791045`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.7`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.9999`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "20", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.89985`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.993929`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.997193`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.86`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.98556`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "21", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.065263`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.836429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.979649`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.8`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99994`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "22", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.724211`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.987857`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.994035`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "12", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "23", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.366015`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.910714`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"0.692308`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.964912`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.84`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "24", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.082707`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.214286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"0.846154`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.894737`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "12", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "25", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.37594`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.803571`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.877193`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.850746`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.94`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.99884`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "26", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.646617`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.973214`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.982456`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.910448`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.74`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.69784`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "27", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.163007`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.925714`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.953333`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.76`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99526`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "28", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.077594`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.357143`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"0.970149`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.906`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "29", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.393384`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.886786`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.68`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "30", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.836992`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.714286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"0.692308`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.929825`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.64`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.98`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "31", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.676692`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.8275`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.88`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "32", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.71188`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.892857`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.900702`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.578`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.996`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "33", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.666767`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.357143`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.719298`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"0.970149`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.93`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99988`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "34", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.02015`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.979286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.052632`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.402985`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.7`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "35", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.413534`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.821429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.824561`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99996`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "36", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.112782`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.785714`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.578947`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.671642`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.92`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "37", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.721805`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.955357`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.991228`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.82`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99998`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "38", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.368421`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.821429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.846154`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.964912`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.652`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "39", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.28812`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.321429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.846154`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.052632`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.492537`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "40", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.085113`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.523929`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.482456`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.910448`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "41", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.080301`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.824561`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "42", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.383459`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.875`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.982456`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.837`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "43", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.06015`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.6725`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.929825`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "12", "]"}]}], "-", 
     RowBox[{"0.76`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "44", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.493835`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.806429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.991228`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "12", "]"}]}], "-", 
     RowBox[{"0.92`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "45", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.581353`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.946429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.988421`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.78`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99498`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "46", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.829474`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.482143`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.997193`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"0.970149`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.9`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99998`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "47", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.170526`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.928571`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.692308`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.842105`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.994`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "48", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.706767`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.892857`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.938596`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.84`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "49", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.461053`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.940714`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.906316`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.761194`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.697`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.9342`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "50", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.877293`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.214286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.929825`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.671642`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.94`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "51", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.41594`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.839286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"0.846154`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.754386`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.8`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99718`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "52", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.165414`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.5`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.789474`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "53", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.649023`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.919643`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.909474`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"0.940299`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.8`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "54", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.193083`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.892857`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.692308`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "12", "]"}]}], "-", 
     RowBox[{"0.7`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "55", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.694135`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.958214`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"0.846154`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.991228`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.76`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99998`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "56", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.270677`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.107143`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.438596`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.976`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.95944`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "57", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.556391`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.782857`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.821754`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.970149`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.93`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "58", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.448722`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.714286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.824561`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.64`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "59", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.776842`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.9375`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.982456`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.72`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99592`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "60", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.385865`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.345`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.684211`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.641791`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.99558`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "61", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.112782`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.800714`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.985263`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"0.970149`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.24`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.9982`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "62", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.263158`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.571429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.538462`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.929825`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "63", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.28812`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.854286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.997193`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.6`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.884`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "64", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.516391`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.854286`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.997193`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.872`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.99998`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "65", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.290827`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.809643`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.846154`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.988421`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.98998`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "66", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.471278`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.392857`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.508772`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.522388`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.9`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "67", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.328421`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.818571`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.98`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "68", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.796992`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.8275`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.859649`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.671642`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.8`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.94`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "69", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.005113`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.583214`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.614035`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.535`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.997`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "70", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.75188`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.440357`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"0.692308`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.988421`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.816`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "71", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.796992`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.285714`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "4", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.824561`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "12", "]"}]}], "+", 
     RowBox[{"0.96`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "72", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.363308`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.821429`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.230769`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "+", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.761`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"0.996`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "73", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "-", 
     RowBox[{"0.689323`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "-", 
     RowBox[{"0.9375`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "-", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.25`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "-", 
     RowBox[{"0.994035`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "-", 
     RowBox[{"0.880597`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "-", 
     RowBox[{"0.746`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "-", 
     RowBox[{"0.961`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "74", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "1", "]"}]}], "+", 
     RowBox[{"0.290827`", " ", 
      RowBox[{"x", "[", "2", "]"}]}], "+", 
     RowBox[{"0.535714`", " ", 
      RowBox[{"x", "[", "3", "]"}]}], "+", 
     RowBox[{"0.076923`", " ", 
      RowBox[{"x", "[", "5", "]"}]}], "-", 
     RowBox[{"0.75`", " ", 
      RowBox[{"x", "[", "6", "]"}]}], "+", 
     RowBox[{"0.701754`", " ", 
      RowBox[{"x", "[", "7", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "8", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "9", "]"}]}], "+", 
     RowBox[{"0.641791`", " ", 
      RowBox[{"x", "[", "10", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "11", "]"}]}], "+", 
     RowBox[{"0.907`", " ", 
      RowBox[{"x", "[", "13", "]"}]}], "+", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "14", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "15", "]"}]}], "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "75", "]"}]}]}], "<", 
    RowBox[{"-", "1.`"}]}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "16", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "17", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "18", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "19", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "20", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "21", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "22", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "23", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "24", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "25", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "26", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "27", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "28", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "29", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "30", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "31", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "32", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "33", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "34", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "35", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "36", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "37", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "38", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "39", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "40", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "41", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "42", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "43", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "44", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "45", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "46", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "47", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "48", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "49", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "50", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "51", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "52", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "53", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "54", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "55", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "56", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "57", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "58", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "59", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "60", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "61", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "62", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "63", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "64", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "65", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "66", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "67", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "68", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "69", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "70", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "71", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "72", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "73", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "74", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"0.`", "\[VeryThinSpace]", "-", 
     RowBox[{"1.`", " ", 
      RowBox[{"x", "[", "75", "]"}]}]}], "<", "0.`"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "1", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "2", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "3", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "4", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "5", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "6", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "7", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "8", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "9", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "10", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "11", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "12", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "13", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "14", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "15", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "16", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "17", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "18", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "19", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "20", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "21", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "22", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "23", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "24", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "25", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "26", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "27", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "28", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "29", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "30", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "31", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "32", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "33", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "34", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "35", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "36", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "37", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "38", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "39", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "40", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "41", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "42", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "43", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "44", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "45", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "46", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "47", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "48", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "49", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "50", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "51", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "52", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "53", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "54", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "55", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "56", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "57", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "58", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "59", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "60", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "61", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "62", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "63", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "64", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "65", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "66", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "67", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "68", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "69", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "70", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "71", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "72", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "73", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "74", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "75", "]"}], "\[GreaterEqual]", 
    RowBox[{"-", "10"}]}], ",", 
   RowBox[{
    RowBox[{"x", "[", "1", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "2", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "3", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "4", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "5", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "6", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "7", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "8", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "9", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "10", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "11", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "12", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "13", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "14", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "15", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "16", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "17", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "18", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "19", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "20", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "21", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "22", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "23", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "24", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "25", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "26", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "27", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "28", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "29", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "30", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "31", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "32", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "33", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "34", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "35", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "36", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "37", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "38", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "39", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "40", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "41", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "42", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "43", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "44", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "45", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "46", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "47", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "48", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "49", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "50", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "51", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "52", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "53", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "54", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "55", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "56", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "57", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "58", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "59", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "60", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "61", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "62", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "63", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "64", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "65", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "66", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "67", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "68", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "69", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "70", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "71", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "72", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "73", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "74", "]"}], "\[LessEqual]", "10"}], ",", 
   RowBox[{
    RowBox[{"x", "[", "75", "]"}], "\[LessEqual]", "10"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6247946081349006`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ret", " ", "=", " ", 
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"0.5", " ", "*", " ", 
        RowBox[{"X", ".", "P", ".", "X"}]}], " ", "+", " ", 
       RowBox[{"q", ".", "X"}]}], ",", " ", "myConstraints"}], "}"}], ",", 
    "X"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6120115155335717`*^9, 3.6120115387578044`*^9}, {
  3.612011648070901*^9, 3.6120116489109097`*^9}, {3.624435266343229*^9, 
  3.624435267684231*^9}, {3.6247943614508977`*^9, 3.6247943644120164`*^9}, {
  3.624794529591631*^9, 3.6247945400540495`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20.705990538560243`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "\[Rule]", "0.0008943942499386661`"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "2", "]"}], "\[Rule]", 
      RowBox[{"-", "0.04193883812510348`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "3", "]"}], "\[Rule]", 
      RowBox[{"-", "0.07530903776298818`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "4", "]"}], "\[Rule]", "0.1215921298990888`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "5", "]"}], "\[Rule]", "0.03747292562614292`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "6", "]"}], "\[Rule]", "0.04989103205877819`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0.09029716201655216`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "8", "]"}], "\[Rule]", "0.9572731522100736`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "9", "]"}], "\[Rule]", "0.00501991101423741`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "10", "]"}], "\[Rule]", "0.05273197597255766`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "11", "]"}], "\[Rule]", "0.04915574720962175`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "12", "]"}], "\[Rule]", "0.07207950472322847`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "13", "]"}], "\[Rule]", 
      RowBox[{"-", "0.10199682148825218`"}]}], ",", 
     RowBox[{
      RowBox[{"x", "[", "14", "]"}], "\[Rule]", "0.04064353226499076`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "15", "]"}], "\[Rule]", "0.015521222302583782`"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "16", "]"}], "\[Rule]", "2.6321819918069333`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "17", "]"}], "\[Rule]", "2.889250047270421`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "18", "]"}], "\[Rule]", "2.5774262676336857`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "19", "]"}], "\[Rule]", "2.6718445410817638`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "20", "]"}], "\[Rule]", "2.106401358421313`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "21", "]"}], "\[Rule]", "2.6692930437338857`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "22", "]"}], "\[Rule]", "2.670732751916645`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "23", "]"}], "\[Rule]", "2.657607191544722`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "24", "]"}], "\[Rule]", "2.610756580844146`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "25", "]"}], "\[Rule]", "1.6290962640236857`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "26", "]"}], "\[Rule]", "4.827352273521974`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "27", "]"}], "\[Rule]", "0.07499992772019835`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "28", "]"}], "\[Rule]", "2.6486391682554983`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "29", "]"}], "\[Rule]", "1.7223492319139178`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "30", "]"}], "\[Rule]", "1.6777344737533135`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "31", "]"}], "\[Rule]", "2.6643310882853834`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "32", "]"}], "\[Rule]", "2.671603848091396`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "33", "]"}], "\[Rule]", "0.05868007231359109`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "34", "]"}], "\[Rule]", "2.671965833401902`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "35", "]"}], "\[Rule]", "2.6595995916028562`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "36", "]"}], "\[Rule]", "2.594320019748149`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "37", "]"}], "\[Rule]", "2.5942833593942506`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "38", "]"}], "\[Rule]", "1.779776938118189`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "39", "]"}], "\[Rule]", "1.7624319375077537`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "40", "]"}], "\[Rule]", "7.905333453044552`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "41", "]"}], "\[Rule]", "2.6516167604155164`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "42", "]"}], "\[Rule]", "0.07902334533758937`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "43", "]"}], "\[Rule]", "2.0117322729270204`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "44", "]"}], "\[Rule]", "5.764086555022169`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "45", "]"}], "\[Rule]", "2.669863777618322`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "46", "]"}], "\[Rule]", "0.153664682272932`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "47", "]"}], "\[Rule]", "2.6071981443706994`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "48", "]"}], "\[Rule]", "5.8810940080971324`*^-8"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "49", "]"}], "\[Rule]", "0.10209480133328529`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "50", "]"}], "\[Rule]", "2.656131422765969`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "51", "]"}], "\[Rule]", "6.492871732357854`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "52", "]"}], "\[Rule]", "4.402304598489823`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "53", "]"}], "\[Rule]", "6.011488231672124`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "54", "]"}], "\[Rule]", "1.9411930146878091`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "55", "]"}], "\[Rule]", "2.6714915146478937`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "56", "]"}], "\[Rule]", "2.6547337028970867`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "57", "]"}], "\[Rule]", "1.8072088008858886`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "58", "]"}], "\[Rule]", "0.1077926054860464`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "59", "]"}], "\[Rule]", "0.027472675569383938`"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "60", "]"}], "\[Rule]", "2.6649802175608737`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "61", "]"}], "\[Rule]", "2.6286070497913168`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "62", "]"}], "\[Rule]", "1.7753624377023294`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "63", "]"}], "\[Rule]", "0.037883627196893845`"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "64", "]"}], "\[Rule]", "0.027088154920635446`"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "65", "]"}], "\[Rule]", "2.6539413293766656`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "66", "]"}], "\[Rule]", "0.1154607431070039`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "67", "]"}], "\[Rule]", "0.09792770587996835`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "68", "]"}], "\[Rule]", "2.665929004553053`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "69", "]"}], "\[Rule]", "2.6506457401664773`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "70", "]"}], "\[Rule]", "2.6529796582631257`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "71", "]"}], "\[Rule]", "2.6643061623302924`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "72", "]"}], "\[Rule]", "0.29872106784610325`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "73", "]"}], "\[Rule]", "0.014793338054486991`"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "74", "]"}], "\[Rule]", "5.733666737824615`*^-9"}], 
     ",", 
     RowBox[{
      RowBox[{"x", "[", "75", "]"}], "\[Rule]", "2.6618060870934483`*^-9"}]}],
     "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.6247951316771836`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", " ", "=", " ", 
  RowBox[{"Flatten", "[", 
   RowBox[{"X", "/.", 
    RowBox[{"Take", "[", 
     RowBox[{"ret", ",", " ", 
      RowBox[{"{", 
       RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"Take", "[", 
   RowBox[{"ret", ",", " ", 
    RowBox[{"{", 
     RowBox[{"1", ",", "1"}], "}"}]}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.0008943942499386661`", ",", 
   RowBox[{"-", "0.04193883812510348`"}], ",", 
   RowBox[{"-", "0.07530903776298818`"}], ",", "0.1215921298990888`", ",", 
   "0.03747292562614292`", ",", "0.04989103205877819`", ",", 
   "0.09029716201655216`", ",", "0.9572731522100736`", ",", 
   "0.00501991101423741`", ",", "0.05273197597255766`", ",", 
   "0.04915574720962175`", ",", "0.07207950472322847`", ",", 
   RowBox[{"-", "0.10199682148825218`"}], ",", "0.04064353226499076`", ",", 
   "0.015521222302583782`", ",", "2.6321819918069333`*^-9", ",", 
   "2.889250047270421`*^-9", ",", "2.5774262676336857`*^-9", ",", 
   "2.6718445410817638`*^-9", ",", "2.106401358421313`", ",", 
   "2.6692930437338857`*^-9", ",", "2.670732751916645`*^-9", ",", 
   "2.657607191544722`*^-9", ",", "2.610756580844146`*^-9", ",", 
   "1.6290962640236857`", ",", "4.827352273521974`*^-9", ",", 
   "0.07499992772019835`", ",", "2.6486391682554983`*^-9", ",", 
   "1.7223492319139178`", ",", "1.6777344737533135`", ",", 
   "2.6643310882853834`*^-9", ",", "2.671603848091396`*^-9", ",", 
   "0.05868007231359109`", ",", "2.671965833401902`*^-9", ",", 
   "2.6595995916028562`*^-9", ",", "2.594320019748149`*^-9", ",", 
   "2.5942833593942506`*^-9", ",", "1.779776938118189`", ",", 
   "1.7624319375077537`*^-9", ",", "7.905333453044552`*^-9", ",", 
   "2.6516167604155164`*^-9", ",", "0.07902334533758937`", ",", 
   "2.0117322729270204`", ",", "5.764086555022169`*^-9", ",", 
   "2.669863777618322`*^-9", ",", "0.153664682272932`", ",", 
   "2.6071981443706994`*^-9", ",", "5.8810940080971324`*^-8", ",", 
   "0.10209480133328529`", ",", "2.656131422765969`*^-9", ",", 
   "6.492871732357854`*^-9", ",", "4.402304598489823`*^-9", ",", 
   "6.011488231672124`*^-9", ",", "1.9411930146878091`", ",", 
   "2.6714915146478937`*^-9", ",", "2.6547337028970867`*^-9", ",", 
   "1.8072088008858886`*^-9", ",", "0.1077926054860464`", ",", 
   "0.027472675569383938`", ",", "2.6649802175608737`*^-9", ",", 
   "2.6286070497913168`*^-9", ",", "1.7753624377023294`", ",", 
   "0.037883627196893845`", ",", "0.027088154920635446`", ",", 
   "2.6539413293766656`*^-9", ",", "0.1154607431070039`", ",", 
   "0.09792770587996835`", ",", "2.665929004553053`*^-9", ",", 
   "2.6506457401664773`*^-9", ",", "2.6529796582631257`*^-9", ",", 
   "2.6643061623302924`*^-9", ",", "0.29872106784610325`", ",", 
   "0.014793338054486991`", ",", "5.733666737824615`*^-9", ",", 
   "2.6618060870934483`*^-9"}], "}"}]], "Output",
 CellChangeTimes->{3.624795149850729*^9}],

Cell[BoxData[
 RowBox[{"{", "20.705990538560243`", "}"}]], "Output",
 CellChangeTimes->{3.624795149850729*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}]}], "Input"],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\qp\\\\value4.txt\"\>"], "Output",
 CellChangeTimes->{3.624795157961972*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\qp\\\\sol4.txt\"\>"], "Output",
 CellChangeTimes->{3.624795157981973*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"G", ".", "mySol"}], "-", "h"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{
   RowBox[{"G", ".", "mySol"}], "-", "h"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6119261115754623`*^9, 3.6119261153118362`*^9}, {
  3.611926168483153*^9, 3.6119261711774225`*^9}, {3.624794564448028*^9, 
  3.6247945758004827`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "0.029315029557771544`"}], ",", 
   RowBox[{"-", "3.313252827652491`*^-8"}], ",", 
   RowBox[{"-", "0.013417349422339298`"}], ",", 
   RowBox[{"-", "0.13413133571271096`"}], ",", 
   RowBox[{"-", "2.6820408116634553`*^-9"}], ",", 
   RowBox[{"-", "0.10874010155946023`"}], ",", 
   RowBox[{"-", "0.12237868238992844`"}], ",", 
   RowBox[{"-", "0.058838087314448506`"}], ",", 
   RowBox[{"-", "0.01951890715167992`"}], ",", 
   RowBox[{"-", "2.681831423601011`*^-9"}], ",", 
   RowBox[{"-", "5.712281758718518`*^-9"}], ",", 
   RowBox[{"-", "2.663293141580425`*^-9"}], ",", 
   RowBox[{"-", "0.04313991576872156`"}], ",", 
   RowBox[{"-", "2.6818807175033044`*^-9"}], ",", 
   RowBox[{"-", "2.681857846908997`*^-9"}], ",", 
   RowBox[{"-", "0.07907996339889234`"}], ",", 
   RowBox[{"-", "0.1312219054557484`"}], ",", 
   RowBox[{"-", "2.6578872436289203`*^-9"}], ",", 
   RowBox[{"-", "0.13531472267522382`"}], ",", 
   RowBox[{"-", "0.06238815764800876`"}], ",", 
   RowBox[{"-", "0.01632126476390372`"}], ",", 
   RowBox[{"-", "0.016549529662460705`"}], ",", 
   RowBox[{"-", "2.681908695123525`*^-9"}], ",", 
   RowBox[{"-", "0.00001554929499980595`"}], ",", 
   RowBox[{"-", "2.4467219361667958`*^-9"}], ",", 
   RowBox[{"-", "0.04658591834261139`"}], ",", 
   RowBox[{"-", "2.6641397976590042`*^-9"}], ",", 
   RowBox[{"-", "2.6820070608835067`*^-9"}], ",", 
   RowBox[{"-", "4.453462487674642`*^-9"}], ",", 
   RowBox[{"-", "0.11334987426700249`"}], ",", 
   RowBox[{"-", "2.6732844826682367`*^-9"}], ",", 
   RowBox[{"-", "0.019298912819116554`"}], ",", 
   RowBox[{"-", "2.713741675819392`*^-9"}], ",", 
   RowBox[{"-", "2.668595566746035`*^-9"}], ",", 
   RowBox[{"-", "0.05419046086500878`"}], ",", 
   RowBox[{"-", "4.49275838754204`*^-9"}], ",", 
   RowBox[{"-", "4.121144314694902`*^-9"}], ",", 
   RowBox[{"-", "4.445795065421976`*^-9"}], ",", 
   RowBox[{"-", "2.6819788612186812`*^-9"}], ",", 
   RowBox[{"-", "0.12999252447118037`"}], ",", 
   RowBox[{"-", "0.05158798311506785`"}], ",", 
   RowBox[{"-", "8.808461959830538`*^-9"}], ",", 
   RowBox[{"-", "2.66933564141425`*^-9"}], ",", 
   RowBox[{"-", "2.6288791143969092`*^-9"}], ",", 
   RowBox[{"-", "0.08162740851437222`"}], ",", 
   RowBox[{"-", "0.02634626378364313`"}], ",", 
   RowBox[{"-", "2.681906030588266`*^-9"}], ",", 
   RowBox[{"-", "2.643653962408621`*^-9"}], ",", 
   RowBox[{"-", "2.6281077314393997`*^-9"}], ",", 
   RowBox[{"-", "0.05021899648348027`"}], ",", 
   RowBox[{"-", "2.6702169364511974`*^-9"}], ",", 
   RowBox[{"-", "2.667816190182748`*^-9"}], ",", 
   RowBox[{"-", "0.08784074284623733`"}], ",", 
   RowBox[{"-", "0.04436901072920407`"}], ",", 
   RowBox[{"-", "0.04928240912806747`"}], ",", 
   RowBox[{"-", "0.07895851574894364`"}], ",", 
   RowBox[{"-", "2.6778284034634225`*^-9"}], ",", 
   RowBox[{"-", "2.581280078572945`*^-9"}], ",", 
   RowBox[{"-", "1.8105741350638027`*^-9"}], ",", 
   RowBox[{"-", "0.0695995087656629`"}], ",", 
   RowBox[{"-", "2.6321819918069333`*^-9"}], ",", 
   RowBox[{"-", "2.889250047270421`*^-9"}], ",", 
   RowBox[{"-", "2.5774262676336857`*^-9"}], ",", 
   RowBox[{"-", "2.6718445410817638`*^-9"}], ",", 
   RowBox[{"-", "2.106401358421313`"}], ",", 
   RowBox[{"-", "2.6692930437338857`*^-9"}], ",", 
   RowBox[{"-", "2.670732751916645`*^-9"}], ",", 
   RowBox[{"-", "2.657607191544722`*^-9"}], ",", 
   RowBox[{"-", "2.610756580844146`*^-9"}], ",", 
   RowBox[{"-", "1.6290962640236857`"}], ",", 
   RowBox[{"-", "4.827352273521974`*^-9"}], ",", 
   RowBox[{"-", "0.07499992772019835`"}], ",", 
   RowBox[{"-", "2.6486391682554983`*^-9"}], ",", 
   RowBox[{"-", "1.7223492319139178`"}], ",", 
   RowBox[{"-", "1.6777344737533135`"}], ",", 
   RowBox[{"-", "2.6643310882853834`*^-9"}], ",", 
   RowBox[{"-", "2.671603848091396`*^-9"}], ",", 
   RowBox[{"-", "0.05868007231359109`"}], ",", 
   RowBox[{"-", "2.671965833401902`*^-9"}], ",", 
   RowBox[{"-", "2.6595995916028562`*^-9"}], ",", 
   RowBox[{"-", "2.594320019748149`*^-9"}], ",", 
   RowBox[{"-", "2.5942833593942506`*^-9"}], ",", 
   RowBox[{"-", "1.779776938118189`"}], ",", 
   RowBox[{"-", "1.7624319375077537`*^-9"}], ",", 
   RowBox[{"-", "7.905333453044552`*^-9"}], ",", 
   RowBox[{"-", "2.6516167604155164`*^-9"}], ",", 
   RowBox[{"-", "0.07902334533758937`"}], ",", 
   RowBox[{"-", "2.0117322729270204`"}], ",", 
   RowBox[{"-", "5.764086555022169`*^-9"}], ",", 
   RowBox[{"-", "2.669863777618322`*^-9"}], ",", 
   RowBox[{"-", "0.153664682272932`"}], ",", 
   RowBox[{"-", "2.6071981443706994`*^-9"}], ",", 
   RowBox[{"-", "5.8810940080971324`*^-8"}], ",", 
   RowBox[{"-", "0.10209480133328529`"}], ",", 
   RowBox[{"-", "2.656131422765969`*^-9"}], ",", 
   RowBox[{"-", "6.492871732357854`*^-9"}], ",", 
   RowBox[{"-", "4.402304598489823`*^-9"}], ",", 
   RowBox[{"-", "6.011488231672124`*^-9"}], ",", 
   RowBox[{"-", "1.9411930146878091`"}], ",", 
   RowBox[{"-", "2.6714915146478937`*^-9"}], ",", 
   RowBox[{"-", "2.6547337028970867`*^-9"}], ",", 
   RowBox[{"-", "1.8072088008858886`*^-9"}], ",", 
   RowBox[{"-", "0.1077926054860464`"}], ",", 
   RowBox[{"-", "0.027472675569383938`"}], ",", 
   RowBox[{"-", "2.6649802175608737`*^-9"}], ",", 
   RowBox[{"-", "2.6286070497913168`*^-9"}], ",", 
   RowBox[{"-", "1.7753624377023294`"}], ",", 
   RowBox[{"-", "0.037883627196893845`"}], ",", 
   RowBox[{"-", "0.027088154920635446`"}], ",", 
   RowBox[{"-", "2.6539413293766656`*^-9"}], ",", 
   RowBox[{"-", "0.1154607431070039`"}], ",", 
   RowBox[{"-", "0.09792770587996835`"}], ",", 
   RowBox[{"-", "2.665929004553053`*^-9"}], ",", 
   RowBox[{"-", "2.6506457401664773`*^-9"}], ",", 
   RowBox[{"-", "2.6529796582631257`*^-9"}], ",", 
   RowBox[{"-", "2.6643061623302924`*^-9"}], ",", 
   RowBox[{"-", "0.29872106784610325`"}], ",", 
   RowBox[{"-", "0.014793338054486991`"}], ",", 
   RowBox[{"-", "5.733666737824615`*^-9"}], ",", 
   RowBox[{"-", "2.6618060870934483`*^-9"}]}], "}"}]], "Output",
 CellChangeTimes->{3.624795160613052*^9}],

Cell[BoxData[
 RowBox[{"-", "1.7624319375077537`*^-9"}]], "Output",
 CellChangeTimes->{3.624795160613052*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 871},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 306, 9, 171, "Subtitle"],
Cell[CellGroupData[{
Cell[910, 35, 4304, 124, 382, "Input"],
Cell[5217, 161, 172, 2, 36, "Output"],
Cell[5392, 165, 80, 1, 36, "Output"],
Cell[5475, 168, 73, 1, 36, "Output"],
Cell[5551, 171, 1063, 16, 83, "Output"],
Cell[6617, 189, 89539, 2508, 3625, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96193, 2702, 608, 14, 36, "Input"],
Cell[96804, 2718, 7631, 203, 375, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[104472, 2926, 428, 13, 60, "Input"],
Cell[104903, 2941, 2558, 41, 233, "Output"],
Cell[107464, 2984, 110, 2, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[107611, 2991, 526, 14, 60, "Input"],
Cell[108140, 3007, 180, 2, 36, "Output"],
Cell[108323, 3011, 178, 2, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[108538, 3018, 358, 8, 60, "Input"],
Cell[108899, 3028, 6024, 123, 403, "Output"],
Cell[114926, 3153, 109, 2, 70, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
