(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32438,        809]
NotebookOptionsPosition[     31263,        768]
NotebookOutlinePosition[     31684,        784]
CellTagsIndexPosition[     31641,        781]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the QP problem defined by:
min(0.5 * X.P.X) s.t.
G.x < h
A.x = b
lb <= x <= ub\
\>", "Subtitle",
 CellChangeTimes->{
  3.6157155673595924`*^9, 3.6244352891392612`*^9, {3.6244353215343065`*^9, 
   3.6244353216643066`*^9}, {3.6247068148144536`*^9, 3.6247068155144677`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myProblemId", " ", "=", " ", 
  RowBox[{"ToString", "[", "\"\<3\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<P\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "P", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Eigenvalues", "[", "P", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"x", "[", "i", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], 
  StyleBox[";", "MR"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<G\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<h\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<A\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<b\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lb", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<lb\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"+", 
       StyleBox["9999", "MR"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ub", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<ub\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"-", 
       StyleBox["9999", "MR"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GX", "=", 
   RowBox[{"G", ".", "X"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"GX", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "<", 
      RowBox[{"h", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "h", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AX", "=", 
   RowBox[{"A", ".", "X"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"AConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"AX", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "==", 
      RowBox[{"b", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"LBConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[GreaterEqual]", 
      RowBox[{"lb", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"UBConstraints", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"X", "[", 
       RowBox[{"[", "i", "]"}], "]"}], "\[LessEqual]", " ", 
      RowBox[{"ub", "[", 
       RowBox[{"[", "i", "]"}], "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"myConstraints", " ", "=", " ", 
  RowBox[{"Join", "[", 
   RowBox[{
   "GConstraints", ",", " ", "AConstraints", ",", " ", "LBConstraints", ",", 
    " ", "UBConstraints"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6247062852568398`*^9, 3.6247062853268423`*^9}, {
   3.6247063489393873`*^9, 3.6247064123029222`*^9}, {3.6247065988861322`*^9, 
   3.6247066683185215`*^9}, 3.6247068554612665`*^9, {3.624706935964878*^9, 
   3.624706959139896*^9}, 3.6247070113293753`*^9, {3.6254049219332933`*^9, 
   3.625404949525567*^9}, {3.625843441352788*^9, 3.6258434478136587`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\qp\\\\\"\>"], "Output",
 CellChangeTimes->{
  3.624706772567608*^9, 3.6247068588813353`*^9, {3.6247069372749043`*^9, 
   3.624706960610219*^9}}],

Cell[BoxData["\<\"3\"\>"], "Output",
 CellChangeTimes->{
  3.624706772567608*^9, 3.6247068588813353`*^9, {3.6247069372749043`*^9, 
   3.624706960610219*^9}}],

Cell[BoxData["27"], "Output",
 CellChangeTimes->{
  3.624706772567608*^9, 3.6247068588813353`*^9, {3.6247069372749043`*^9, 
   3.6247069606302233`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "9.767634955575534`*^13", ",", "8.071826192412642`*^13", ",", 
   "6.713771212486221`*^13", ",", "5.708223044065524`*^13", ",", 
   "4.441984997426072`*^13", ",", "3.684057556707827`*^13", ",", 
   "3.1516305377063984`*^13", ",", "2.636280577555684`*^13", ",", 
   "2.278645843908355`*^13", ",", "2.0196558116909945`*^13", ",", 
   "1.683422373551858`*^13", ",", "1.4121087410791512`*^13", ",", 
   "1.1790563986135725`*^13", ",", "9.581339816432395`*^12", ",", 
   "7.796159818700883`*^12", ",", "6.16882563830036`*^12", ",", 
   "4.788113365784682`*^12", ",", "3.683282811043441`*^12", ",", 
   "2.5709839189254053`*^12", ",", "1.8332809380315515`*^12", ",", 
   "1.2074516963191948`*^12", ",", "7.537800054005222`*^11", ",", 
   "4.3506849768814154`*^11", ",", "2.0487997364991083`*^11", ",", 
   "5.611324839996117`*^10", ",", 
   RowBox[{"-", "421535.6646032096`"}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.624706772567608*^9, 3.6247068588813353`*^9, {3.6247069372749043`*^9, 
   3.624706960640226*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", " ", "=", " ", 
  RowBox[{"Minimize", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"0.5", " ", "*", " ", 
       RowBox[{"X", ".", "P", ".", "X"}]}], ",", " ", "myConstraints"}], 
     "}"}], ",", "X"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"mySol", ".", "P", ".", "mySol"}]}]}], "Input",
 CellChangeTimes->{{3.6120115155335717`*^9, 3.6120115387578044`*^9}, {
  3.612011648070901*^9, 3.6120116489109097`*^9}, {3.624435266343229*^9, 
  3.624435267684231*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NMinimize", "::", "incst"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"\[NoBreak]\\!\\(NMinimize\\)\[NoBreak] was unable to \
generate any initial points satisfying the inequality constraints \
\[NoBreak]\\!\\({\\(\\(\\(\\(\\(\\(-1\\)\\) + \\(\\(708422.9929`\\\\ \
\\(\\(x[3]\\)\\)\\)\\) + \\(\\(1.129808981`*^6\\\\ \\(\\(x[4]\\)\\)\\)\\) + \
\\(\\(1.38418199`*^6\\\\ \\(\\(x[5]\\)\\)\\)\\) + \\(\\(1.670073038`*^6\\\\ \
\\(\\(x[6]\\)\\)\\)\\) + \\(\\(1.778967017`*^6\\\\ \\(\\(x[7]\\)\\)\\)\\) + \
\\(\\(1.56112498`*^6\\\\ \\(\\(x[8]\\)\\)\\)\\) + \\(\\(1.004844003`*^6\\\\ \
\\(\\(x[9]\\)\\)\\)\\) + \\(\\(\[LeftSkeleton] 9 \[RightSkeleton]\\)\\) + \\(\
\\(335106.0027`\\\\ \\(\\(x[19]\\)\\)\\)\\) + \\(\\(325110.0012`\\\\ \
\\(\\(x[20]\\)\\)\\)\\) + \\(\\(298709.9965`\\\\ \\(\\(x[21]\\)\\)\\)\\) + \
\\(\\(330431.996`\\\\ \\(\\(x[22]\\)\\)\\)\\) + \\(\\(332652.0015`\\\\ \
\\(\\(x[23]\\)\\)\\)\\) + \\(\\(288843.0063`\\\\ \\(\\(x[24]\\)\\)\\)\\) + \
\\(\\(290288.9975`\\\\ \\(\\(x[25]\\)\\)\\)\\) + \\(\\(306455.9965`\\\\ \
\\(\\(x[26]\\)\\)\\)\\)\\)\\) \[LessEqual] 0\\)\\), \
\\(\\(\\(\\(\\(\\(-2.7589543`*^6\\)\\) + \\(\\(\[LeftSkeleton] 22 \
\[RightSkeleton]\\)\\) + \\(\\(\[LeftSkeleton] 1 \[RightSkeleton]\\)\\)\\)\\) \
\[LessEqual] 0\\)\\)}\\)\[NoBreak]. The initial region specified may not \
contain any feasible points. Changing the initial region or specifying \
explicit initial points may provide a better solution. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NMinimize/incst\\\", \
ButtonNote -> \\\"NMinimize::incst\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.624706873914636*^9, 3.6247069892805257`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.`", ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "[", "1", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "2", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "3", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "4", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "5", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "6", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "8", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "9", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "10", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "11", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "12", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "13", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "14", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "15", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "16", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "17", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "18", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "19", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "20", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "21", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "22", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "23", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "24", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "25", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "26", "]"}], "\[Rule]", "0.`"}], ",", 
     RowBox[{
      RowBox[{"x", "[", "27", "]"}], "\[Rule]", "0.4587218449201491`"}]}], 
    "}"}]}], "}"}]], "Output",
 CellChangeTimes->{3.624706892908016*^9, 3.624706997124251*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Dot", "::", "rect"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Nonrectangular tensor encountered. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Dot/rect\\\", ButtonNote -> \
\\\"Dot::rect\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.624706873914636*^9, 3.624706997154258*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Dot", "::", "rect"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Nonrectangular tensor encountered. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Dot/rect\\\", ButtonNote -> \
\\\"Dot::rect\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.624706873914636*^9, 3.624706997184264*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"0.`", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "9", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "10", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "11", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "12", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "13", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "14", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "15", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "16", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "17", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "18", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "19", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "20", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "21", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "22", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "23", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "24", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "25", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "26", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "27", "]"}], "\[Rule]", "0.4587218449201491`"}]}], 
     "}"}]}], "}"}], ".", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"96214734939", ",", 
      RowBox[{"-", "1.73411`*^11"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1.73411`*^11"}], ",", "6.25087`*^11", ",", 
      RowBox[{"-", "4.69179`*^11"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "4.69179`*^11"}], ",", "1.40863`*^12", ",", 
      RowBox[{"-", "9.54188`*^11"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", 
      RowBox[{"-", "9.54188`*^11"}], ",", "2.58542`*^12", ",", 
      RowBox[{"-", "1.58982`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1.58982`*^12"}], ",", "3.91045`*^12", ",", 
      RowBox[{"-", "2.35227`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "2.35227`*^12"}], ",", "5.65989`*^12", ",", 
      RowBox[{"-", "3.04477`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "3.04477`*^12"}], ",", "6.55182`*^12", ",", 
      RowBox[{"-", "3.88122`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "3.88122`*^12"}], ",", "9.19675`*^12", ",", 
      RowBox[{"-", "5.12192`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "5.12192`*^12"}], ",", "1.14101`*^13", ",", 
      RowBox[{"-", "6.0809`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", 
      RowBox[{"-", "6.0809`*^12"}], ",", "1.2963`*^13", ",", 
      RowBox[{"-", "6.04674`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", 
      RowBox[{"-", "6.04674`*^12"}], ",", "1.12823`*^13", ",", 
      RowBox[{"-", "6.27352`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "6.27352`*^12"}], ",", "1.39536`*^13", ",", 
      RowBox[{"-", "7.27115`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "7.27115`*^12"}], ",", "1.51558`*^13", ",", 
      RowBox[{"-", "8.47323`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "8.47323`*^12"}], ",", "1.89486`*^13", ",", 
      RowBox[{"-", "9.78867`*^12"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "9.78867`*^12"}], ",", "2.02269`*^13", ",", 
      RowBox[{"-", "1.0231`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], 
     "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1.0231`*^13"}], ",", "2.06999`*^13", ",", 
      RowBox[{"-", "1.11136`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", 
      RowBox[{"-", "1.11136`*^13"}], ",", "2.38671`*^13", ",", 
      RowBox[{"-", "1.46327`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", 
      RowBox[{"-", "1.46327`*^13"}], ",", "3.58844`*^13", ",", 
      RowBox[{"-", "1.82323`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1.82323`*^13"}], ",", "3.7054`*^13", ",", 
      RowBox[{"-", "1.93165`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "1.93165`*^13"}], ",", "4.02795`*^13", ",", 
      RowBox[{"-", "2.16103`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "2.16103`*^13"}], ",", "4.63765`*^13", ",", 
      RowBox[{"-", "2.23837`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0", 
      ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "2.23837`*^13"}], ",", "4.32143`*^13", ",", 
      RowBox[{"-", "2.19534`*^13"}], ",", "0", ",", "0", ",", "0", ",", "0"}],
      "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "2.19534`*^13"}], ",", "4.46103`*^13", ",", 
      RowBox[{"-", "2.48435`*^13"}], ",", "0", ",", "0", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", 
      RowBox[{"-", "2.48435`*^13"}], ",", "5.53417`*^13", ",", 
      RowBox[{"-", "2.81798`*^13"}], ",", "0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", 
      RowBox[{"-", "2.81798`*^13"}], ",", "5.73961`*^13", ",", 
      RowBox[{"-", "2.82779`*^13"}], ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", 
      RowBox[{"-", "2.82779`*^13"}], ",", "2.78639`*^13", ",", "0"}], "}"}], 
    ",", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}]}], "}"}],
   ".", 
  RowBox[{"{", 
   RowBox[{"0.`", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "[", "1", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "2", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "3", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "4", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "5", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "6", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "7", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "8", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "9", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "10", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "11", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "12", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "13", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "14", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "15", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "16", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "17", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "18", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "19", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "20", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "21", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "22", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "23", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "24", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "25", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "26", "]"}], "\[Rule]", "0.`"}], ",", 
      RowBox[{
       RowBox[{"x", "[", "27", "]"}], "\[Rule]", "0.4587218449201491`"}]}], 
     "}"}]}], "}"}]}]], "Output",
 CellChangeTimes->{3.624706892908016*^9, 3.6247069972042685`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", 
   RowBox[{"Take", "[", 
    RowBox[{"mySol", ",", " ", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "]"}], " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", 
   RowBox[{"Flatten", "[", 
    RowBox[{"X", "/.", 
     RowBox[{"Take", "[", 
      RowBox[{"mySol", ",", " ", 
       RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}]}], "]"}]}], "]"}], ",", " ", 
   "\"\<Lines\>\""}], "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"G", ".", "mySol"}], "-", "h"}]], "Input",
 CellChangeTimes->{{3.6119261115754623`*^9, 3.6119261153118362`*^9}, {
  3.611926168483153*^9, 3.6119261711774225`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "566850.7376532247`"}], ",", 
   RowBox[{"-", "682453.2880797144`"}], ",", 
   RowBox[{"-", "879812.7151676025`"}], ",", 
   RowBox[{"-", "442253.2769695553`"}], ",", 
   RowBox[{"-", "433149.2623467754`"}], ",", 
   RowBox[{"-", "317546.71192028583`"}], ",", 
   RowBox[{"-", "120187.28483239724`"}], ",", 
   RowBox[{"-", "557746.7230304447`"}], ",", 
   RowBox[{"-", "10001.704785110607`"}], ",", 
   RowBox[{"-", "9998.295214889393`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.611926117243029*^9, 3.611926172774582*^9, 
  3.611926702830582*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}]], "Input",
 CellChangeTimes->{{3.6119261938736916`*^9, 3.61192620125843*^9}, {
  3.611926683238623*^9, 3.611926687177017*^9}, {3.6119274281041794`*^9, 
  3.61192742983418*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4.440892098500626`*^-16"}], ",", 
   RowBox[{"-", "9.313225746154785`*^-10"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6119262027125754`*^9, {3.6119266889961987`*^9, 3.611926702850584*^9}, 
   3.6119274307921796`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 871},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 288, 9, 207, "Subtitle"],
Cell[CellGroupData[{
Cell[892, 35, 5366, 157, 451, "Input"],
Cell[6261, 194, 249, 4, 36, "Output"],
Cell[6513, 200, 157, 3, 36, "Output"],
Cell[6673, 205, 152, 3, 36, "Output"],
Cell[6828, 210, 1066, 19, 115, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7931, 234, 552, 13, 60, "Input"],
Cell[8486, 249, 1774, 27, 111, "Message"],
Cell[10263, 278, 2259, 60, 83, "Output"],
Cell[12525, 340, 424, 9, 27, "Message"],
Cell[12952, 351, 424, 9, 27, "Message"],
Cell[13379, 362, 15622, 330, 879, "Output"]
}, Open  ]],
Cell[29016, 695, 377, 11, 36, "Input"],
Cell[29396, 708, 439, 13, 36, "Input"],
Cell[CellGroupData[{
Cell[29860, 725, 197, 4, 36, "Input"],
Cell[30060, 731, 605, 14, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30702, 750, 252, 5, 36, "Input"],
Cell[30957, 757, 278, 7, 41, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
