(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26150,        548]
NotebookOptionsPosition[     25105,        510]
NotebookOutlinePosition[     25526,        526]
CellTagsIndexPosition[     25483,        523]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the LP problem defined by:
min(c) s.t.
G.x < h
A.x = b
lb <= x <= ub\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myProblemId", " ", "=", " ", 
  RowBox[{"ToString", "[", "\"\<4\>\"", "]"}]}]}], "Input",
 CellChangeTimes->{{3.6254059199172297`*^9, 3.6254059220502977`*^9}, 
   3.625406056421483*^9, 3.625406601846853*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\\"\>"], "Output",
 CellChangeTimes->{3.625405962650591*^9, 3.6254060155982103`*^9, 
  3.625406057369512*^9, 3.6254061265556583`*^9, 3.6254066052469273`*^9, 
  3.625406665920236*^9, 3.6254080129905844`*^9}],

Cell[BoxData["\<\"4\"\>"], "Output",
 CellChangeTimes->{3.625405962650591*^9, 3.6254060155982103`*^9, 
  3.625406057369512*^9, 3.6254061265556583`*^9, 3.6254066052469273`*^9, 
  3.625406665920236*^9, 3.6254080129905844`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<c\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "c", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<G\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<h\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "h", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<A\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<b\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GA", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"G", ",", " ", "A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hbCoeff", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"hCoeff", ",", " ", "bCoeff"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"lb", "=", 
  RowBox[{
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<lb\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"\"\<NaN\>\"", "\[Rule]", 
     RowBox[{"-", 
      StyleBox["99999999", "MR"]}]}], 
    StyleBox["}", "MR"]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ub", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<ub\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"+", 
       StyleBox["99999999", "MR"]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"variablesBounds", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lb", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       RowBox[{"ub", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.625405933230653*^9, 3.6254059565343976`*^9}, {
   3.625406038750945*^9, 3.6254060407110047`*^9}, {3.625406077775134*^9, 
   3.625406111672184*^9}, {3.6254061540085263`*^9, 3.6254061540885286`*^9}, {
   3.6254062424632826`*^9, 3.6254063763174734`*^9}, {3.6254064292541423`*^9, 
   3.6254064712210736`*^9}, 3.6254065048107886`*^9}],

Cell[BoxData["358"], "Output",
 CellChangeTimes->{{3.6254061127082167`*^9, 3.625406155578574*^9}, {
   3.625406270326149*^9, 3.6254062739492645`*^9}, {3.6254063361602163`*^9, 
   3.6254063800405865`*^9}, {3.625406422814944*^9, 3.6254064742111397`*^9}, 
   3.625406506150816*^9, 3.6254066053069286`*^9, 3.625406665980237*^9, 
   3.625408013180588*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{{3.6254061127082167`*^9, 3.625406155578574*^9}, {
   3.625406270326149*^9, 3.6254062739492645`*^9}, {3.6254063361602163`*^9, 
   3.6254063800405865`*^9}, {3.625406422814944*^9, 3.6254064742111397`*^9}, 
   3.625406506150816*^9, 3.6254066053069286`*^9, 3.625406665980237*^9, 
   3.625408013474595*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{"c", ",", "GA", ",", "hbCoeff", ",", " ", "variablesBounds"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}], "\[IndentingNewLine]", 
 RowBox[{"myTolerance", " ", "=", " ", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.008499999997937588`", ",", "0.0019999999937012915`", ",", "0.`", ",", 
   "2.5080511241598477`*^-9", ",", "1.4459069912907958`", ",", 
   "1.6107267088142307`*^-17", ",", "0.0001480499998821083`", ",", 
   "0.003947999996856219`", ",", "0.0010363499991747575`", ",", 
   "0.004737599996227462`", ",", "4.715136122799227`*^-11", ",", 
   "9.194515421775356`*^-10", ",", "4.715136114194431`*^-10", ",", 
   "9.194515421773238`*^-10", ",", "0.020387288577200464`", ",", 
   "0.4757034001346851`", ",", "0.2378517000673331`", ",", 
   "0.6252101830341537`", ",", "5.238805620055203`*^-18", ",", 
   "6.491141478691787`*^-18", ",", "3.3697346318077927`*^-18", ",", 
   "9.380437549488091`*^-18", ",", "0.38071422229946383`", ",", 
   "9.467369591977486`*^-12", ",", "0.24923356164089452`", ",", 
   "0.08409977170595133`", ",", "0.042944564275379536`", ",", 
   "0.11630819491248652`", ",", "0.11451883806767679`", ",", "0.`", ",", 
   "1.067919374692936`*^-12", ",", "0.`", ",", "7.83140814298432`*^-12", ",", 
   "3.3445387711835683`*^-12", ",", "0.13000000000343115`", ",", 
   "0.2000000000066006`", ",", "0.5900000000038103`", ",", 
   "0.3498728197273965`", ",", "0.07000000000090661`", ",", 
   "0.12000000000127023`", ",", "0.40000000000160874`", ",", 
   "0.2500000000068633`", ",", "0.13000000000343082`", ",", 
   "0.15000000000330127`", ",", "0.05000000000330128`", ",", 
   "0.06347990290068158`", ",", "0.07000000000090655`", ",", 
   "0.12000000000127094`", ",", "0.4000000000015975`", ",", 
   "0.2500000000068633`", ",", "0.09987281972053344`", ",", 
   "0.006347990569937001`", ",", "3.030233334763719`*^-11", ",", 
   "6.50195018290507`*^-12", ",", "0.3678990850709425`", ",", 
   "0.013059993565269204`", ",", "0.006999999997843146`", ",", 
   "0.005999999995729725`", ",", "0.`", ",", "3.3246776954818963`*^-9", ",", 
   "1.5261233053169894`", ",", "1.6107280520613365`*^-17", ",", 
   "0.00018329999990935122`", ",", "0.004887999997583402`", ",", 
   "0.0012830999993656443`", ",", "0.005865599997100108`", ",", 
   "6.25039407686728`*^-11", ",", "1.218826843224247`*^-9", ",", 
   "6.25039406828366`*^-10", ",", "1.218826843224247`*^-9", ",", 
   "0.02151833860496946`", ",", "0.502094567449284`", ",", 
   "0.25104728372464363`", ",", "0.6598957172190663`", ",", 
   "5.238807081869681`*^-18", ",", "6.4911428174250305`*^-18", ",", 
   "3.369734457438767`*^-18", ",", "9.380440968805685`*^-18", ",", 
   "0.4201995636367838`", ",", "9.456086069813696`*^-12", ",", 
   "0.2455617547887474`", ",", "0.09282208360736545`", ",", 
   "0.047398510778229`", ",", "0.12837096669103576`", ",", 
   "0.12639602874194455`", ",", "0.`", ",", "1.0666465933935917`*^-12", ",", 
   "0.`", ",", "7.822074413454416`*^-12", ",", "3.0643479274600242`*^-12", 
   ",", "0.12000000000306914`", ",", "0.21500000000601804`", ",", 
   "0.6290000000031694`", ",", "0.37493914896782543`", ",", 
   "0.08000000000132416`", ",", "0.1290000000008935`", ",", 
   "0.42000000000096227`", ",", "0.2900000000085832`", ",", 
   "0.12000000000306921`", ",", "0.16000000000300937`", ",", 
   "0.055000000003009385`", ",", "0.06910014944667839`", ",", 
   "0.08000000000132419`", ",", "0.12900000000089318`", ",", 
   "0.42000000000096976`", ",", "0.2900000000085834`", ",", 
   "0.08493914895924298`", ",", "0.0005620244059773744`", ",", 
   "3.8929574394268725`*^-11", ",", "1.106516954576435`*^-11", ",", 
   "0.0724533427532539`", ",", "0.3070698050371098`", ",", 
   "0.006347990569937006`", ",", "3.030233334763719`*^-11", ",", 
   "6.5019501829067245`*^-12", ",", "0.36789908507094216`", ",", 
   "0.013059993565269217`", ",", "0.0019999999976266663`", ",", 
   "0.017999999996697807`", ",", "0.`", ",", "0.14010758656224254`", ",", 
   "1.4562926120436592`", ",", "5.6855133773852185`*^-18", ",", 
   "0.00028199999991997517`", ",", "0.007519999997866003`", ",", 
   "0.0019739999994398253`", ",", "0.009023999997439199`", ",", 
   "0.002634022627370141`", ",", "0.05136344123371764`", ",", 
   "0.02634022627370151`", ",", "0.051363441233716244`", ",", 
   "0.02053372582981549`", ",", "0.4791202693623616`", ",", 
   "0.2395601346811802`", ",", "0.6297009254476802`", ",", 
   "3.0971554634803455`*^-18", ",", "3.519990651615386`*^-18", ",", 
   "3.1057115787971743`*^-18", ",", "4.468892546815398`*^-18", ",", 
   "0.5097664914792635`", ",", "2.2154177734629221`*^-10", ",", 
   "0.18032187497803917`", ",", "0.11260741796776817`", ",", 
   "0.05750166023886096`", ",", "0.155733663146915`", ",", 
   "0.15333776063696297`", ",", "0.`", ",", "2.498991256937037`*^-11", ",", 
   "0.`", ",", "1.8325935823734728`*^-10", ",", "4.097452857736994`*^-12", 
   ",", "0.05000000000419923`", ",", "0.2400000000080534`", ",", 
   "0.6868000000034375`", ",", "0.41700000055679637`", ",", 
   "0.09000000000141598`", ",", "0.1468000000009665`", ",", 
   "0.45000000000104085`", ",", "0.33000000006484403`", ",", 
   "0.05000000000419923`", ",", "0.18000000000402694`", ",", 
   "0.06000000000402694`", ",", "0.08095140872095612`", ",", 
   "0.09000000000141616`", ",", "0.14680000000096666`", ",", 
   "0.4500000000010452`", ",", "0.3300000000648446`", ",", 
   "0.08700000049194925`", ",", "0.0011851259468186478`", ",", 
   "7.22492569923428`*^-11", ",", "1.0398501513369444`*^-11", ",", 
   "0.12937285627974232`", ",", "0.4813451473742031`", ",", 
   "0.006347990569937006`", ",", "0.0005620244059773744`", ",", 
   "3.030233334763719`*^-11", ",", "3.8929574394268725`*^-11", ",", 
   "6.50195018290507`*^-12", ",", "1.1065169545767658`*^-11", ",", 
   "0.3678990850709419`", ",", "0.07245334275325387`", ",", 
   "0.013059993565269223`", ",", "0.30706980503710984`", ",", "0.`", ",", 
   "0.029999999996540832`", ",", "0.`", ",", "4.0657266579039005`*^-10", ",", 
   "1.8222079907541893`", ",", "7.748216959688757`*^-18", ",", 
   "0.00042299999995122585`", ",", "0.011279999998699355`", ",", 
   "0.00296099999965858`", ",", "0.013535999998439224`", ",", 
   "7.643566210551783`*^-12", ",", "1.490495393391791`*^-10", ",", 
   "7.643566124611357`*^-11", ",", "1.4904953933912615`*^-10", ",", 
   "0.025693132669634036`", ",", "0.5995064289581283`", ",", 
   "0.29975321447906367`", ",", "0.7879227352021099`", ",", 
   "3.859514168577797`*^-18", ",", "4.407086654183868`*^-18", ",", 
   "3.1713016635658246`*^-18", ",", "5.651436459573463`*^-18", ",", 
   "0.5400037533759805`", ",", "0.07266100300425973`", ",", 
   "0.18879397896936026`", ",", "0.11928682912075399`", ",", 
   "0.0609124233808106`", ",", "0.16497114665636192`", ",", 
   "0.1624331290154948`", ",", "0.`", ",", "0.0081961611388805`", ",", "0.`", 
   ",", "0.060105181685123674`", ",", "2.306409746878285`*^-12", ",", 
   "0.040000000002348574`", ",", "0.2650000000045582`", ",", 
   "0.7680000000046189`", ",", "0.5200000000032203`", ",", 
   "0.10000000000158306`", ",", "0.16800000000131485`", ",", 
   "0.5000000000017184`", ",", "0.41000000000146625`", ",", 
   "0.040000000002348574`", ",", "0.20000000000227916`", ",", 
   "0.06500000000227915`", ",", "0.09522471719691994`", ",", 
   "0.1000000000015831`", ",", "0.1680000000013148`", ",", 
   "0.50000000000172`", ",", "0.4100000000014664`", ",", 
   "0.11000000000175336`", ",", "0.0014273308299109825`", ",", 
   "0.20227272716526726`", ",", "0.08148353293018866`", ",", 
   "0.06557324930015461`", ",", "1.0482176763858986`", ",", 
   "0.006347990569937006`", ",", "0.0005620244059773745`", ",", 
   "0.0011851259468186482`", ",", "0.`", ",", "6.923190764642942`*^-11", ",", 
   "7.22492569923428`*^-11", ",", "0.48134514737420303`", ",", "0.`", ",", 
   "0.009999999995546988`", ",", "0.`", ",", "4.907699506819438`*^-10", ",", 
   "2.1685797644682046`", ",", "7.74822015864279`*^-18", ",", 
   "0.00014099999993721262`", ",", "0.0037599999983256656`", ",", 
   "0.0009869999995604875`", ",", "0.004511999997990799`", ",", 
   "9.226475166517342`*^-12", ",", "1.7991626398047027`*^-10", ",", 
   "9.226475080571953`*^-11", ",", "1.7991626398057614`*^-10", ",", 
   "0.030576974679004835`", ",", "0.7134627425100304`", ",", 
   "0.35673137125501764`", ",", "0.937693890156042`", ",", 
   "3.8595144429002324`*^-18", ",", "4.407086924655874`*^-18", ",", 
   "3.171301778546246`*^-18", ",", "5.651437317753154`*^-18", ",", 
   "0.6445783026478876`", ",", "0.12688362159854638`", ",", 
   "0.17074396608751885`", ",", "0.1423873470549181`", ",", 
   "0.07270843253868162`", ",", "0.1969186714589298`", ",", 
   "0.1938891534364849`", ",", "0.`", ",", "0.014312472516316036`", ",", 
   "0.`", ",", "0.1049581317863177`", ",", "2.7322072968082632`*^-12", ",", 
   "0.040000000002817296`", ",", "0.2700000000054631`", ",", 
   "0.9050000000057321`", ",", "0.6500000000039518`", ",", 
   "0.11000000000230914`", ",", "0.24500000000163577`", ",", 
   "0.5500000000017828`", ",", "0.5000000000018309`", ",", 
   "0.040000000002817296`", ",", "0.2000000000027316`", ",", 
   "0.07000000000273161`", ",", "0.11773887974316616`", ",", 
   "0.11000000000230913`", ",", "0.2450000000016358`", ",", 
   "0.5500000000017834`", ",", "0.5000000000018284`", ",", 
   "0.15000000000211372`", ",", "0.0022514163134942956`", ",", 
   "0.2686868687425441`", ",", "0.06779131602296974`", ",", 
   "0.6927541656026032`", ",", "0.7636790341801856`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "8.788228984917939`*^-9", ",", "2.5433260459306997`", ",",
    "6.724594287596637`*^-17", ",", "3.078296279598213`*^-18", ",", 
   "3.078297042115108`*^-18", ",", "3.0782962043905807`*^-18", ",", 
   "3.0782965022360596`*^-18", ",", "1.6521870501008446`*^-10", ",", 
   "3.2217647459310863`*^-9", ",", "1.6521870492420591`*^-9", ",", 
   "3.2217647459319333`*^-9", ",", "0.03586089724762291`", ",", 
   "0.8367542691112005`", ",", "0.41837713455560027`", ",", 
   "1.0997341822604356`", ",", "4.0674037552515645`*^-17", ",", 
   "7.231612384374632`*^-17", ",", "4.095259687346451`*^-17", ",", 
   "2.569889760120364`*^-16", ",", "0.597177240292834`", ",", 
   "0.35164511468013276`", ",", "0.1509118305092321`", ",", 
   "0.13191645238068705`", ",", "0.0673615927050317`", ",", 
   "0.18243764690946085`", ",", "0.17963091388008454`", ",", "0.`", ",", 
   "0.03966556893591922`", ",", "0.`", ",", "0.29088083886340477`", ",", 
   "1.2203732302052216`*^-11", ",", "2.496070727510074`*^-11", ",", 
   "0.28000000002385544`", ",", "1.0090000000499986`", ",", 
   "0.8800000000617658`", ",", "0.12000000000538714`", ",", 
   "0.2890000000208104`", ",", "0.6000000000238022`", ",", 
   "0.6800000000060927`", ",", "2.4960707275107358`*^-11", ",", 
   "0.20000000001192772`", ",", "0.0800000000119277`", ",", 
   "0.1428880590537925`", ",", "0.12000000000538721`", ",", 
   "0.2890000000208104`", ",", "0.6000000000238022`", ",", 
   "0.6800000000060931`", ",", "0.200000000055671`", ",", 
   "0.012037389976979939`", ",", "0.2790404041862147`", ",", 
   "0.5516001799350504`", ",", "0.9367486123266916`", ",", 
   "2.6771853210807213`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6254060161712275`*^9, 3.625406118132389*^9, {3.625406158655668*^9, 
   3.6254061760122147`*^9}, 3.625406386206783*^9, 3.6254065095908866`*^9, 
   3.625406605537935*^9, 3.6254066663602467`*^9, 3.6254080135445967`*^9}],

Cell[BoxData["1878.1248228730778`"], "Output",
 CellChangeTimes->{
  3.6254060161712275`*^9, 3.625406118132389*^9, {3.625406158655668*^9, 
   3.6254061760122147`*^9}, 3.625406386206783*^9, 3.6254065095908866`*^9, 
   3.625406605537935*^9, 3.6254066663602467`*^9, 3.625408013554597*^9}],

Cell[BoxData["6.318119538659245`*^-14"], "Output",
 CellChangeTimes->{
  3.6254060161712275`*^9, 3.625406118132389*^9, {3.625406158655668*^9, 
   3.6254061760122147`*^9}, 3.625406386206783*^9, 3.6254065095908866`*^9, 
   3.625406605537935*^9, 3.6254066663602467`*^9, 3.625408013554597*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<tolerance\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", 
   StyleBox["myTolerance", "MR"], " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}]}], "Input"],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\value4.txt\"\>"], \
"Output",
 CellChangeTimes->{3.6254066992417545`*^9, 3.625408013584597*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\sol4.txt\"\>"], "Output",
 CellChangeTimes->{3.6254066992417545`*^9, 3.6254080135945973`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\tolerance4.txt\"\>"], \
"Output",
 CellChangeTimes->{3.6254066992417545`*^9, 3.6254080136045976`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 871},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 103, 6, 207, "Subtitle"],
Cell[CellGroupData[{
Cell[707, 32, 329, 6, 60, "Input"],
Cell[1039, 40, 335, 4, 36, "Output"],
Cell[1377, 46, 224, 3, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1638, 54, 4360, 132, 313, "Input"],
Cell[6001, 188, 350, 5, 36, "Output"],
Cell[6354, 195, 4908, 67, 313, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11299, 267, 430, 10, 83, "Input"],
Cell[11732, 279, 11222, 174, 830, "Output"],
Cell[22957, 455, 285, 4, 36, "Output"],
Cell[23245, 461, 289, 4, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23571, 470, 818, 22, 83, "Input"],
Cell[24392, 494, 225, 3, 36, "Output"],
Cell[24620, 499, 223, 2, 36, "Output"],
Cell[24846, 503, 231, 3, 93, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
