(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     42832,        791]
NotebookOptionsPosition[     41871,        755]
NotebookOutlinePosition[     42292,        771]
CellTagsIndexPosition[     42249,        768]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the LP problem defined by:
min(c) s.t.
A.x = b
lb <= x <= ub\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myProblemId", " ", "=", " ", 
   RowBox[{"ToString", "[", "\"\<5\>\"", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6254048133299365`*^9, 3.6254048179797497`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\\"\>"], "Output",
 CellChangeTimes->{3.625404970184683*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   StyleBox["c", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<c\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "c", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<A\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<b\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GA", " ", "=", " ", "A"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hbCoeff", " ", "=", " ", "bCoeff"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lb", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<lb\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"-", 
       StyleBox["99999999", "MR"]}]}], "}"}]}]}], 
  StyleBox[";", "MR"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ub", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<ub\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"+", 
       StyleBox["99999999", "MR"]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"variablesBounds", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lb", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       RowBox[{"ub", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.625404805550902*^9, 3.6254048062771854`*^9}, {
  3.6254048368921275`*^9, 3.6254048392660537`*^9}, {3.6254048871707373`*^9, 
  3.6254049088221807`*^9}, {3.6254049840797796`*^9, 3.6254049863931293`*^9}, {
  3.6254052197893844`*^9, 3.625405220133437*^9}}],

Cell[BoxData["1123"], "Output",
 CellChangeTimes->{{3.6254049761625824`*^9, 3.6254049872172537`*^9}, 
   3.625405222919858*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{"c", ",", "GA", ",", "hbCoeff", ",", " ", "variablesBounds"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}], "\[IndentingNewLine]", 
 RowBox[{"myTolerance", " ", "=", " ", 
  RowBox[{
   StyleBox["Norm", "MR"], 
   StyleBox["[", "MR"], 
   RowBox[{
    RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "5.983820677357747`*^-10", ",", "162.6391581931205`", ",", 
   "85.0507846257972`", ",", "0.9272294763483406`", ",", 
   "0.7777777778229618`", ",", "0.9999999996415891`", ",", 
   "0.00005459578973397596`", ",", "0.000024025559666413366`", ",", 
   "0.00003689293820746854`", ",", "0.00005359694356537227`", ",", 
   "0.00003280319877671014`", ",", "0.000014245126461149085`", ",", 
   "0.000022924413901664356`", ",", "0.00005604588591707202`", ",", 
   "0.000024412664853530377`", ",", "0.000024849676304866424`", ",", 
   "0.0000260985950373214`", ",", "0.00004924892098563052`", ",", 
   "0.00008167516696285299`", ",", "0.00004361839335372503`", ",", 
   "0.000054847839000401494`", ",", "0.00002192578366843576`", ",", 
   "1.451898023218275`*^-6", ",", "3.423846600355276`*^-6", ",", 
   "0.000025082546204320327`", ",", "1658.8213114985533`", ",", 
   "25.22148321915519`", ",", "1.3554389977429737`*^-9", ",", 
   "0.6733333333486435`", ",", "0.6907433380193014`", ",", 
   "1.0547657903425278`*^-11", ",", "2.777195320497556`*^-7", ",", 
   "1.7442279708642836`*^-7", ",", "1.279039252645061`*^-7", ",", 
   "2.982362110891291`*^-7", ",", "1.8535105558957238`*^-7", ",", 
   "1.1713725686214924`*^-7", ",", "1.0564571259669702`*^-7", ",", 
   "3.7924371869865505`*^-7", ",", "2.8411338946403316`*^-7", ",", 
   "3.102269112415599`*^-7", ",", "3.164049033908723`*^-7", ",", 
   "2.1892648846171772`*^-7", ",", "5.346908136448614`*^-7", ",", 
   "7.326320763711792`*^-7", ",", "5.767179952974883`*^-7", ",", 
   "3.2571694317502333`*^-7", ",", "3.0780578195928996`*^-7", ",", 
   "2.5486451385615137`*^-7", ",", "2.744172323584187`*^-7", ",", 
   "9.444810723538514`*^-7", ",", "56.03169318335797`", ",", 
   "1.8466892364661482`*^-9", ",", "0.08100622306850148`", ",", 
   "0.5200000000547609`", ",", "0.5455820477081186`", ",", 
   "9.533401587712052`*^-11", ",", "5.934188282012545`*^-7", ",", 
   "2.8966264323377015`*^-7", ",", "2.789736317316211`*^-7", ",", 
   "5.158559819777799`*^-7", ",", "3.052175572338775`*^-7", ",", 
   "1.8711818310022252`*^-7", ",", "1.5994734126511723`*^-7", ",", 
   "6.337592800190567`*^-7", ",", "5.450997545228887`*^-7", ",", 
   "5.057421524839457`*^-7", ",", "4.908812884618639`*^-7", ",", 
   "5.667887872169102`*^-7", ",", "8.178891424780131`*^-7", ",", 
   "1.51399646831781`*^-6", ",", "6.913675722284244`*^-7", ",", 
   "5.243114574832652`*^-7", ",", "5.243088144870762`*^-7", ",", 
   "5.78087429579865`*^-7", ",", "3.140778572640021`*^-7", ",", 
   "2715.8813307779933`", ",", "28.33201268286106`", ",", 
   "1102.4354938562708`", ",", "4.5978158960993273`*^-11", ",", 
   "0.2950000000683044`", ",", "0.33239831699519884`", ",", 
   "6.588258933731536`*^-11", ",", "5.353116897386099`*^-7", ",", 
   "3.0342145272823507`*^-7", ",", "2.8307020513234663`*^-7", ",", 
   "5.105433797402651`*^-7", ",", "3.246208132129265`*^-7", ",", 
   "2.0640344922561097`*^-7", ",", "1.7840612010201292`*^-7", ",", 
   "6.391218034561942`*^-7", ",", "5.347169323511529`*^-7", ",", 
   "5.255737279020704`*^-7", ",", "5.166684682396432`*^-7", ",", 
   "5.037669352861084`*^-7", ",", "7.868977523968581`*^-7", ",", 
   "1.4741126262019162`*^-6", ",", "6.663495873270552`*^-7", ",", 
   "5.474590522501078`*^-7", ",", "5.052961089736993`*^-7", ",", 
   "5.520707344762049`*^-7", ",", "3.25973127706486`*^-7", ",", 
   "3210.976939230729`", ",", "17.12807430532651`", ",", 
   "1.0707632572730725`*^-7", ",", "7.587778186972982`*^-8", ",", 
   "1.6427341457602364`*^-7", ",", "2.8438813613352896`*^-7", ",", 
   "1.5674587261180044`*^-7", ",", "1.8565257708111609`*^-7", ",", 
   "1.1235811664712905`*^-7", ",", "3.115354283748722`*^-7", ",", 
   "2.4040057038138316`*^-7", ",", "2.3201633208838746`*^-7", ",", 
   "2.969626287538876`*^-7", ",", "8.686968258606422`*^-8", ",", 
   "1.1259919710178933`*^-7", ",", "8.749072394349552`*^-7", ",", 
   "7.802318430655263`*^-8", ",", "3.0556060231854485`*^-7", ",", 
   "13.733566425065176`", ",", "108.51179450440054`", ",", 
   "608.1462018410681`", ",", "0.11835006505859248`", ",", 
   "1.5627513541602935`*^-14", ",", "3.313152114471919`", ",", 
   "2.35790080397802`*^-13", ",", "1.3964249488444138`", ",", 
   "12.999999987892929`", ",", "0.`", ",", "3.159607862060765`*^-14", ",", 
   "559.982312010207`", ",", "34.528157126070106`", ",", 
   "1.8940835948079155`*^-8", ",", "49.09166016203744`", ",", 
   "1.9922604611208127`*^-6", ",", "0.36422809579989857`", ",", 
   "0.25546006056447973`", ",", "0.32966007776602224`", ",", 
   "1.1176233179159098`*^-11", ",", "1.8950160562584026`", ",", 
   "0.32184010439744226`", ",", "6.995839083925526`*^-6", ",", 
   "0.222222222155101`", ",", "1.2999350030070968`*^-11", ",", 
   "3.936016427299237`*^-12", ",", "399.9999999938873`", ",", 
   "17.466666664777566`", ",", "2.0699933048650547`*^-12", ",", 
   "1.3518610597264037`*^-12", ",", "9.892288218904903`*^-13", ",", 
   "7.756007341888284`*^-13", ",", "24.`", ",", "5.961307992849258`", ",", 
   "7.144157388714419`*^-9", ",", "2.906811996523777`", ",", 
   "3.4755320538635866`*^-9", ",", "1.1728422962553477`*^-10", ",", 
   "8.030318202235808`*^-11", ",", "4.821241237996526`*^-11", ",", 
   "1.1032871314529378`*^-6", ",", "1.4325973988643282`*^-7", ",", 
   "3.3671492321700525`*^-11", ",", "2.5753282802813587`*^-11", ",", 
   "2.083189475129769`*^-11", ",", "1.748902001467324`*^-11", ",", 
   "1.507328458363583`*^-11", ",", "164.`", ",", "15.416000006160168`", ",", 
   "14.920958086414023`", ",", "55.678098429474744`", ",", 
   "2.9626405209362095`*^-9", ",", "1.7075847373211995`*^-8", ",", 
   "3.285859373743802`*^-8", ",", "1.3713051443236008`*^-8", ",", 
   "2.311515260788185`*^-10", ",", "1.9479711987417086`*^-12", ",", 
   "1.703235164162985`", ",", "2.9499463080088755`", ",", 
   "5.621855067683838`*^-14", ",", "38.40489690685154`", ",", 
   "2.469679924015672`", ",", "0.04812094492408896`", ",", 
   "0.015750599614046495`", ",", "0.005280998503023718`", ",", 
   "0.002460584908926481`", ",", "0.0007579769163050443`", ",", 
   "0.00039941878543049345`", ",", "0.`", ",", "11.573055560359393`", ",", 
   "1.0839981919326115`*^-7", ",", "1.2696783578870814`", ",", "0.`", ",", 
   "3.196893497674471`*^-9", ",", "0.00006913383672788997`", ",", 
   "0.8378639767438172`", ",", "0.00002938717775958805`", ",", 
   "2.2012457222618472`*^-10", ",", "3.3796489994050836`", ",", 
   "12.489160150289536`", ",", "33.141773998737335`", ",", 
   "14.517908304929733`", ",", "25.555797934532166`", ",", 
   "3.779183834751849`*^-11", ",", "5.96723162234332`*^-14", ",", 
   "6.05357105949275`*^-9", ",", "6.195211468341774`", ",", 
   "6.412526019881155`*^-14", ",", "1.8868274529948673`*^-14", ",", 
   "48.194538192692335`", ",", "23.035921381017772`", ",", 
   "0.48878824161942486`", ",", "1.36835228462268`", ",", 
   "7.547257482402132`*^-9", ",", "0.4687519182888778`", ",", 
   "7.135526229875956`*^-10", ",", "1.2928573275824153`*^-9", ",", 
   "1.0839742387636278`*^-11", ",", "0.0782045444208024`", ",", 
   "1.4771377055185617`*^-10", ",", "0.0009326415620078472`", ",", 
   "64.10726276040077`", ",", "9.788546860218048`", ",", "69.37230928242207`",
    ",", "90.69305688142776`", ",", "26.475519612431526`", ",", 
   "20.099883064627647`", ",", "68.41182139515877`", ",", 
   "45.873360604047775`", ",", "18.222721233963966`", ",", 
   "18.585168197751045`", ",", "143.26980109512806`", ",", 
   "55.97686429321766`", ",", "174.22609655559063`", ",", 
   "156.82318153977394`", ",", "276.91432002186775`", ",", 
   "104.20768915116787`", ",", "125.24831520020962`", ",", 
   "163.79716935753822`", ",", "432.45788096236066`", ",", 
   "15.573334188263914`", ",", "2025.5638452569608`", ",", 
   "149.71691838916925`", ",", "270.0934247509575`", ",", 
   "49665.31002665629`", ",", "49665.31005173884`", ",", 
   "0.000034588055448204664`", ",", "0.00008854393128089861`", ",", 
   "0.0000524815222154266`", ",", "0.00003804074038456053`", ",", 
   "0.0000568362528616911`", ",", "140.41537942951547`", ",", 
   "5826.470436854527`", ",", "0.000036520144489272193`", ",", 
   "467.4221487661496`", ",", "0.000643899715389166`", ",", 
   "0.0000810836656272777`", ",", "0.00004339176665927756`", ",", "0.`", ",", 
   "0.00030031312645122376`", ",", "0.000037790684178747554`", ",", 
   "1927.6469149111379`", ",", "3432.254637360648`", ",", 
   "125.03660330829076`", ",", "5521.0976174670905`", ",", 
   "643.8998146224678`", ",", "4789.519477474148`", ",", 
   "3792.1596287065518`", ",", "1031.609804956787`", ",", 
   "511.0056166124097`", ",", "1802.9163920511226`", ",", 
   "952.1498646381277`", ",", "582.2461230253234`", ",", "305.509672877072`", 
   ",", "5644.39836092226`", ",", "3575.6994201710477`", ",", "0.`", ",", 
   "913.7897541383638`", ",", "14800.652302088221`", ",", 
   "1387.6496253707803`", ",", "1.8591117152995752`*^-6", ",", 
   "4.711742912402534`*^-6", ",", "1105.4811073287551`", ",", 
   "350.68823713815635`", ",", "1451.9371766938095`", ",", 
   "793.341448227332`", ",", "312.88635525139887`", ",", 
   "0.00011690092416292495`", ",", "0.00011380432927385139`", ",", 
   "234.36162314174544`", ",", "0.00012798467132989208`", ",", 
   "0.007102284652041695`", ",", "0.010409768389330496`", ",", 
   "0.00004924892098563052`", ",", "0.`", ",", "0.00004361839335372503`", ",",
    "0.000054847839000401494`", ",", "0.000048025131568306626`", ",", 
   "1.681999774997433`*^-6", ",", "4.332296328368419`*^-6", ",", 
   "3.779183834751849`*^-11", ",", "5.96723162234332`*^-14", ",", 
   "6.05357105949275`*^-9", ",", "6.195211468341774`", ",", 
   "6.412526019881155`*^-14", ",", "1.8868274529948673`*^-14", ",", 
   "48.194538192692335`", ",", "23.035921381017772`", ",", 
   "0.48878824161942486`", ",", "1.36835228462268`", ",", 
   "7.547257482402132`*^-9", ",", "0.4687519182888778`", ",", 
   "7.135526229875956`*^-10", ",", "1.2928573275824153`*^-9", ",", 
   "1.0839742387636278`*^-11", ",", "0.0782045444208024`", ",", 
   "1.4771377055185617`*^-10", ",", "0.0009326415620078472`", ",", 
   "25.247738283389232`", ",", "0.03994206836658413`", ",", 
   "24.17155015383913`", ",", "36.62033847587216`", ",", "5.600872479697121`",
    ",", "1.5927546009163`*^-8", ",", "1.1873545727212218`", ",", 
   "24.40517106855347`", ",", "6.336241865006015`*^-8", ",", 
   "0.27384647610068247`", ",", "23.659991035219843`", ",", 
   "18.168325493275958`", ",", "59.00715878862947`", ",", "72.4757616265696`",
    ",", "151.44038912635648`", ",", "8.177536087820189`*^-7", ",", 
   "2.0367150471255334`*^-9", ",", "4.5033376679764205`*^-9", ",", "0.`", ",",
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "111.87138839559188`", ",", "29.999999888105613`", ",", 
   "0.9775765021796393`", ",", "3.0783647312827442`", ",", 
   "2.0073549298638655`*^-6", ",", "1.2788056765073906`*^-11", ",", 
   "1.9573307486394187`*^-11", ",", "3.3915440078170405`*^-11", ",", 
   "3.2809496202644446`*^-11", ",", "2.0514251450999605`", ",", 
   "0.0699999194638301`", ",", "0.0018746109070596493`", ",", 
   "1.7146417011548944`", ",", "10.322032112486928`", ",", 
   "1.5291041667922876`", ",", "5.703897098721023`", ",", 
   "15.380391607909333`", ",", "3.9771285494217468`", ",", 
   "3.004201196466021`", ",", "9.735481825390284`", ",", 
   "10.824566629596674`", ",", "3.1874660842130456`", ",", 
   "2.995045306429517`", ",", "23.666650999407075`", ",", 
   "10.908841150979391`", ",", "28.279691134642576`", ",", 
   "25.72672968986466`", ",", "55.4420281628988`", ",", "17.39132152480071`", 
   ",", "49.7127807261728`", ",", "34.70984963671915`", ",", 
   "0.9067280352916776`", ",", "0.2945561583633357`", ",", 
   "20.929211189435456`", ",", "1.7399557092786555`", ",", 
   "3.875244552006788`", ",", "45.46224257175553`", ",", "0.`", ",", 
   "0.5186279690752386`", ",", "743.3728459213867`", ",", 
   "88.81005661831065`", ",", "4.692367213491861`", ",", 
   "17.085005014888626`", ",", "9.998975048790614`*^-6", ",", 
   "1.6426418882412756`*^-12", ",", "1.001537068310551`*^-12", ",", 
   "9.255641005423707`*^-13", ",", "1.0734126207717862`*^-12", ",", 
   "3.943373944802138`", ",", "0.4730399999943396`", ",", 
   "0.006749999994262468`", ",", "0.3266666666438164`", ",", 
   "4.549249471059325`*^-12", ",", "1.3764276259758157`*^-12", ",", 
   "587.999999998286`", ",", "25.67599999936889`", ",", 
   "7.199105811812713`*^-13", ",", "4.686535002766604`*^-13", ",", 
   "3.4244484031754384`*^-13", ",", "2.682811359966667`*^-13", ",", "0.`", 
   ",", "3.270420943306244`*^-11", ",", "5.968340093181827`", ",", 
   "3.2981059520299135`*^-11", ",", "5.184828306528039`", ",", 
   "0.3092566619680526`", ",", "9.337929869732777`*^-12", ",", 
   "1.6637941596115593`*^-12", ",", "440.9999999993619`", ",", 
   "85.04558204628248`", ",", "6.948624876994999`*^-13", ",", 
   "4.2958392078714664`*^-13", ",", "3.0458211737211795`*^-13", ",", 
   "2.340456374201982`*^-13", ",", "1.8942258845967137`*^-13", ",", "0.`", 
   ",", "3.6569600279901455`", ",", "4.947378689694624`", ",", 
   "51.96129670866944`", ",", "1.3313477085951524`*^-11", ",", 
   "9.913665683255849`*^-12", ",", "8.884865742809337`*^-12", ",", 
   "8.281301959262116`*^-12", ",", "0.1966322731687801`", ",", 
   "4.8570759151740286`*^-8", ",", "11.681816833389806`", ",", 
   "7.171819347398802`*^-8", ",", "2.3639295816737985`*^-10", ",", 
   "259.7999071233337`", ",", "4.132546927085994`", ",", 
   "0.9872438349338817`", ",", "0.012756163342811351`", ",", 
   "3.0795013516473575`*^-10", ",", "4.901083974892715`*^-11", ",", 
   "8.176800864877797`*^-12", ",", "2.891995363236666`*^-12", ",", "0.`", ",",
    "0.9391178589876833`", ",", "6.999999999915273`", ",", 
   "4.999999999942935`", ",", "0.`", ",", "1.3945974665316802`*^-11", ",", 
   "1.0241564969403313`*^-11", ",", "9.19473927722757`*^-12", ",", 
   "8.63950191357969`*^-12", ",", "0.008192999983002536`", ",", 
   "4.641381999997036`", ",", "3.5385372936725616`", ",", 
   "17.30424252152443`", ",", "6.161450892686844`", ",", 
   "30.917444229125977`", ",", "8.850243339722997`*^-12", ",", 
   "9.18976361281943`*^-12", ",", "1.84095989637437`*^-8", ",", 
   "1.7451850497453425`*^-8", ",", "1.0192899255925331`*^-11", ",", 
   "2.0000007019218614`*^-10", ",", "125.40965892795225`", ",", 
   "62.08798954658357`", ",", "4.075955872143284`*^-10", ",", 
   "19.208490365045016`", ",", "1.7489162005217955`*^-8", ",", 
   "0.5784536163765428`", ",", "0.20099399991042052`", ",", 
   "0.25937399983370657`", ",", "8.093983862343254`*^-11", ",", 
   "3.1412349815581395`", ",", "1.2069746818286442`*^-10", ",", 
   "8.776168864700217`*^-11", ",", "61.359811931848526`", ",", 
   "4.099102392792702`", ",", "50.82116447389126`", ",", "93.1559751033783`", 
   ",", "17.322122365236282`", ",", "13.666234463453293`", ",", 
   "44.034565925598145`", ",", "44.55669331550598`", ",", 
   "13.768428146839142`", ",", "14.25699645280838`", ",", 
   "115.41927048563957`", ",", "42.63714385032654`", ",", 
   "156.81196877360344`", ",", "147.4392982274294`", ",", 
   "272.8346621990204`", ",", "78.17106147110462`", ",", "82.58507205545902`",
    ",", "110.23471680283546`", ",", "451.2956004168955`", ",", 
   "16.251703647045556`", ",", "2025.5638452588073`", ",", 
   "156.23853686432926`", ",", "119.21955478200996`", ",", 
   "55711.46342397778`", ",", "55711.46342425219`", ",", 
   "1.3858750471846938`*^-6", ",", "2303.0273432374206`", ",", 
   "2333.473632755778`", ",", "2.047446794683789`*^-6", ",", 
   "2977.1904293322345`", ",", "589.3486327889017`", ",", 
   "7402.742187826519`", ",", "8.704848173315316`*^-7", ",", 
   "1.6739844196494808`*^-6", ",", "1.3000976686414098`*^-6", ",", 
   "1.568396441707634`*^-6", ",", "1860.7628774163768`", ",", "0.`", ",", 
   "3.984241482655887`*^-7", ",", "5.328413964016842`*^-7", ",", 
   "1.2291850404788431`*^-6", ",", "1.8160674842972843`*^-6", ",", 
   "130.48313167206013`", ",", "4134.216357550776`", ",", 
   "4.838257964426224`*^-7", ",", "2.590076814419242`*^-7", ",", 
   "4622.554684824661`", ",", "5.968158938240618`*^-7", ",", 
   "2.2734562553101188`*^-7", ",", "1.7670092464006453`*^-7", ",", 
   "1160.6491690319856`", ",", "709.7494988632809`", ",", 
   "372.4096660724461`", ",", "6880.394529115619`", ",", 
   "9.82802575660141`*^-7", ",", "0.`", ",", "1113.889403569232`", ",", 
   "18041.66405947501`", ",", "7550.062498422728`", ",", 
   "10998.613277743343`", ",", "4.106739485674928`*^-6", ",", 
   "4.496032487649615`*^-7", ",", "3.1758611228207976`*^-7", ",", 
   "1.8174203482970954`*^-7", ",", "5.369819586209266`*^-7", ",", 
   "2.9928969369389895`*^-7", ",", "1.530384992597204`*^-7", ",", 
   "1.5536424726678812`*^-7", ",", "1.0643851073540748`*^-6", ",", 
   "5.86154675125621`*^-7", ",", "7.424097799604098`*^-7", ",", 
   "7.801826749596356`*^-7", ",", "2.1892648846171772`*^-7", ",", "0.`", ",", 
   "7.326320763711792`*^-7", ",", "5.767179952974883`*^-7", ",", 
   "9.762195816877453`*^-7", ",", "1.0984545163517594`*^-6", ",", 
   "3.6281618104999536`*^-7", ",", "8.850243339722997`*^-12", ",", 
   "9.18976361281943`*^-12", ",", "1.84095989637437`*^-8", ",", 
   "1.7451850497453425`*^-8", ",", "1.0192899255925331`*^-11", ",", 
   "2.0000007019218614`*^-10", ",", "125.40965892795225`", ",", 
   "62.08798954658357`", ",", "4.075955872143284`*^-10", ",", 
   "19.208490365045016`", ",", "1.7489162005217955`*^-8", ",", 
   "0.5784536163765428`", ",", "0.20099399991042052`", ",", 
   "0.25937399983370657`", ",", "8.093983862343254`*^-11", ",", 
   "3.1412349815581395`", ",", "1.2069746818286442`*^-10", ",", 
   "8.776168864700217`*^-11", ",", "50.29299777412362`", ",", 
   "10.294744220945192`", ",", "47.34915627513004`", ",", 
   "67.92726919808246`", ",", "24.67620964904511`", ",", "14.69866633237674`",
    ",", "51.77503589899253`", ",", "54.091296942947785`", ",", 
   "13.649588896147465`", ",", "12.878304405491782`", ",", 
   "112.70192601289796`", ",", "60.55264438373992`", ",", 
   "140.9566488604228`", ",", "136.4645030017892`", ",", 
   "285.91692261866945`", ",", "75.337629086548`", ",", "218.42179054411662`",
    ",", "161.95389420262282`", ",", "1.131965719935551`", ",", 
   "0.45316316197008344`", ",", "34.6202426109961`", ",", 
   "11.922496072961208`", ",", "2.029706462106864`*^-11", ",", 
   "0.5186279694751906`", ",", "7.640871311489957`*^-8", ",", 
   "29.99999982335669`", ",", "5.65437796597382`*^-11", ",", 
   "2.4139034103644374`*^-9", ",", "1.9753249045330115`*^-10", ",", 
   "7.631984052361268`*^-12", ",", "1.017779452637278`*^-11", ",", 
   "1.6617724816840694`*^-11", ",", "3.162928831429428`*^-12", ",", 
   "1.8684587938024762`*^-10", ",", "1.0741669174218564`*^-11", ",", 
   "7.288867610404162`*^-12", ",", "37.53478009487748`", ",", 
   "1.0757123009859216`*^-9", ",", "8.186670300762129`*^-10", ",", 
   "1.6336587790198314`*^-9", ",", "2.847261318450579`*^-9", ",", 
   "1.589946963915691`*^-9", ",", "1.336705625025065`*^-9", ",", 
   "1.2481034159455364`*^-9", ",", "3.1617352323263974`*^-9", ",", 
   "2.031677250744643`*^-9", ",", "3.13079933764773`*^-9", ",", 
   "2.8967338319223165`*^-9", ",", "8.881313087159408`*^-10", ",", 
   "1.199811665552618`*^-9", ",", "8.908808928157537`*^-9", ",", 
   "8.873522060880325`*^-10", ",", "5.037426820479395`*^-9", ",", 
   "9.911570133904122`*^-10", ",", "2.1755018266456803`*^-9", ",", 
   "3.8498399370835314`", ",", "1.4727807917563753`", ",", 
   "44.57021745419052`", ",", "8.577499927573859`", ",", 
   "21.086678377432897`", ",", "181.7852127749376`", ",", "0.`", ",", 
   "2.556692304729016`", ",", "853.6413372404868`", ",", 
   "329.75124323082423`", ",", "2.352845750234405`*^-11", ",", 
   "44.972484545954465`", ",", "9.99427651330472`*^-6", ",", 
   "2.591539757026705`*^-12", ",", "5.250249343626016`*^-12", ",", 
   "1.406526040046485`*^-12", ",", "1.6621338558905467`*^-12", ",", 
   "9.632255535216167`", ",", "0.4642798979768901`", ",", 
   "0.006750000026465533`", ",", "0.4799999999186603`", ",", 
   "1.5748635126346143`*^-11", ",", "4.75728525584396`*^-12", ",", 
   "863.9999999924331`", ",", "37.72799999770834`", ",", 
   "2.499348489463037`*^-12", ",", "1.6308127931097947`*^-12", ",", 
   "1.1927504179581904`*^-12", ",", "9.348739004538534`*^-13", ",", "0.`", 
   ",", "1.5444015411979763`*^-10", ",", "5.417404759798586`", ",", 
   "1.58832577706635`*^-10", ",", "6.647691479805082`", ",", 
   "0.4544179522664105`", ",", "1.8707855702248308`*^-11", ",", 
   "3.217461030644577`*^-12", ",", "647.9999999983421`", ",", 
   "124.9649368834711`", ",", "1.4217582268463863`*^-12", ",", 
   "8.681367637000477`*^-13", ",", "6.125209506084314`*^-13", ",", 
   "4.695681730291644`*^-13", ",", "3.7960164853264365`*^-13", ",", "0.`", 
   ",", "5.373492285989273`", ",", "6.156449929772566`", ",", 
   "106.92374865556103`", ",", "2.6001630168266565`*^-11", ",", 
   "6.459707693124118`*^-11", ",", "5.1053331247468074`*^-11", ",", 
   "1.4352121668473692`*^-11", ",", "2.9742432152069305`", ",", 
   "3.724477341888494`*^-7", ",", "1.0092036762113294`*^-8", ",", 
   "1.6483334628241832`*^-8", ",", "0.08463801592239369`", ",", 
   "903.5142027405851`", ",", "3.864578439376219`*^-8", ",", 
   "0.11955559640700968`", ",", "0.41330926561080517`", ",", 
   "0.35007000072596434`", ",", "0.030087457983128833`", ",", 
   "0.0043619217664572826`", ",", "0.001609534438295058`", ",", "0.`", ",", 
   "13.984886610145367`", ",", "6.999999999759546`", ",", 
   "4.999999999981217`", ",", "0.`", ",", "2.8316576936143098`*^-11", ",", 
   "8.885253577345976`*^-11", ",", "6.458288650288242`*^-11", ",", 
   "1.5362603378826538`*^-11", ",", "0.009958999980611845`", ",", 
   "6.150955999994142`", ",", "4.744145855307579`", ",", "30.36091899871826`",
    ",", "11.686140567064285`", ",", "106.5538158416748`", ",", 
   "1.2091814958687898`*^-10", ",", "1.0602165800022176`*^-10", ",", 
   "1.5905327314233637`*^-7", ",", "8.194243518406354`*^-9", ",", 
   "5.499692297983611`*^-11", ",", "0.018223771614836886`", ",", 
   "1.9946902989448347`*^-7", ",", "2.8205556992142477`*^-7", ",", 
   "2.3461836072194187`", ",", "8.014590519034001`*^-9", ",", 
   "1.6743854140815132`*^-8", ",", "0.32896689312302074`", ",", 
   "0.12078919995460445`", ",", "0.1558731999160931`", ",", 
   "7.386472000105292`*^-11", ",", "5.964602049961894`*^-10", ",", 
   "1.8493182845083354`*^-11", ",", "7.30632935000995`*^-11", ",", 
   "93.03940269351006`", ",", "12.132013007998466`", ",", 
   "82.43200418353081`", ",", "134.31624473631382`", ",", 
   "35.15874932706356`", ",", "24.0641470849514`", ",", "81.6407941877842`", 
   ",", "82.96544909477234`", ",", "23.220796912908554`", ",", 
   "22.973619997501373`", ",", "192.89121790230274`", ",", 
   "86.04970821738243`", ",", "249.94335773587227`", ",", 
   "237.88028305768967`", ",", "468.19047424197197`", ",", 
   "130.887439802289`", ",", "142.136832639575`", ",", "194.36538816988468`", 
   ",", "732.2646452868364`", ",", "21.43751450534774`", ",", 
   "3127.9993391150756`", ",", "253.5100201983026`", ",", 
   "211.1030760135596`", ",", "81313.81231977267`", ",", "81313.81232008673`",
    ",", "5.423314703190145`*^-7", ",", "1233.94017953995`", ",", 
   "2451.822997233948`", ",", "7.254678123185158`*^-7", ",", 
   "761.3687113290466`", ",", "619.2395015318737`", ",", "7778.191405675823`",
    ",", "5.82819326122689`*^-7", ",", "6.254012721950732`*^-7", ",", 
   "6.684987258495149`*^-7", ",", "7.963748848362436`*^-7", ",", 
   "7.024134891283953`*^-7", ",", "0.`", ",", "3.556187119609066`*^-7", ",", 
   "5.771819687970932`*^-7", ",", "6.938467895249536`*^-7", ",", 
   "7.153918689331636`*^-7", ",", "5.848718177439418`*^-7", ",", 
   "8180.898437339315`", ",", "0.00001445363986624936`", ",", 
   "3.359304113682322`*^-6", ",", "5619.039062220463`", ",", 
   "1528.58944704551`", ",", "5.530085833295009`*^-7", ",", 
   "3.3785594133070086`*^-7", ",", "1410.8496083904147`", ",", 
   "862.7497552895935`", ",", "452.68969624032127`", ",", 
   "8363.597655160464`", ",", "5298.2968742916555`", ",", "0.`", ",", 
   "1354.0097656107425`", ",", "21930.894529420482`", ",", 
   "9177.624999245443`", ",", "13369.578129237769`", ",", 
   "416.1499013511041`", ",", "2.323271361262249`*^-6", ",", 
   "9.831697263751209`*^-7", ",", "5.952911995659273`*^-7", ",", 
   "1.6397697711938019`*^-6", ",", "6.974501124926749`*^-7", ",", 
   "2.753866123210498`*^-7", ",", "2.749969306620662`*^-7", ",", 
   "0.00005209214442282877`", ",", "6.851204321949436`*^-6", ",", 
   "3.7751795055133663`*^-6", ",", "2.564984844298371`*^-6", ",", 
   "5.667887872169102`*^-7", ",", "0.`", ",", "1.51399646831781`*^-6", ",", 
   "6.913675722284244`*^-7", ",", "0.000010568455893480193`", ",", 
   "5035.292961434773`", ",", "1.602340123343922`*^-6", ",", 
   "1.2091814958687898`*^-10", ",", "1.0602165800022176`*^-10", ",", 
   "1.5905327314233637`*^-7", ",", "8.194243518406354`*^-9", ",", 
   "5.499692297983611`*^-11", ",", "0.018223771614836886`", ",", 
   "1.9946902989448347`*^-7", ",", "2.8205556992142477`*^-7", ",", 
   "2.3461836072194187`", ",", "8.014590519034001`*^-9", ",", 
   "1.6743854140815132`*^-8", ",", "0.32896689312302074`", ",", 
   "0.12078919995460445`", ",", "0.1558731999160931`", ",", 
   "7.386472000105292`*^-11", ",", "5.964602049961894`*^-10", ",", 
   "1.8493182845083354`*^-11", ",", "7.30632935000995`*^-11", ",", 
   "3.2971808297555373`*^-9", ",", "2.759046114646796`*^-9", ",", 
   "5.19886116079027`*^-9", ",", "9.099966199476396`*^-9", ",", 
   "5.378165084256141`*^-9", ",", "5.584491145705456`*^-9", ",", 
   "4.994692877236045`*^-9", ",", "1.0364858984767004`*^-8", ",", 
   "7.860211352340762`*^-9", ",", "1.3318831504877016`*^-8", ",", 
   "9.45997126519652`*^-9", ",", "2.6736853124150896`*^-9", ",", 
   "3.422590624975993`*^-9", ",", "2.9402123149703608`*^-8", ",", 
   "2.3517329797744722`*^-9", ",", "2.6770865090332234`*^-8", ",", 
   "90.21659631426029`", ",", "11.58802179154846`", ",", 
   "2.8069607815460677`*^-11", ",", "3.150664954749725`*^-11", ",", 
   "4.784874163466599`*^-8", ",", "5.096929666957385`*^-9", ",", 
   "1.2464593439667056`*^-11", ",", "6.626560398011454`*^-10", ",", 
   "1.2768600458524906`*^-7", ",", "29.99999960866463`", ",", 
   "9.225763352989384`*^-11", ",", "5.246391953367515`", ",", 
   "1.6462202555541458`*^-11", ",", "1.4880741228631053`*^-11", ",", 
   "1.9919906557073577`*^-11", ",", "3.27707995985456`*^-11", ",", 
   "6.241281092050654`*^-12", ",", "0.6629056203665502`", ",", 
   "3.5076123052579284`*^-11", ",", "1.956839968616382`*^-11", ",", 
   "4.368498817430905`*^-9", ",", "8.600643658195324`", ",", 
   "1.6005706803505684`", ",", "8.53740748240942`", ",", 
   "12.093120064784106`", ",", "3.926861352965801`", ",", 
   "2.8312399813724687`", ",", "10.15011446363479`", ",", "9.30483096780036`",
    ",", "2.6426074259256946`", ",", "2.55071104060727`", ",", 
   "21.567093293765392`", ",", "9.268973671201207`", ",", 
   "25.561060948684883`", ",", "24.082626408194656`", ",", 
   "48.95831786904158`", ",", "15.674974206209175`", ",", 
   "1.107222856251695`*^-8", ",", "3.440291793053508`*^-8", ",", 
   "4.358714501892147`", ",", "2.0983213692861775`", ",", 
   "60.33983902249277`", ",", "10.248594720559758`", ",", 
   "3.6459619503627416`", ",", "179.61421315274572`", ",", "0.`", ",", 
   "3.054794899565575`", ",", "762.7098497714492`", ",", "951.3793321769338`",
    ",", "3.46412164319418`*^-11", ",", "57.81680255680074`", ",", 
   "9.996397500623777`*^-6", ",", "3.0651607217640624`*^-12", ",", 
   "4.3025336492324615`*^-12", ",", "1.6453749146563265`*^-12", ",", 
   "1.971926049662484`*^-12", ",", "12.283878031917853`", ",", 
   "0.4555199991102994`", ",", "0.04451999974147227`", ",", 
   "0.704999999898433`", ",", "1.9679354078759232`*^-11", ",", 
   "5.943570068941898`*^-12", ",", "1268.9999999909408`", ",", 
   "55.41299999714952`", ",", "3.1239996433753155`*^-12", ",", 
   "2.0393804326441832`*^-12", ",", "1.4918762985659921`*^-12", ",", 
   "1.1694474227431291`*^-12", ",", "0.`", ",", "1.3144249715472874`*^-10", 
   ",", "5.1234490697171164`", ",", "1.3267782273441903`*^-10", ",", 
   "8.027210749738343`", ",", "0.6676016829762789`", ",", 
   "2.1133670873506366`*^-11", ",", "3.4816970609890746`*^-12", ",", 
   "951.9999999982022`", ",", "183.590462829884`", ",", 
   "1.5575983764307054`*^-12", ",", "9.513716574931472`*^-13", ",", 
   "6.722141603931653`*^-13", ",", "5.159968937377141`*^-13", ",", 
   "4.1752432280751103`*^-13", ",", "0.`", ",", "7.894389901685041`", ",", 
   "7.865592049090424`", ",", "131.18298456722678`", ",", 
   "2.97503687502164`*^-11", ",", "4.941526549870711`*^-11", ",", 
   "4.0848727704877424`*^-11", ",", "1.6442590806795812`*^-11", ",", 
   "3.378918572309809`", ",", "2.7363428347804376`*^-8", ",", 
   "4.73158626141799`*^-9", ",", "7.422842300659134`*^-9", ",", 
   "3.873298549052752`*^-10", ",", "1541.7995941253412`", ",", 
   "1.4248491197367058`*^-8", ",", "5.885514809465568`*^-11", ",", 
   "1.1127941116996065`*^-10", ",", "0.8351907026498356`", ",", 
   "0.164809297101111`", ",", "2.6225580713076402`*^-11", ",", 
   "6.876806500148202`*^-12", ",", "0.`", ",", "19.947999248835977`", ",", 
   "6.999999999767229`", ",", "4.9999999999746345`", ",", "0.`", ",", 
   "3.266768048486149`*^-11", ",", "6.13018687006635`*^-11", ",", 
   "4.8471403662256784`*^-11", ",", "1.7863221828546955`*^-11", ",", 
   "0.012068999979798229`", ",", "7.863315999993293`", ",", 
   "6.487500414252281`", ",", "39.032116547226906`", ",", 
   "15.659634485840797`", ",", "127.95092914998531`", ",", 
   "8.03405785273946`*^-11", ",", "7.85394657700394`*^-11", ",", 
   "1.914670117178245`*^-7", ",", "5.7808764676451234`*^-8", ",", 
   "1.252907574691931`*^-10", ",", "1.627529167278689`*^-9", ",", 
   "3.7027097021878863`*^-7", ",", "5.626286659217553`*^-7", ",", 
   "1.8769468861869072`", ",", "6.768546910935833`*^-9", ",", 
   "1.258746666346291`*^-8", ",", "0.12857151458825805`", ",", 
   "0.056384360086185345`", ",", "0.07276156013328018`", ",", 
   "1.0135401958387975`*^-10", ",", "5.05378342583923`*^-10", ",", 
   "2.696565312700371`*^-11", ",", "6.623397729748103`*^-11", ",", 
   "113.37439732253551`", ",", "16.952837377786636`", ",", 
   "104.60214954614639`", ",", "162.20946405828`", ",", "45.90744322538376`", 
   ",", "32.070894971489906`", ",", "111.27135802805424`", ",", 
   "108.50372284650803`", ",", "30.542105302214622`", ",", 
   "29.928266033530235`", ",", "251.96666081249714`", ",", 
   "110.80877225100994`", ",", "315.6926707327366`", ",", 
   "299.3480050712824`", ",", "596.2308533936739`", ",", "175.6846984922886`",
    ",", "191.0256586074829`", ",", "261.4963470250368`", ",", 
   "915.7292720883527`", ",", "24.96388669829303`", ",", "3736.145540956144`",
    ",", "317.02547399698665`", ",", "310.06979294680906`", ",", 
   "96137.03413638684`", ",", "96137.03413671281`", ",", 
   "6.386493829652347`*^-7", ",", "7.65727477026669`*^-6", ",", 
   "2567.0305153843938`", ",", "7.946453524450587`*^-7", ",", 
   "6.782325075506883`*^-6", ",", "648.336669398694`", ",", 
   "8143.679687600407`", ",", "6.139806088722757`*^-7", ",", 
   "6.75257871746329`*^-7", ",", "6.69487594077207`*^-7", ",", 
   "7.886642473012508`*^-7", ",", "9.245912986557704`*^-7", ",", "0.`", ",", 
   "3.74008673607659`*^-7", ",", "6.362509180823599`*^-7", ",", 
   "6.96753149611046`*^-7", ",", "8.121886880164073`*^-7", ",", 
   "6.550953572535961`*^-7", ",", "9913.792968175623`", ",", 
   "0.000014257582756984625`", ",", "2.8736558868495503`*^-6", ",", 
   "6809.2773431265`", ",", "1852.379140334218`", ",", 
   "6.924460121775584`*^-7", ",", "4.1417851737642985`*^-7", ",", 
   "1709.699218349842`", ",", "1045.4995111986616`", ",", 
   "548.5795892129755`", ",", "10135.195309151195`", ",", 
   "6420.593749064889`", ",", "0.`", ",", "1640.8193355890714`", ",", 
   "26576.34765936033`", ",", "11121.652339223465`", ",", 
   "16201.550779119752`", ",", "504.2998042567331`", ",", 
   "1.4959577026076966`*^-6", ",", "1.0186218993846516`*^-6", ",", 
   "5.936233069890289`*^-7", ",", "1.4730799755032604`*^-6", ",", 
   "7.693539926382274`*^-7", ",", "3.1397708060001856`*^-7", ",", 
   "3.2636246741732325`*^-7", ",", "0.000014432532876600582`", ",", 
   "4.534212338888071`*^-6", ",", "4.227835535565733`*^-6", ",", 
   "2.9513141640595906`*^-6", ",", "5.037669352861084`*^-7", ",", "0.`", ",", 
   "1.4741126262019162`*^-6", ",", "6.663495873270552`*^-7", ",", 
   "0.000010380824224290692`", ",", "2317.135616547885`", ",", 
   "1.3485345951027723`*^-6", ",", "8.03405785273946`*^-11", ",", 
   "7.85394657700394`*^-11", ",", "1.914670117178245`*^-7", ",", 
   "5.7808764676451234`*^-8", ",", "1.252907574691931`*^-10", ",", 
   "1.627529167278689`*^-9", ",", "3.7027097021878863`*^-7", ",", 
   "5.626286659217553`*^-7", ",", "1.8769468861869072`", ",", 
   "6.768546910935833`*^-9", ",", "1.258746666346291`*^-8", ",", 
   "0.12857151458825805`", ",", "0.056384360086185345`", ",", 
   "0.07276156013328018`", ",", "1.0135401958387975`*^-10", ",", 
   "5.05378342583923`*^-10", ",", "2.696565312700371`*^-11", ",", 
   "6.623397729748103`*^-11", ",", "2.7638993526846024`*^-9", ",", 
   "2.447007107468676`*^-9", ",", "4.335389056089146`*^-9", ",", 
   "7.705734597459445`*^-9", ",", "4.538118894817585`*^-9", ",", 
   "4.481541657243757`*^-9", ",", "3.738022761139707`*^-9", ",", 
   "8.803172555461117`*^-9", ",", "6.4102322722539754`*^-9", ",", 
   "1.0361412142233278`*^-8", ",", "7.661304308878475`*^-9", ",", 
   "2.2050148046778423`*^-9", ",", "2.7958843641872652`*^-9", ",", 
   "2.493177176778234`*^-8", ",", "1.924509234390512`*^-9", ",", 
   "1.3163685216415456`*^-8", ",", "7.55212246153026`*^-9", ",", 
   "1.4727496822610072`*^-8", ",", "0.7828836717050902`", ",", 
   "0.9623697823086034`", ",", "3.14862074465711`*^-7", ",", 
   "1.633714746015671`*^-8", ",", "1.1282290987751843`*^-10", ",", 
   "0.4689445608574021`", ",", "4.415968507026752`*^-7", ",", 
   "510.07828918541856`", ",", "4.6497422964748284`*^-10", ",", 
   "1.9808995915710466`*^-7", ",", "4.400531200618675`*^-10", ",", 
   "1.2116556011187693`*^-10", ",", "1.63838981965665`*^-10", ",", 
   "2.7038560416710657`*^-10", ",", "5.994773196968372`*^-11", ",", 
   "1.529217225567167`*^-8", ",", "4.359495689855283`*^-7", ",", 
   "0.04399994884433023`", ",", "2.843010947236771`*^-9", ",", 
   "8.86726371867568`", ",", "1.650188447319194`", ",", "8.802067278637503`", 
   ",", "12.468007071180523`", ",", "4.048594211653589`", ",", 
   "2.919008606447568`", ",", "10.464768124365559`", ",", 
   "9.593281039337574`", ",", "2.7245284965299374`", ",", 
   "2.6297833148824035`", ",", "22.23567348283472`", ",", 
   "9.556311941878104`", ",", "26.353453950693293`", ",", 
   "24.829188701755907`", ",", "50.47602580100498`", ",", 
   "16.160898712162236`", ",", "13.73356643648062`", ",", 
   "108.51179453986997`"}], "}"}]], "Output",
 CellChangeTimes->{3.625405226454393*^9}],

Cell[BoxData[
 RowBox[{"-", "2581.139258756746`"}]], "Output",
 CellChangeTimes->{3.625405226494399*^9}],

Cell[BoxData["0.00014668377550010247`"], "Output",
 CellChangeTimes->{3.625405226494399*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<tolerance\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", 
   StyleBox["myTolerance", "MR"], " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.625405267817026*^9, 3.6254052894547677`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\value5.txt\"\>"], \
"Output",
 CellChangeTimes->{3.6254053033218837`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\sol5.txt\"\>"], "Output",
 CellChangeTimes->{3.625405303341885*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\standardization\\\\tolerance5.txt\"\>"], \
"Output",
 CellChangeTimes->{3.625405303341885*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 871},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 95, 5, 171, "Subtitle"],
Cell[CellGroupData[{
Cell[699, 31, 300, 6, 60, "Input"],
Cell[1002, 39, 189, 2, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1228, 46, 3212, 96, 244, "Input"],
Cell[4443, 144, 127, 2, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4607, 151, 470, 12, 83, "Input"],
Cell[5080, 165, 35024, 537, 2981, "Output"],
Cell[40107, 704, 104, 2, 36, "Output"],
Cell[40214, 708, 92, 1, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[40343, 714, 886, 23, 83, "Input"],
Cell[41232, 739, 203, 3, 36, "Output"],
Cell[41438, 744, 197, 2, 36, "Output"],
Cell[41638, 748, 205, 3, 93, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
