(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     20991,        461]
NotebookOptionsPosition[     19958,        422]
NotebookOutlinePosition[     20379,        438]
CellTagsIndexPosition[     20336,        435]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the LP problem defined by:
min(c) s.t.
A.x = b
lb <= x <= ub\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myProblemId", " ", "=", " ", 
   RowBox[{"ToString", "[", "\"\<12\>\"", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6254017827997074`*^9, 3.625401789489383*^9}, {
   3.62540221040353*^9, 3.62540221501353*^9}, {3.6254034296636076`*^9, 
   3.6254034297236075`*^9}, {3.6254034769446077`*^9, 
   3.6254034770046077`*^9}, {3.625403522213608*^9, 3.6254035222736073`*^9}, {
   3.6254036146116076`*^9, 3.6254036147016077`*^9}, {3.6254036448236074`*^9, 
   3.625403672699608*^9}, 3.6254037069156075`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\presolving\\\\\"\>"], "Output",
 CellChangeTimes->{{3.6254021847505302`*^9, 3.62540221582653*^9}, {
   3.6254034169736075`*^9, 3.625403433527608*^9}, {3.6254034682216077`*^9, 
   3.6254035463666077`*^9}, {3.625403617588608*^9, 3.6254036472606077`*^9}, 
   3.625403678397608*^9, 3.625403710192608*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<c\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", "=", 
  RowBox[{"Length", "[", "c", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<A\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<b\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"lb", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<lb\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      StyleBox[
       RowBox[{"-", "999999"}], "MR"]}], "}"}]}]}], 
  StyleBox[";", "MR"]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ub", "=", 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<ub\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"+", 
       StyleBox["999999", "MR"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"variablesBounds", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lb", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       RowBox[{"ub", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6254018116213045`*^9, 3.6254018416588426`*^9}, {
  3.625401889667062*^9, 3.625401913965825*^9}, {3.625402005862931*^9, 
  3.625402008359906*^9}, {3.62540225317553*^9, 3.6254022539025297`*^9}}],

Cell[BoxData["346"], "Output",
 CellChangeTimes->{
  3.62540219027353*^9, 3.6254022574025297`*^9, {3.6254034171936073`*^9, 
   3.6254034336276073`*^9}, {3.625403468291608*^9, 3.6254035464366074`*^9}, {
   3.6254036176486073`*^9, 3.6254036473206077`*^9}, 3.6254036784576073`*^9, 
   3.6254037102526073`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{"c", ",", "A", ",", "bCoeff", ",", " ", "variablesBounds"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.4389493197813755`*^-11", ",", "1.0107492013834341`*^-10", ",", 
   "4.9620454356126065`*^-11", ",", "1.0687058732967156`*^-10", ",", 
   "7.527943868781965`*^-7", ",", "4.410398720476612`*^-11", ",", 
   "9.864806638510383`*^-11", ",", "44.43705012225274`", ",", 
   "251.2803227631182`", ",", "7.523188618944525`*^-7", ",", 
   "44.99999999966878`", ",", "3.350030314857436`*^-10", ",", 
   "59.43705012287988`", ",", "235.56294987775075`", ",", 
   "4.016845146416523`*^-7", ",", "3.877106776512246`*^-11", ",", 
   "9.622256600611886`*^-11", ",", "74.437050125198`", ",", 
   "220.5629498771223`", ",", "4000.0000003935934`", ",", 
   "4.780075690769928`*^-11", ",", "1.0364112783881998`*^-10", ",", 
   "90.66633176443841`", ",", "205.56294987480416`", ",", 
   "7.521596547774853`*^-7", ",", "3.778066203807655`*^-11", ",", 
   "9.514566970293212`*^-11", ",", "33.95970201908894`", ",", 
   "9.333668235565721`", ",", "7.539578891720001`*^-7", ",", 
   "640.0023743474889`", ",", "160.00024609289102`", ",", 
   "100.0009361080461`", ",", "213.33583199759084`", ",", 
   "56.66212534198006`", ",", "133.33515870006553`", ",", 
   "3.929247253312215`*^-11", ",", "9.786410397657316`*^-11", ",", 
   "7.54804956500957`*^-7", ",", "5.189398144937332`*^-11", ",", 
   "1.0791670289370439`*^-10", ",", "54.75611127306081`", ",", 
   "0.24388872694298291`", ",", "3.9789833641737457`*^-7", ",", 
   "4.9828409149328463`*^-11", ",", "1.4261892913598386`*^-10", ",", 
   "4000.0000003868436`", ",", "4.879423827143412`*^-11", ",", 
   "1.2927264189448605`*^-10", ",", "7.520446309465374`*^-7", ",", 
   "4.3763788135044785`*^-11", ",", "1.5223131799245177`*^-10", ",", 
   "7.517520244821699`*^-7", ",", "43.77071836104811`", ",", 
   "11.22928163895568`", ",", "3.999190222708794`*^-7", ",", 
   "5.4174538930806596`*^-11", ",", "1.1011889856891022`*^-10", ",", 
   "4000.0000003888204`", ",", "239.99863002407284`", ",", 
   "2.7192749542121614`*^-8", ",", "1.0163941305417834`*^-7", ",", 
   "5.147354848211564`*^-11", ",", "1.0471881166329591`*^-10", ",", 
   "1000.0000004238665`", ",", "36.5242114906225`", ",", "8.475788509381355`",
    ",", "0.`", ",", "4.173425043465294`*^-11", ",", 
   "9.911995797303588`*^-11", ",", "3.862451028327343`*^-12", ",", 
   "4000.0000003923064`", ",", "4.206835947031218`*^-11", ",", 
   "9.967558317824832`*^-11", ",", "1.0000000000029663`", ",", 
   "7.519095198855228`*^-7", ",", "3.8703395967897484`*^-11", ",", 
   "9.507721656929288`*^-11", ",", "4.8947979313290805`*^-12", ",", 
   "7.529531768373664`*^-7", ",", "44.99999999798974`", ",", 
   "2.0141179005133452`*^-9", ",", "2.884857805443133`*^-12", ",", 
   "4.0516942672518027`*^-7", ",", "4.208234110953334`*^-11", ",", 
   "9.348970486002045`*^-11", ",", "4.125804667474109`*^-12", ",", 
   "4000.0000003921673`", ",", "16.70662974564972`", ",", 
   "28.29337025435408`", ",", "2.4871392596168315`*^-12", ",", 
   "3.934481598492846`*^-7", ",", "5.766595844638317`*^-7", ",", 
   "3.391612877467146`*^-11", ",", "8.912557325292829`*^-11", ",", 
   "3.1335974375893444`*^-12", ",", "4000.000000396348`", ",", 
   "4.37088159429452`*^-11", ",", "1.0261257972512647`*^-10", ",", 
   "4.8233663220790376`*^-11", ",", "1.084525420417809`*^-10", ",", 
   "7.523939148750472`*^-7", ",", "44.282627114922974`", ",", 
   "0.7173728850808022`", ",", "3.988935770557386`*^-7", ",", 
   "4.2720752650827105`*^-11", ",", "9.833150212808267`*^-11", ",", 
   "4000.0000003933824`", ",", "3.836684508925077`*^-11", ",", 
   "9.308413109416582`*^-11", ",", "7.537962808273771`*^-7", ",", 
   "4.519533306899836`*^-11", ",", "1.24374373029778`*^-10", ",", 
   "7.516213686334046`*^-7", ",", "3.758500806848444`*^-11", ",", 
   "1.0784900087716867`*^-10", ",", "1000.0000004250569`", ",", 
   "3.929750574624927`*^-11", ",", "1.1237487242865406`*^-10", ",", 
   "7.5435815664528`*^-7", ",", "4.1960266089895625`*^-11", ",", 
   "8.804105520433707`*^-11", ",", "4.669629187843005`*^-11", ",", 
   "9.293933399418676`*^-11", ",", "1500.0000004200244`", ",", 
   "4.1079550523410825`*^-11", ",", "7.167126154286291`*^-11", ",", 
   "2000.0000004162168`", ",", "4.061074557134134`*^-11", ",", 
   "9.119347902691276`*^-11", ",", "1500.0000004192716`", ",", 
   "3.711021259997259`*^-11", ",", "8.910733940193234`*^-11", ",", 
   "1500.0000004212438`", ",", "4.614111714501345`*^-11", ",", 
   "9.121775878956135`*^-11", ",", "1500.000000420574`", ",", 
   "3.735349971270359`*^-11", ",", "1.0132232055105471`*^-10", ",", 
   "2000.0000004124074`", ",", "13.95970201939066`", ",", 
   "26.040297980613136`", ",", "4.1201830989330663`*^-7", ",", 
   "102730.63235756244`", ",", "0.000012639153966481761`", ",", 
   "5600.8301059708465`", ",", "0.`", ",", "0.`", ",", "21500.000018477043`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "1.`", ",", "1300.`", 
   ",", "600.`", ",", "110.`", ",", "900.`", ",", "1065.2421149129862`", ",", 
   "294.8147493878025`", ",", "999.0315403720497`", ",", "618.2905378948077`",
    ",", "1012.8032276478945`", ",", "694.3258475398906`", ",", 
   "867.9343221964864`", ",", "555.3638731762787`", ",", "855.629498800509`", 
   ",", "490.00000004363346`", ",", "475.00000006744705`", ",", 
   "1762.7537039797282`", ",", "1855.629498821971`", ",", 
   "295.00000004784476`", ",", "100.00000005756009`", ",", 
   "1582.7537039793074`", ",", "1705.6294988053985`", ",", 
   "100.00000003434538`", ",", "650.0000001306724`", ",", 
   "1402.7537039581753`", ",", "1543.3366824214006`", ",", 
   "1378.3425311472004`", ",", "244.26795915560135`", ",", 
   "1208.0023242987256`", ",", "1110.4029798837607`", ",", 
   "815.5287178498411`", ",", "1626.0027693256925`", ",", 
   "688.4818812536612`", ",", "650.0000000907471`", ",", 
   "217.00484412853393`", ",", "474.99531982259816`", ",", 
   "135.9983055647761`", ",", 
   RowBox[{"-", "3.8604639485129155`*^-9"}], ",", 
   RowBox[{"-", "4.011141641058202`*^-9"}], ",", 
   RowBox[{"-", "3.966235340158164`*^-9"}], ",", 
   RowBox[{"-", "3.9715501998216496`*^-9"}], ",", 
   RowBox[{"-", "4.457888280740008`*^-9"}], ",", 
   RowBox[{"-", "4.450797064237122`*^-9"}], ",", 
   RowBox[{"-", "4.450711799108831`*^-9"}], ",", 
   RowBox[{"-", "4.4556855982591514`*^-9"}], ",", 
   RowBox[{"-", "5.261085789243225`*^-9"}], ",", 
   RowBox[{"-", "5.076259412817308`*^-9"}], ",", 
   RowBox[{"-", "5.087940735393204`*^-9"}], ",", 
   RowBox[{"-", "5.053038876212668`*^-9"}], ",", 
   RowBox[{"-", "6.305128863459686`*^-9"}], ",", 
   RowBox[{"-", "5.9216347381152445`*^-9"}], ",", 
   RowBox[{"-", "6.83374423715577`*^-9"}], ",", 
   RowBox[{"-", "5.892488275094365`*^-9"}], ",", 
   RowBox[{"-", "7.805056156939827`*^-9"}], ",", 
   RowBox[{"-", "8.744549973016547`*^-9"}], ",", 
   RowBox[{"-", "7.1167960413731635`*^-9"}], ",", 
   RowBox[{"-", "7.10247149982024`*^-9"}], ",", 
   RowBox[{"-", "1.0080668744194554`*^-8"}], ",", 
   RowBox[{"-", "9.003301215670945`*^-9"}], ",", 
   RowBox[{"-", "9.0761744786505`*^-9"}], ",", 
   RowBox[{"-", "9.0223295501346`*^-9"}], ",", 
   RowBox[{"-", "1.399178017891245`*^-8"}], ",", 
   RowBox[{"-", "1.2444502317521255`*^-8"}], ",", 
   RowBox[{"-", "1.2516693459474482`*^-8"}], ",", 
   RowBox[{"-", "1.2538833971120766`*^-8"}], ",", 
   RowBox[{"-", "2.4809821752569405`*^-8"}], ",", 
   RowBox[{"-", "3.3905990903804195`*^-8"}], ",", 
   RowBox[{"-", "2.877676763546333`*^-8"}], ",", 
   RowBox[{"-", "8.67517258029693`*^-8"}], ",", "0.`", ",", 
   "23.4757885096649`", ",", "28.719677236885346`", ",", "44.43705012225183`",
    ",", "59.43705012287969`", ",", "74.43705012520006`", ",", 
   "90.66633176443868`", ",", "133.95970201908946`", ",", "180.`", ",", 
   "1.939229127482216`*^-12", ",", "7.390422453776736`*^-11", ",", 
   "2.184265313030333`*^-12", ",", "7.485203427927932`*^-7", ",", 
   "8.337543451230983`*^-11", ",", "1.8788925391700794`*^-12", ",", 
   "7.446495534288444`*^-7", ",", "7.057232195988048`*^-11", ",", "1.`", ",", 
   "3000.000000398412`", ",", "15.000000000335005`", ",", 
   "1.7065451371508905`*^-12", ",", "3.8604451212522015`*^-7", ",", 
   "6.556161055060395`*^-11", ",", "2.0720618254902622`*^-12", ",", 
   "7.490750749451509`*^-7", ",", "7.846292270837041`*^-11", ",", 
   "1.6605583244329505`*^-12", ",", "7.458048130060818`*^-7", ",", 
   "6.379491205663611`*^-11", ",", "1.754610531338619`*^-12", ",", 
   "7.490793312806693`*^-7", ",", "6.79241294338473`*^-11", ",", 
   "2.5529216136419532`*^-12", ",", "1.0322158018206492`*^-10", ",", "1.`", 
   ",", "3000.0000003874125`", ",", "5.243888726942961`", ",", 
   "3.1463206803420744`*^-12", ",", "3.855819046309165`*^-7", ",", 
   "1.4089080175787064`*^-10", ",", "2.88485780544396`*^-12", ",", 
   "7.475715132641749`*^-7", ",", "1.2623720014175902`*^-10", ",", 
   "3.21033148909928`*^-12", ",", "7.478990741078585`*^-7", ",", 
   "1.5082324465819324`*^-10", ",", "1.`", ",", "3000.000000389283`", ",", 
   "16.229281638955655`", ",", "2.6345004865238627`*^-12", ",", 
   "3.8585591894692815`*^-7", ",", "1.058316702217382`*^-10", ",", 
   "2.4871392596160043`*^-12", ",", "4.1717587928623897`*^-7", ",", 
   "9.969477718153746`*^-11", ",", "1.`", ",", "23.47578850938125`", ",", 
   "1.836780129071808`*^-12", ",", "3.866660187169628`*^-7", ",", 
   "7.041252739636824`*^-11", ",", "1.856497422916271`*^-12", ",", 
   "7.455448437756942`*^-7", ",", "7.126391200919096`*^-11", ",", 
   "1.679536786813557`*^-12", ",", "7.487956729939228`*^-7", ",", 
   "6.401113585874444`*^-11", ",", "1.`", ",", "3000.0000004007893`", ",", 
   "15.000000002014026`", ",", "1.7193987415576963`*^-12", ",", 
   "3.866685663023693`*^-7", ",", "6.3021553470613`*^-11", ",", "1.`", ",", 
   "4000.0000003882164`", ",", "43.29337025435404`", ",", 
   "1.4409466539599583`*^-12", ",", "3.8853504446959616`*^-7", ",", 
   "5.448064054951796`*^-11", ",", "1.958273179303641`*^-12", ",", 
   "7.572754490190241`*^-11", ",", "2.1885373971526214`*^-12", ",", 
   "7.474661344851214`*^-7", ",", "8.502147048631718`*^-11", ",", "1.`", ",", 
   "3000.000000391694`", ",", "15.717372885080826`", ",", 
   "1.841181159544212`*^-12", ",", "3.858422276488329`*^-7", ",", 
   "6.96900870084556`*^-11", ",", "1.6278194129763182`*^-12", ",", 
   "7.465826677129431`*^-7", ",", "6.124228977594754`*^-11", ",", 
   "2.4749022999837617`*^-12", ",", "7.488805415199751`*^-7", ",", 
   "1.0523877501667385`*^-10", ",", "1.938514012614146`*^-12", ",", 
   "4.1677760869937314`*^-7", ",", "8.066757855362121`*^-11", ",", 
   "2.0771839016768507`*^-12", ",", "7.481150156799909`*^-7", ",", 
   "8.727349844106784`*^-11", ",", "1.310062085383667`*^-12", ",", 
   "3.8583463532692966`*^-11", ",", "1.5508799842290273`*^-12", ",", 
   "4.119832930722569`*^-7", ",", "4.8298100299471376`*^-11", ",", 
   "8.78800215009399`*^-13", ",", "4.051928602621371`*^-7", ",", 
   "1.3588432463788875`*^-11", ",", "1.3549792353782877`*^-12", ",", 
   "4.1122810948048937`*^-7", ",", "4.2624174993825604`*^-11", ",", 
   "1.21518430736453`*^-12", ",", "4.1158121578596923`*^-7", ",", 
   "3.7746549327066585`*^-11", ",", "1.4935174795626071`*^-12", ",", 
   "4.122101478380236`*^-7", ",", "4.5428933066046174`*^-11", ",", 
   "1.5269254199463061`*^-12", ",", "4.041174582038263`*^-7", ",", 
   "5.6201995570694825`*^-11", ",", "1.`", ",", "2500.0000004078515`", ",", 
   "46.040297980613104`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.62540226023353*^9, {3.6254034177536077`*^9, 3.625403433850608*^9}, {
   3.625403468371608*^9, 3.6254035465366077`*^9}, {3.6254036177236075`*^9, 
   3.6254036474106073`*^9}, 3.6254036785576077`*^9, 3.6254037104726076`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}], "\[IndentingNewLine]", 
 RowBox[{"myTolerance", " ", "=", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}], "]"}]}]}], "Input"],

Cell[BoxData["129831.46249464949`"], "Output",
 CellChangeTimes->{
  3.6254022707915297`*^9, {3.6254034177946076`*^9, 3.6254034338706074`*^9}, {
   3.6254034683916073`*^9, 3.6254035465466075`*^9}, {3.6254036177536077`*^9, 
   3.625403647430608*^9}, 3.625403678567608*^9, 3.6254037104926076`*^9}],

Cell[BoxData["1.7789866444459218`*^-7"], "Output",
 CellChangeTimes->{
  3.6254022707915297`*^9, {3.6254034177946076`*^9, 3.6254034338706074`*^9}, {
   3.6254034683916073`*^9, 3.6254035465466075`*^9}, {3.6254036177536077`*^9, 
   3.625403647430608*^9}, 3.625403678567608*^9, 3.6254037104926076`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<tolerance\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myTolerance", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.625402061704387*^9, 3.6254020621943827`*^9}, {
  3.625402115075867*^9, 3.62540217215053*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\presolving\\\\value12.txt\"\>"], "Output",
 CellChangeTimes->{
  3.62540227620853*^9, {3.6254034178456078`*^9, 3.6254034339006076`*^9}, {
   3.6254034684216075`*^9, 3.625403546588608*^9}, {3.6254036177836075`*^9, 
   3.6254036474406075`*^9}, 3.6254036785836077`*^9, 3.625403710522608*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\presolving\\\\sol12.txt\"\>"], "Output",
 CellChangeTimes->{
  3.62540227620853*^9, {3.6254034178456078`*^9, 3.6254034339006076`*^9}, {
   3.6254034684216075`*^9, 3.625403546588608*^9}, {3.6254036177836075`*^9, 
   3.6254036474406075`*^9}, 3.6254036785836077`*^9, 3.6254037105326076`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\presolving\\\\tolerance12.txt\"\>"], \
"Output",
 CellChangeTimes->{
  3.62540227620853*^9, {3.6254034178456078`*^9, 3.6254034339006076`*^9}, {
   3.6254034684216075`*^9, 3.625403546588608*^9}, {3.6254036177836075`*^9, 
   3.6254036474406075`*^9}, 3.6254036785836077`*^9, 3.6254037105326076`*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 871},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 95, 5, 171, "Subtitle"],
Cell[CellGroupData[{
Cell[699, 31, 633, 11, 60, "Input"],
Cell[1335, 44, 411, 5, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1783, 54, 2937, 88, 198, "Input"],
Cell[4723, 144, 306, 5, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5066, 154, 169, 4, 36, "Input"],
Cell[5238, 160, 11647, 185, 976, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16922, 350, 253, 6, 60, "Input"],
Cell[17178, 358, 295, 4, 36, "Output"],
Cell[17476, 364, 299, 4, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17812, 373, 904, 23, 83, "Input"],
Cell[18719, 398, 399, 5, 36, "Output"],
Cell[19121, 405, 399, 5, 36, "Output"],
Cell[19523, 412, 407, 6, 93, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
