(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8191,        263]*)
(*NotebookOutlinePosition[      8841,        285]*)
(*  CellTagsIndexPosition[      8797,        281]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    \(\(rootDir\  = \ \
"\<D:\\DATADIR\\Programmazione\\java\\joptimizer\\src\\test\\resources\\lp\\\
netlib\\\>";\)\), "\[IndentingNewLine]", 
    \(\(problemName\  = \ "\<fit1d\>";\)\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{\(workingDir\  = \ 
        rootDir\  <> \ problemName;\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["c",
          "MR"], 
        StyleBox["=",
          "MR"], 
        RowBox[{
          StyleBox["Import",
            "MR"], 
          StyleBox["[",
            "MR"], 
          RowBox[{
            RowBox[{"workingDir", " ", "<>", 
              StyleBox["\"\<\\\\standardC.txt\>\"",
                "MR"]}], 
            StyleBox[",",
              "MR"], " ", Cell[BoxData[
                FormBox[
                  StyleBox["\"\<List\>\"",
                    "MR"], TraditionalForm]]]}], 
          StyleBox["]",
            "MR"]}]}], 
      StyleBox[";",
        "MR"]}], "\[IndentingNewLine]", \(n = 
      Length[c]\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{"A", "=", 
        RowBox[{"ReadList", "[", 
          RowBox[{
            RowBox[{"workingDir", " ", "<>", " ", 
              StyleBox["\"\<\\\\standardA.txt\>\"",
                "MR"]}], ",", \(Table[Number, {n}]\)}], "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["b",
          "MR"], 
        StyleBox["=",
          "MR"], 
        RowBox[{"ReadList", "[", 
          RowBox[{
            RowBox[{"workingDir", " ", "<>", " ", 
              StyleBox["\"\<\\\\standardB.txt\>\"",
                "MR"]}], ",", "Number"}], "]"}]}], 
      ";"}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["lb",
          "MR"], 
        StyleBox["=",
          "MR"], 
        RowBox[{
          RowBox[{
            StyleBox["Import",
              "MR"], 
            StyleBox["[",
              "MR"], 
            RowBox[{
              RowBox[{"workingDir", " ", "<>", 
                StyleBox["\"\<\\\\standardLB.txt\>\"",
                  "MR"]}], 
              StyleBox[",",
                "MR"], " ", Cell[BoxData[
                  FormBox[
                    StyleBox["\"\<List\>\"",
                      "MR"], TraditionalForm]]]}], 
            StyleBox["]",
              "MR"]}], "/.", 
          RowBox[{"{", 
            RowBox[{"\"\<NaN\>\"", "\[Rule]", 
              RowBox[{"-", 
                StyleBox["9999999",
                  "MR"]}]}], "}"}]}]}], 
      StyleBox[";",
        "MR"]}], "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        StyleBox["ub",
          "MR"], 
        StyleBox["=",
          "MR"], 
        RowBox[{
          RowBox[{
            StyleBox["Import",
              "MR"], 
            StyleBox["[",
              "MR"], 
            RowBox[{
              RowBox[{"workingDir", " ", "<>", 
                StyleBox["\"\<\\\\standardUB.txt\>\"",
                  "MR"]}], 
              StyleBox[",",
                "MR"], " ", Cell[BoxData[
                  FormBox[
                    StyleBox["\"\<List\>\"",
                      "MR"], TraditionalForm]]]}], 
            StyleBox["]",
              "MR"]}], "/.", 
          RowBox[{"{", 
            RowBox[{"\"\<NaN\>\"", "\[Rule]", 
              RowBox[{"+", 
                StyleBox["9999999",
                  "MR"]}]}], "}"}]}]}], 
      ";"}], "\[IndentingNewLine]", \(X = 
        Array[x, \ n, \ 0];\), "\[IndentingNewLine]", \(bCoeff\  = \ 
        Table[{b[\([i]\)], 0}, \ {i, 
            Length[b]}];\), "\[IndentingNewLine]", \(variablesBounds\  = \ 
        Table[{lb[\([i]\)], \ ub[\([i]\)]}, \ {i, n}];\)}], "Input"],

Cell[BoxData[
    \(1049\)], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"mySol", "=", 
        RowBox[{"LinearProgramming", "[", 
          RowBox[{
          "c", ",", "A", ",", "bCoeff", ",", " ", "variablesBounds", ",", " ",
             
            StyleBox[\(Method -> "\<InteriorPoint\>"\),
              "MR"]}], "]"}]}], ";"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Min[mySol]\), "\[IndentingNewLine]", 
    \(Max[mySol]\), "\[IndentingNewLine]", 
    \(myTolerance\  = Norm[A . mySol\  - \ b]\), "\[IndentingNewLine]", 
    \(Max[lb\  - mySol]\), "\[IndentingNewLine]", 
    \(Max[mySol\  - \ ub]\), "\[IndentingNewLine]", 
    \(myValue\  = \ c . mySol\)}], "Input"],

Cell[BoxData[
    \(2.3914072879685673`*^-7\)], "Output"],

Cell[BoxData[
    \(9.999998999990145`*^6\)], "Output"],

Cell[BoxData[
    \(0.000039118862688887924`\)], "Output"],

Cell[BoxData[
    \(\(-2.3914072879685673`*^-7\)\)], "Output"],

Cell[BoxData[
    \(\(-9.855255484580994`*^-6\)\)], "Output"],

Cell[BoxData[
    \(\(-5.577570446347351`*^10\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{"Export", "[", 
      RowBox[{
        RowBox[{"workingDir", " ", "<>", 
          StyleBox["\"\<\\\\standardSolution.txt\>\"",
            "MR"]}], 
        StyleBox[",",
          "MR"], " ", Cell[BoxData[
            FormBox[
              StyleBox["mySol",
                "MR"], TraditionalForm]]], ",", " ", "\"\<Lines\>\""}], 
      "]"}], "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
      RowBox[{
        RowBox[{"workingDir", " ", "<>", 
          StyleBox["\"\<\\\\standardValue.txt\>\"",
            "MR"]}], 
        StyleBox[",",
          "MR"], " ", Cell[BoxData[
            FormBox[
              StyleBox["myValue",
                "MR"], TraditionalForm]]], ",", " ", "\"\<Lines\>\""}], 
      "]"}], "\[IndentingNewLine]", 
    RowBox[{"Export", "[", 
      RowBox[{
        RowBox[{"workingDir", " ", "<>", 
          StyleBox["\"\<\\\\standardTolerance.txt\>\"",
            "MR"]}], 
        StyleBox[",",
          "MR"], " ", Cell[BoxData[
            FormBox[
              StyleBox["myTolerance",
                "MR"], TraditionalForm]]], ",", " ", "\"\<Lines\>\""}], 
      "]"}]}], "Input"],

Cell[BoxData[
    \("D:\\DATADIR\\Programmazione\\java\\joptimizer\\src\\test\\resources\\\
lp\\netlib\\fit1d\\standardSolution.txt"\)], "Output"],

Cell[BoxData[
    \("D:\\DATADIR\\Programmazione\\java\\joptimizer\\src\\test\\resources\\\
lp\\netlib\\fit1d\\standardValue.txt"\)], "Output"],

Cell[BoxData[
    \("D:\\DATADIR\\Programmazione\\java\\joptimizer\\src\\test\\resources\\\
lp\\netlib\\fit1d\\standardTolerance.txt"\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1920}, {0, 991}},
WindowSize->{1440, 875},
WindowMargins->{{-1444, Automatic}, {Automatic, -61}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 213, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[1992, 59, 3454, 109, 213, "Input"],
Cell[5449, 170, 38, 1, 29, "Output"]
}, Open  ]],
Cell[5502, 174, 315, 8, 30, "Input"],

Cell[CellGroupData[{
Cell[5842, 186, 323, 6, 130, "Input"],
Cell[6168, 194, 57, 1, 29, "Output"],
Cell[6228, 197, 55, 1, 29, "Output"],
Cell[6286, 200, 58, 1, 29, "Output"],
Cell[6347, 203, 62, 1, 29, "Output"],
Cell[6412, 206, 61, 1, 29, "Output"],
Cell[6476, 209, 61, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6574, 215, 1156, 33, 73, "Input"],
Cell[7733, 250, 146, 2, 29, "Output"],
Cell[7882, 254, 143, 2, 29, "Output"],
Cell[8028, 258, 147, 2, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

