(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     49313,        870]
NotebookOptionsPosition[     48166,        830]
NotebookOutlinePosition[     48587,        846]
CellTagsIndexPosition[     48544,        843]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"myRootDir", "=", 
   RowBox[{"NotebookDirectory", "[", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myProblemName", " ", "=", " ", 
   RowBox[{"ToString", "[", "\"\<degen2\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"myWorkingDir", " ", "=", " ", 
  RowBox[{"myRootDir", " ", "<>", " ", "myProblemName"}]}]}], "Input",
 CellChangeTimes->{{3.6254972010327253`*^9, 3.6254972183749356`*^9}, {
   3.6254979810338526`*^9, 3.6254979977442627`*^9}, 3.625498550542383*^9, {
   3.6254986388785286`*^9, 3.6254986449559464`*^9}, 3.625498685005808*^9, 
   3.625498764568181*^9, 3.6254990368006773`*^9, {3.625499067272133*^9, 
   3.625499067319131*^9}, 3.625499253615226*^9, 3.625499288545026*^9, 
   3.6254993300017304`*^9, 3.6254993642645144`*^9, 3.62549948679979*^9, 
   3.6256455996897316`*^9, 3.6256457715254345`*^9, 3.6256458335693445`*^9, 
   3.6256458698734093`*^9, 3.625650119598328*^9, {3.6256503232972865`*^9, 
   3.625650335090907*^9}, {3.625650401329626*^9, 3.6256504250560675`*^9}, {
   3.62565046016733*^9, 3.6256505023388033`*^9}, 3.625650553808095*^9, 
   3.6256506101273956`*^9, 3.6256514257330446`*^9, {3.6256634016271048`*^9, 
   3.6256634274131513`*^9}, 3.6256634734592323`*^9, 3.6256635572529826`*^9, {
   3.625663597248253*^9, 3.6256636416631317`*^9}, 3.6256637805347776`*^9, {
   3.6256638153240395`*^9, 3.6256638843577623`*^9}, {3.6256643218389387`*^9, 
   3.625664342774175*^9}, 3.6256643883830566`*^9, 3.6256644207301145`*^9, {
   3.6264239099315834`*^9, 3.626423911501583*^9}, {3.62652956395236*^9, 
   3.6265295647523603`*^9}, {3.6265324969677496`*^9, 
   3.6265324985084267`*^9}, {3.626532731155018*^9, 3.626532732955306*^9}, {
   3.6265336398684235`*^9, 3.6265336416084237`*^9}, {3.626533839857424*^9, 
   3.626533840697424*^9}, {3.6265339635494237`*^9, 3.6265339648094234`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\netlib\\\\degen2\"\>"], "Output",
 CellChangeTimes->{
  3.6254972653422995`*^9, {3.625497963886396*^9, 3.625497998489321*^9}, 
   3.625498554075736*^9, 3.625498586075756*^9, 3.6254986474651194`*^9, {
   3.6254986884700317`*^9, 3.6254987086944327`*^9}, 3.625498766864682*^9, 
   3.62549903916665*^9, 3.625499069750088*^9, 3.6254992575451956`*^9, 
   3.6254992908140078`*^9, 3.6254993325657144`*^9, 3.6254993669985075`*^9, 
   3.6256455764436903`*^9, 3.6256456379305987`*^9, 3.6256457738966384`*^9, 
   3.6256458362057486`*^9, 3.625645883242633*^9, 3.6256501272735415`*^9, 
   3.625650284179617*^9, {3.625650326089691*^9, 3.625650346588127*^9}, {
   3.62565040348243*^9, 3.625650428222873*^9}, {3.6256504619925327`*^9, 
   3.625650505443209*^9}, 3.6256505581761026`*^9, 3.625650613309801*^9, 
   3.62565116831399*^9, {3.6256514307718534`*^9, 3.6256514420974736`*^9}, {
   3.625663403873509*^9, 3.6256634297687554`*^9}, 3.625663475549636*^9, 
   3.6256635602949877`*^9, {3.625663599291857*^9, 3.6256636444243364`*^9}, 
   3.625663782827982*^9, {3.625663817476843*^9, 3.6256638863077655`*^9}, {
   3.625664324022942*^9, 3.6256643445369787`*^9}, 3.62566439027066*^9, 
   3.625664422867318*^9, 3.626423914322583*^9, 3.6265295664723597`*^9, 
   3.6265325003392324`*^9, 3.626532735905778*^9, 3.6265336434984236`*^9, 
   3.6265338426284237`*^9, 3.6265339653704233`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   StyleBox["c", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\standardC.txt\>\""}], "}"}],
       "]"}], ",", "\"\<List\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"n", " ", "=", " ", 
  RowBox[{"Length", "[", "c", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\standardA.csv\>\""}], "}"}],
       "]"}], ",", "\"\<CSV\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\standardB.txt\>\""}], "}"}],
       "]"}], ",", "\"\<List\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["lb", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\standardLB.txt\>\""}], 
        "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"-", 
       StyleBox["9999999", "MR"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["ub", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\standardUB.txt\>\""}], 
        "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"+", 
       StyleBox["9999999", "MR"]}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"variablesBounds", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lb", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       RowBox[{"ub", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6254975346931663`*^9, 3.625497780464336*^9}, {
   3.625497979543727*^9, 3.625497989174558*^9}, {3.625498026002859*^9, 
   3.6254980270029335`*^9}, 3.6256501318599496`*^9, {3.6256502209059057`*^9, 
   3.625650252027961*^9}, 3.6256503410657177`*^9, {3.625650711873975*^9, 
   3.6256507258203993`*^9}, 3.625650840083*^9, 3.625651161527978*^9, 
   3.6256514285098495`*^9, {3.6265337859714236`*^9, 3.626533803173424*^9}}],

Cell[BoxData["757"], "Output",
 CellChangeTimes->{
  3.6254979683807735`*^9, 3.625498076981874*^9, 3.6254985542247515`*^9, 
   3.6254985862417727`*^9, 3.625498647588132*^9, {3.6254986885840073`*^9, 
   3.6254987088174086`*^9}, 3.6254987669986553`*^9, 3.6254990393096495`*^9, 
   3.625499069885088*^9, 3.625499257674196*^9, 3.625499290949007*^9, 
   3.6254993327047143`*^9, 3.625499367136507*^9, 3.625645576864891*^9, 
   3.6256456380241985`*^9, 3.625645773974639*^9, 3.625645836299349*^9, 
   3.625645883539033*^9, 3.6256501338879533`*^9, {3.6256502222163086`*^9, 
   3.625650225086714*^9}, {3.6256502558187675`*^9, 3.625650284273217*^9}, {
   3.6256503263860917`*^9, 3.625650346712927*^9}, {3.62565040359163*^9, 
   3.6256504283476734`*^9}, {3.625650462117333*^9, 3.625650505552409*^9}, 
   3.625650558581703*^9, 3.6256506134034014`*^9, {3.625650712513576*^9, 
   3.625650726616001*^9}, 3.6256508408474016`*^9, {3.6256511626043797`*^9, 
   3.6256511783760076`*^9}, {3.6256514333614583`*^9, 
   3.6256514421910734`*^9}, {3.6256634040295095`*^9, 3.6256634298779554`*^9}, 
   3.6256634757368364`*^9, 3.625663560482188*^9, {3.6256635994010572`*^9, 
   3.6256636445179367`*^9}, 3.625663783015182*^9, {3.6256638175860434`*^9, 
   3.625663886448166*^9}, {3.625664324350543*^9, 3.6256643446461782`*^9}, 
   3.6256643904266605`*^9, 3.6256644229921184`*^9, 3.626423921987583*^9, 
   3.62652957150336*^9, 3.626532507264278*^9, 3.6265327409575863`*^9, 
   3.626533646600424*^9, {3.6265337877314234`*^9, 3.626533795232424*^9}, 
   3.6265338457884235`*^9, 3.6265339688604236`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{
   "c", ",", "A", ",", "bCoeff", ",", " ", "variablesBounds", ",", " ", 
    StyleBox[
     RowBox[{"Method", "->", "\"\<InteriorPoint\>\""}], "MR"]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}], "\[IndentingNewLine]", 
 RowBox[{"myTolerance", " ", "=", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6254978210834937`*^9, 3.6254978282840776`*^9}, 
   3.6254984866965537`*^9, 3.6264239253705835`*^9, {3.626533687836424*^9, 
   3.626533688626424*^9}, {3.6265337277624235`*^9, 3.626533730362424*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "2.26993748527111`*^-16", ",", "2.302491743710912`*^-16", ",", 
   "2.38329397273405`*^-16", ",", "7.554965139352732`*^-16", ",", 
   "7.55262013739151`*^-16", ",", "7.556552314391625`*^-16", ",", 
   "7.554021353120829`*^-16", ",", "7.55749932368755`*^-16", ",", 
   "7.551418514624822`*^-16", ",", "7.556194941638535`*^-16", ",", 
   "7.554648028705171`*^-16", ",", "7.554022180527623`*^-16", ",", 
   "2.122357895523501`*^-15", ",", "1.1255446662290174`*^-15", ",", 
   "1.3488742063290336`*^-15", ",", "1.3483918560571701`*^-15", ",", 
   "1.1240068635785765`*^-15", ",", "1.3499449917624422`*^-15", ",", 
   "1.34925414753626`*^-15", ",", "1.1243792491032147`*^-15", ",", 
   "6.745944891830775`*^-16", ",", "5.029739175771672`*^-16", ",", 
   "5.033350573931619`*^-16", ",", "5.035699839710016`*^-16", ",", 
   "1.0075515809283592`*^-15", ",", "1.0070518521831309`*^-15", ",", 
   "1.0068523036362218`*^-15", ",", "1.0067824890775539`*^-15", ",", 
   "1.0071944911889764`*^-15", ",", "1.0069672120255506`*^-15", ",", 
   "1.0071714281616132`*^-15", ",", "1.006982409686102`*^-15", ",", 
   "1.0072802325957744`*^-15", ",", "0.8000000083734894`", ",", 
   "1.0077866682623693`*^-15", ",", "1.008029950541351`*^-15", ",", 
   "1.0093078374428145`*^-15", ",", "1.006249863955516`*^-15", ",", 
   "8.426338290593533`*^-10", ",", "9.483857154810377`*^-10", ",", 
   "0.9999999989301901`", ",", "1.199999991614595`", ",", 
   "1.0075963579452105`*^-15", ",", "1.0062286741416578`*^-15", ",", 
   "1.0070846413907757`*^-15", ",", "1.0058698879562167`*^-15", ",", 
   "4.988462113888847`*^-11", ",", "0.9999999990124945`", ",", 
   "1.0022697319225935`*^-9", ",", "1.1666444225737446`*^-11", ",", 
   "1.0073570273010777`*^-15", ",", "1.005166823224986`*^-15", ",", 
   "1.0050659959659597`*^-15", ",", "1.0059963073206719`*^-15", ",", 
   "0.9999999991105342`", ",", "4.021594960173326`*^-11", ",", 
   "6.999313642582744`*^-11", ",", "8.908225588349977`*^-16", ",", 
   "1.0189512687647317`*^-15", ",", "1.0207750104322225`*^-15", ",", 
   "8.90543820214346`*^-16", ",", "1.0212877262854608`*^-15", ",", 
   "1.0201291786821957`*^-15", ",", "1.2799120928665095`*^-15", ",", 
   "1.0209394993190329`*^-15", ",", "1.020816818096857`*^-15", ",", 
   "1.3175108151591245`*^-15", ",", "1.3166823072116862`*^-15", ",", 
   "8.407000375541459`*^-16", ",", "1.5801247953331313`*^-15", ",", 
   "1.5805312219766143`*^-15", ",", "1.3169133413655416`*^-15", ",", 
   "1.318418043641409`*^-15", ",", "8.400836751575144`*^-16", ",", 
   "1.5802127195015448`*^-15", ",", "1.5805894074360987`*^-15", ",", 
   "1.3172077732192123`*^-15", ",", "1.3334748683736148`*^-15", ",", 
   "2.2731047906750035`*^-15", ",", "7.902466781026211`*^-16", ",", 
   "5.027129331405248`*^-16", ",", "5.029361830457945`*^-16", ",", 
   "7.238515790076381`*^-16", ",", "7.7289426488869`*^-16", ",", 
   "1.8000000093548152`", ",", "7.241749959521543`*^-16", ",", 
   "7.73152774571788`*^-16", ",", "0.19999999044260755`", ",", 
   "2.0400587945920612`*^-10", ",", "1.5618352687005893`*^-15", ",", 
   "1.5640618035649848`*^-15", ",", "1.5642263343803202`*^-15", ",", 
   "9.992687822518425`*^-16", ",", "2.4023732008634144`*^-15", ",", 
   "1.5631160580136285`*^-15", ",", "1.5654084219423679`*^-15", ",", 
   "1.5622544838265494`*^-15", ",", "1.8474363654294714`*^-15", ",", 
   "1.143743601619705`*^-15", ",", "1.5664122543801791`*^-15", ",", 
   "1.5625768223242446`*^-15", ",", "1.5645881800713753`*^-15", ",", 
   "1.8438965147958094`*^-15", ",", "1.1435968377210231`*^-15", ",", 
   "1.5047790266601642`*^-15", ",", "6.285183757601708`*^-11", ",", 
   "0.9999999998905282`", ",", "1.2566648984146579`*^-15", ",", 
   "1.614890605725567`*^-15", ",", "8.115426085656332`*^-16", ",", 
   "0.9999999999085577`", ",", "3.0000000011680337`", ",", 
   "4.000000001054581`", ",", "1.5117045592622514`*^-15", ",", 
   "1.0000000000683555`", ",", "1.255722842960039`*^-15", ",", 
   "1.6170274387482125`*^-15", ",", "8.11577025463583`*^-16", ",", 
   "4.376104392567629`*^-11", ",", "0.9999999990990187`", ",", 
   "2.5302516552010488`*^-11", ",", "1.2570858171829052`*^-15", ",", 
   "5.405056356895573`*^-16", ",", "4.547450796175116`*^-11", ",", 
   "7.560234104706875`*^-16", ",", "7.558205975863535`*^-16", ",", 
   "7.556835541754319`*^-16", ",", "7.561032138124204`*^-16", ",", 
   "7.558844692907501`*^-16", ",", "7.557302750887351`*^-16", ",", 
   "4.551360785411095`*^-16", ",", "1.2352135832416471`*^-15", ",", 
   "4.570509477374345`*^-16", ",", "5.641503030295417`*^-16", ",", 
   "1.4539446852482593`*^-15", ",", "4.999999999503649`", ",", 
   "0.9999999987998826`", ",", "2.1177689336079633`*^-15", ",", 
   "1.330194739309493`*^-15", ",", "4.31912414367762`*^-11", ",", 
   "2.9919683521458112`*^-15", ",", "1.576402244819166`*^-15", ",", 
   "1.6799587885407856`*^-15", ",", "1.6849049239784395`*^-15", ",", 
   "1.6823878815376774`*^-15", ",", "0.9999999999192544`", ",", 
   "1.999999999131`", ",", "1.0000000003606986`", ",", "1.0000000005213807`", 
   ",", "1.193819111157625`*^-9", ",", "8.854763859438429`*^-11", ",", 
   "2.122951030931274`*^-15", ",", "1.3288247292139483`*^-15", ",", 
   "1.0275083438793027`*^-15", ",", "1.6821259787086137`*^-15", ",", 
   "1.6861646545086033`*^-15", ",", "1.680083163684261`*^-15", ",", 
   "4.7812975501462717`*^-11", ",", "4.659032813648281`*^-11", ",", 
   "0.999999999921147`", ",", "0.9999999999733106`", ",", 
   "5.123315224590353`*^-12", ",", "3.982857416115471`*^-11", ",", 
   "8.163966640661475`*^-16", ",", "1.033473728925547`*^-15", ",", 
   "1.6992617989255166`*^-15", ",", "1.6817379911807386`*^-15", ",", 
   "1.6795747129867107`*^-15", ",", "2.4890497980053128`*^-11", ",", 
   "8.226522793115116`*^-10", ",", "5.04083537254743`*^-16", ",", 
   "5.040499454773303`*^-16", ",", "5.033723259308422`*^-16", ",", 
   "5.034946521354194`*^-16", ",", "1.0395320406514762`*^-15", ",", 
   "9.28660784967533`*^-16", ",", "9.584354883907923`*^-16", ",", 
   "1.038450705380769`*^-15", ",", "9.29174668687715`*^-16", ",", 
   "9.60060571444622`*^-16", ",", "6.721275088384455`*^-16", ",", 
   "8.063402138828361`*^-16", ",", "6.7150724320086805`*^-16", ",", 
   "8.065502656268608`*^-16", ",", "4.033105591918157`*^-16", ",", 
   "4.474358712005926`*^-16", ",", "4.474237163033258`*^-16", ",", 
   "6.620025028783543`*^-16", ",", "6.301096730268849`*^-16", ",", 
   "8.39763467152748`*^-16", ",", "1.258394748876346`*^-15", ",", 
   "1.2583952165237939`*^-15", ",", "8.394547870261882`*^-16", ",", 
   "6.299869710761202`*^-16", ",", "8.397233587794227`*^-16", ",", 
   "7.718391739054434`*^-16", ",", "7.721125230439407`*^-16", ",", 
   "0.9999999999339977`", ",", "7.720458408750711`*^-16", ",", 
   "7.718447278335673`*^-16", ",", "2.2791675372187225`*^-11", ",", 
   "4.608867665311026`*^-16", ",", "4.394283224847517`*^-11", ",", 
   "1.1376752578574041`*^-15", ",", "1.2746758118385188`*^-15", ",", 
   "0.19999999102290844`", ",", "1.187580145713413`*^-15", ",", 
   "1.3642717835671068`*^-15", ",", "1.3605653779045606`*^-15", ",", 
   "4.800000008711173`", ",", "4.800000008722558`", ",", 
   "1.1396586127086757`*^-15", ",", "1.2760443142354346`*^-15", ",", 
   "0.8000000089780784`", ",", "1.1881685387392338`*^-15", ",", 
   "1.3645377528063682`*^-15", ",", "1.360298399332488`*^-15", ",", 
   "2.19999999110189`", ",", "2.199999991088545`", ",", 
   "6.024718029330308`*^-16", ",", "4.330984907985735`*^-16", ",", 
   "6.505237947902769`*^-16", ",", "4.106869254291468`*^-16", ",", 
   "0.9999999999030624`", ",", "9.706091666462417`*^-11", ",", 
   "0.999999999916028`", ",", "8.38684900951561`*^-11", ",", 
   "0.19999994724352066`", ",", "0.8000000527560491`", ",", 
   "7.349696262999791`*^-11", ",", "0.999999999926532`", ",", 
   "0.8000000094357111`", ",", "0.19999999056460685`", ",", 
   "0.9999999999577794`", ",", "4.219823206090012`*^-11", ",", 
   "0.1999999461255894`", ",", "0.8000000538744438`", ",", 
   "1.180886992117779`*^-10", ",", "0.9999999998813797`", ",", 
   "0.9999999999609209`", ",", "3.9032571250614876`*^-11", ",", 
   "0.999999999961496`", ",", "3.8449030240946574`*^-11", ",", 
   "1.2030612658930361`*^-9", ",", "0.999999998796694`", ",", 
   "0.19999999127312335`", ",", "0.8000000087269518`", ",", 
   "6.793566172438374`*^-10", ",", "0.9999999993205845`", ",", 
   "0.8000000089145749`", ",", "0.19999999108551206`", ",", 
   "5.1970798075809175`*^-11", ",", "0.9999999999480261`", ",", 
   "1.7630385438913891`*^-10", ",", "0.9999999998237196`", ",", 
   "7.073318713317456`*^-11", ",", "0.9999999999292635`", ",", 
   "5.237160021816267`*^-10", ",", "0.9999999994762805`", ",", 
   "0.9999999996941465`", ",", "2.739792977065339`*^-10", ",", 
   "3.1987149816294696`*^-11", ",", "0.9999999999448561`", ",", 
   "2.3168662147016205`*^-11", ",", "3.1845405966589654`*^-11", ",", 
   "0.1999999461260834`", ",", "0.800000053873983`", ",", 
   "1.5992894810008438`*^-11", ",", "0.9999999999841417`", ",", 
   "6.130734032332444`*^-11", ",", "0.999999999938675`", ",", 
   "0.9999999555665732`", ",", "4.4433079140639`*^-8", ",", 
   "3.969528007441962`*^-11", ",", "0.9999999999603126`", ",", 
   "6.23376801595644`*^-11", ",", "0.9999999999376675`", ",", 
   "0.9999999999269122`", ",", "7.311212133292949`*^-11", ",", 
   "0.8000000093558036`", ",", "0.1999999906442554`", ",", 
   "9.935374041269135`*^-11", ",", "0.9999999999006144`", ",", 
   "2.65447870618394`*^-12", ",", "0.9999999999973253`", ",", 
   "0.8000000095812234`", ",", "0.19999999041862423`", ",", 
   "3.526719264539072`*^-11", ",", "0.9999999999647456`", ",", 
   "7.854518518018601`*^-10", ",", "0.9999999991295268`", ",", 
   "8.488087151951028`*^-11", ",", "1.2383276246117263`*^-9", ",", 
   "0.9999999987617957`", ",", "5.575812934384308`*^-11", ",", 
   "0.9999999999442263`", ",", "7.227180221125184`*^-11", ",", 
   "0.9999999999276854`", ",", "6.8722600163894`*^-11", ",", 
   "0.9999999999312736`", ",", "8.181812359765988`*^-11", ",", 
   "0.9999999999182152`", ",", "3.2245779465114396`*^-11", ",", 
   "0.9999999999677158`", ",", "4.192004453690861`*^-11", ",", 
   "0.9999999999580739`", ",", "0.8000000093683975`", ",", 
   "0.19999999063139828`", ",", "0.9999999999215426`", ",", 
   "7.840544809731268`*^-11", ",", "0.9999999999518279`", ",", 
   "4.8402742613641096`*^-11", ",", "0.9999999999516264`", ",", 
   "4.8156362483857`*^-11", ",", "1.003288299666001`*^-9", ",", 
   "0.9999999989967511`", ",", "0.9999999998598527`", ",", 
   "1.4032877143337597`*^-10", ",", "0.9999999999764067`", ",", 
   "2.3685067854700576`*^-11", ",", "0.9999999999216648`", ",", 
   "7.839723260995783`*^-11", ",", "1.5666953677272926`*^-10", ",", 
   "0.9999999998433322`", ",", "0.9999999999175749`", ",", 
   "8.244501602743823`*^-11", ",", "0.9999999999410877`", ",", 
   "5.881703929282474`*^-11", ",", "0.9999999999613092`", ",", 
   "3.864106460648441`*^-11", ",", "0.999999999911454`", ",", 
   "8.85477236935081`*^-11", ",", "0.9999999998301101`", ",", 
   "1.7022629393399195`*^-10", ",", "0.9999999999608409`", ",", 
   "3.909756103474658`*^-11", ",", "0.999999999916147`", ",", 
   "8.392339401042624`*^-11", ",", "1.566695367722528`*^-10", ",", 
   "0.9999999998433916`", ",", "0.999999999954796`", ",", 
   "4.533092002011274`*^-11", ",", "4.785281172011123`*^-11", ",", 
   "0.9999999999522037`", ",", "0.9999999998451282`", ",", 
   "4.3129997392175016`*^-11", ",", "1.1202008000015855`*^-10", ",", 
   "0.9999999999860332`", ",", "1.4190389116308693`*^-11", ",", 
   "5.391223624570843`*^-16", ",", "0.99999999991448`", ",", 
   "3.136423995616775`*^-11", ",", "5.4066656662804763`*^-11", ",", 
   "0.9999999997634195`", ",", "1.9609204016872446`*^-11", ",", 
   "2.1704023849572588`*^-10", ",", "0.9999999998087722`", ",", 
   "9.647259721132081`*^-11", ",", "9.490450558753177`*^-11", ",", 
   "0.999999999908942`", ",", "4.565815625853646`*^-11", ",", 
   "4.564425157101365`*^-11", ",", "0.9999999997741457`", ",", 
   "7.180319417134697`*^-11", ",", "1.5369803838094776`*^-10", ",", 
   "0.9999999999312948`", ",", "3.400084992671505`*^-11", ",", 
   "3.469464139906475`*^-11", ",", "4.961481411521519`*^-11", ",", 
   "0.9999999999503684`", ",", "7.72255670264425`*^-16", ",", 
   "4.769057791390588`*^-11", ",", "1.7702757263784908`*^-10", ",", 
   "0.9999999997752848`", ",", "6.13073876453082`*^-11", ",", 
   "0.9999999999386873`", ",", "7.764040286945833`*^-16", ",", 
   "1.061404488584481`*^-10", ",", "3.2319327001968513`*^-10", ",", 
   "0.999999999570637`", ",", "4.55627629974704`*^-11", ",", 
   "1.791559078018943`*^-10", ",", "0.9999999997752843`", ",", 
   "1.3385336970355548`*^-15", ",", "1.3352062477744598`*^-15", ",", 
   "1.0000000000004634`", ",", "5.613281193785732`*^-11", ",", 
   "1.2658800808826411`*^-10", ",", "0.9999999998172823`", ",", 
   "9.464034514656956`*^-11", ",", "1.0519971401480771`*^-10", ",", 
   "0.9999999998001622`", ",", "0.800000008233499`", ",", 
   "0.199999990314715`", ",", "1.4512836745638028`*^-9", ",", 
   "0.8000000496460451`", ",", "6.471320964102643`*^-10", ",", 
   "0.19999994970678162`", ",", "5.61326026744237`*^-11", ",", 
   "1.265884258606897`*^-10", ",", "0.9999999998172818`", ",", 
   "1.3883591233862577`*^-15", ",", "1.3898873952463327`*^-15", ",", 
   "1.000000000000007`", ",", "6.406213235483355`*^-11", ",", 
   "0.9999999998884181`", ",", "4.754021218315662`*^-11", ",", 
   "0.8000000496468618`", ",", "6.471320941190402`*^-10", ",", 
   "0.19999994970680274`", ",", "0.9999999999412681`", ",", 
   "5.863143239227932`*^-11", ",", "2.468935657610162`*^-15", ",", 
   "6.995541933194113`*^-11", ",", "8.597285816430079`*^-10", ",", 
   "0.9999999990703247`", ",", "0.9999999999414806`", ",", 
   "5.881700840506687`*^-11", ",", "9.277259531572072`*^-16", ",", 
   "0.9999999997748894`", ",", "7.180319452066865`*^-11", ",", 
   "1.5305925699793935`*^-10", ",", "1.2321067782633826`*^-10", ",", 
   "1.3962458930603306`*^-10", ",", "0.9999999997371729`", ",", 
   "5.873505207037664`*^-11", ",", "8.670891096024724`*^-10", ",", 
   "0.9999999990741606`", ",", "0.9999999997890493`", ",", 
   "9.876189720640093`*^-11", ",", "1.1204954380982997`*^-10", ",", 
   "1.984958564514856`*^-10", ",", "8.385339832161237`*^-10", ",", 
   "0.9999999989631633`", ",", "1.1065063194710948`*^-10", ",", 
   "7.597812256885021`*^-11", ",", "0.9999999998133751`", ",", 
   "1.7756598207128106`*^-10", ",", "0.9999999998224304`", ",", 
   "1.1865655267600385`*^-15", ",", "4.2471160481963026`*^-10", ",", 
   "1.3414554928354478`*^-10", ",", "0.9999999994411595`", ",", 
   "0.9999999993064024`", ",", "4.747737533093933`*^-10", ",", 
   "2.1873887573207724`*^-10", ",", "0.9999999999349625`", ",", 
   "6.523764868015201`*^-11", ",", "2.4663462013745833`*^-15", ",", 
   "1.2599536885291211`*^-15", ",", "1.2618652735949585`*^-15", ",", 
   "1.0000000000000024`", ",", "1.1777262020617984`*^-9", ",", 
   "0.9999999988222994`", ",", "0.9999999989602264`", ",", 
   "4.048640832261675`*^-11", ",", "9.994977678360524`*^-10", ",", 
   "4.324492713077245`*^-11", ",", "2.1472399834432551`*^-10", ",", 
   "0.9999999997420331`", ",", "0.8000000066255966`", ",", 
   "0.19999999162170704`", ",", "1.752736023125903`*^-9", ",", 
   "7.854518512686529`*^-10", ",", "0.9999999991296873`", ",", 
   "8.488117536041933`*^-11", ",", "5.873505140787776`*^-11", ",", 
   "8.670891108306702`*^-10", ",", "0.9999999990741931`", ",", 
   "1.2321067786477238`*^-10", ",", "1.3962458960455923`*^-10", ",", 
   "0.9999999997372016`", ",", "0.9999999998442763`", ",", 
   "7.206154121242808`*^-11", ",", "8.354900900715757`*^-11", ",", 
   "0.9999999998442807`", ",", "7.20615410887348`*^-11", ",", 
   "8.367771620517043`*^-11", ",", "8.892491674441519`*^-10", ",", 
   "4.697661859049666`*^-11", ",", "0.9999999990637769`", ",", 
   "0.9999999988871042`", ",", "6.849893377598097`*^-11", ",", 
   "1.0442739558267626`*^-9", ",", "4.2471176942026065`*^-10", ",", 
   "1.3414212488005795`*^-10", ",", "0.9999999994411359`", ",", 
   "4.24711769409461`*^-10", ",", "1.341694392570166`*^-10", ",", 
   "0.9999999994411327`", ",", "1.8119306092204013`*^-9", ",", 
   "3.437774404468934`*^-11", ",", "0.9999999981536818`", ",", 
   "0.8000000066255587`", ",", "0.199999991621685`", ",", 
   "1.7527360580482244`*^-9", ",", "0.9999999989599999`", ",", 
   "4.0486407438671696`*^-11", ",", "9.994977698214976`*^-10", ",", 
   "0.9999999998801065`", ",", "6.739133862125854`*^-11", ",", 
   "5.210456950449415`*^-11", ",", "6.635729411161734`*^-11", ",", 
   "0.19999999045424852`", ",", "0.8000000094794806`", ",", 
   "0.9999999997831812`", ",", "1.3239907184566108`*^-10", ",", 
   "8.435670027248207`*^-11", ",", "8.104208037901222`*^-11", ",", 
   "0.9999999915295408`", ",", "8.388570451480881`*^-9", ",", 
   "0.9999999999171337`", ",", "8.309183599314404`*^-11", ",", 
   "2.907749516833574`*^-15", ",", "2.179376043515679`*^-10", ",", 
   "3.1011734744400296`*^-10", ",", "0.9999999994719593`", ",", 
   "4.3881540384806295`*^-10", ",", "2.0287458303242952`*^-10", ",", 
   "0.9999999993580307`", ",", "1.9847628488290123`*^-10", ",", 
   "8.384941116367613`*^-10", ",", "0.9999999989631028`", ",", 
   "8.109288382588473`*^-10", ",", "1.174158101571531`*^-10", ",", 
   "0.9999999990715721`", ",", "9.536845458499366`*^-11", ",", 
   "1.0519982329208995`*^-10", ",", "0.9999999997994345`", ",", 
   "0.9999999998347169`", ",", "7.043339371211955`*^-11", ",", 
   "9.490495537883507`*^-11", ",", "5.3961335355629284`*^-11", ",", 
   "0.9999999999460555`", ",", "1.5008006490519632`*^-9", ",", 
   "1.540806568324814`*^-10", ",", "0.9999999983451535`", ",", 
   "0.9999999999999535`", ",", "2.1899057759840694`*^-15", ",", 
   "2.185020469637979`*^-15", ",", "0.8000000083136226`", ",", 
   "0.19999999158717485`", ",", "9.924429383717676`*^-11", ",", 
   "2.6884677669372775`*^-9", ",", "6.675536919942642`*^-9", ",", 
   "0.999999990635942`", ",", "9.063363120960354`*^-10", ",", 
   "4.6725925114173513`*^-11", ",", "0.9999999990469403`", ",", 
   "0.8000000082338667`", ",", "0.19999999031471513`", ",", 
   "1.4512226889526595`*^-9", ",", "9.063361979763453`*^-10", ",", 
   "4.6727733592725735`*^-11", ",", "0.9999999990469385`", ",", 
   "9.315634755787724`*^-11", ",", "2.4724372078233925`*^-10", ",", 
   "0.9999999996596205`", ",", "0.9999999999544682`", ",", 
   "4.533083591184543`*^-11", ",", "1.037601626055726`*^-15", ",", 
   "5.670242795021738`*^-11", ",", "7.495036431552408`*^-11", ",", 
   "0.9999999998684854`", ",", "0.9999999997836574`", ",", 
   "1.3181216981390352`*^-10", ",", "8.43937150889166`*^-11", ",", 
   "1.9815112745360808`*^-10", ",", "8.384941104934786`*^-10", ",", 
   "0.9999999989633648`", ",", "0.8000000083134196`", ",", 
   "0.19999999158716905`", ",", "9.924455359319727`*^-11", ",", 
   "0.9999999998440775`", ",", "7.206112215129482`*^-11", ",", 
   "8.367714061017799`*^-11", ",", "1.0000000000000027`", ",", 
   "1.4867751367089466`*^-15", ",", "1.4858435097210468`*^-15", ",", 
   "0.9999999991513984`", ",", "5.1668916631281556`*^-11", ",", 
   "7.968223617982318`*^-10", ",", "9.812780209110456`*^-16", ",", 
   "1.0000000000000868`", ",", "9.938459122844285`*^-16", ",", 
   "6.635716703113192`*^-11", ",", "0.1999999904542484`", ",", 
   "0.8000000094794842`", ",", "4.2471176962397207`*^-10", ",", 
   "1.341421244625766`*^-10", ",", "0.9999999994411481`", ",", 
   "0.9999999993058475`", ",", "6.179476092627842`*^-10", ",", 
   "7.614871729242204`*^-11", ",", "1.0720024657827347`*^-9", ",", 
   "3.48989904924961`*^-11", ",", "0.9999999988931145`", ",", 
   "1.8009304898789787`*^-10", ",", "0.99999995558962`", ",", 
   "4.42302999152346`*^-8", ",", "0.9999999556596773`", ",", 
   "8.045432006660983`*^-11", ",", "4.425974010374863`*^-8", ",", 
   "1.1697797248559047`*^-10", ",", "0.999999955598159`", ",", 
   "4.42849875194112`*^-8", ",", "1.1440901998804352`*^-10", ",", 
   "0.9999999556098592`", ",", "4.427573895013424`*^-8", ",", 
   "0.9999999999350528`", ",", "6.523769597868354`*^-11", ",", 
   "2.370470015575217`*^-15", ",", "7.087731181369097`*^-11", ",", 
   "0.9999999914530093`", ",", "8.476164643129606`*^-9", ",", 
   "0.9999999998791538`", ",", "6.739138296131575`*^-11", ",", 
   "5.338168928944519`*^-11", ",", "8.889492947466099`*^-10", ",", 
   "4.6974927680382215`*^-11", ",", "0.9999999990641085`", ",", 
   "0.9999999998009913`", ",", "1.1755754786859565`*^-10", ",", 
   "8.155481777972188`*^-11", ",", "0.8000000097408729`", ",", 
   "0.19999998990904358`", ",", "3.5005918137360537`*^-10", ",", 
   "0.9999999997665179`", ",", "1.1748458377223106`*^-10", ",", 
   "1.1587122760633683`*^-10", ",", "8.104208068121769`*^-11", ",", 
   "0.9999999915321737`", ",", "8.388570451548644`*^-9", ",", 
   "0.9999999991501868`", ",", "5.16689160265265`*^-11", ",", 
   "7.983289584719141`*^-10", ",", "3.220427379717524`*^-11", ",", 
   "1.1664091324066021`*^-9", ",", "0.9999999988013873`", ",", 
   "0.19999999041212527`", ",", "1.092339213807507`*^-10", ",", 
   "0.8000000094786687`", ",", "1.0704696562250145`*^-9", ",", 
   "7.258384961110327`*^-11", ",", "0.9999999988569553`", ",", 
   "9.34529306729543`*^-10", ",", "2.5654392416486277`*^-10", ",", 
   "0.9999999988089092`", ",", "7.834306483620966`*^-10", ",", 
   "2.4478888795497353`*^-10", ",", "0.9999999989717834`", ",", 
   "1.1777259619618392`*^-9", ",", "0.999999998822326`", ",", 
   "1.1102468591991776`*^-15", ",", "0.9999999999999967`", ",", 
   "0.9999999998302183`", ",", "1.7022615754575264`*^-10", ",", 
   "1.1393295525659606`*^-15", ",", "1.1818190817826677`*^-10", ",", 
   "0.9999999998343959`", ",", "4.716573888879989`*^-11", ",", 
   "2.843106349430401`*^-9", ",", "7.4160513942337156`*^-9", ",", 
   "0.9999999897408614`", ",", "1.181820422236659`*^-10", ",", 
   "0.9999999998346772`", ",", "4.716547087636543`*^-11", ",", 
   "2.8431062153696496`*^-9", ",", "7.416051259601217`*^-9", ",", 
   "0.9999999897408173`", ",", "0.9999999998008228`", ",", 
   "1.1755704906201032`*^-10", ",", "8.155431885476369`*^-11", ",", 
   "0.999999999999987`", ",", "1.5757096405622628`*^-15", ",", 
   "1.5752346215243137`*^-15", ",", "0.9999999999167377`", ",", 
   "8.309207058132753`*^-11", ",", "2.4384172423347265`*^-15", ",", 
   "0.9999999999088794`", ",", "4.543116661938765`*^-11", ",", 
   "4.5644250992437206`*^-11", ",", "1.8527006552946324`*^-9", ",", 
   "0.9999999980817471`", ",", "6.554367264284472`*^-11", ",", 
   "0.9999999997878342`", ",", "9.328066546734162`*^-11", ",", 
   "1.1864420734811505`*^-10", ",", "0.9999999998048512`", ",", 
   "1.0818302017708463`*^-10", ",", "8.691573730901602`*^-11", ",", 
   "9.31806002179663`*^-11", ",", "2.47243721045343`*^-10", ",", 
   "0.9999999996595408`", ",", "0.9999999999489619`", ",", 
   "1.9704924965604344`*^-11", ",", "3.158483681664097`*^-11", ",", 
   "8.83680244668793`*^-16", ",", "6.252093654338355`*^-16", ",", 
   "6.25454438877316`*^-16", ",", "5.03276229415886`*^-16", ",", 
   "5.0314595672829035`*^-16", ",", "5.037002134775882`*^-16", ",", 
   "1.0068886969057423`*^-15", ",", "1.0080183197829596`*^-15", ",", 
   "1.006488882614829`*^-15", ",", "0.9999999998707908`", ",", 
   "2.3766608102924758`*^-11", ",", "1.0520284901789434`*^-10", ",", 
   "1.1249554973990625`*^-15", ",", "1.1251287678372041`*^-15", ",", 
   "8.113621722743659`*^-16", ",", "1.800000007813102`", ",", 
   "0.1999999905843474`", ",", "1.3177853677801838`*^-15", ",", 
   "5.035585673362685`*^-16", ",", "5.035520309679928`*^-16", ",", 
   "7.711742677980158`*^-16", ",", "7.70782835298967`*^-16", ",", 
   "2.5200131765425417`*^-16", ",", "1.563061563192103`*^-15", ",", 
   "1.563999796551669`*^-15", ",", "1.564455942296681`*^-15", ",", 
   "1.5088753046401763`*^-15", ",", "1.5080145519609794`*^-15", ",", 
   "7.526508019549227`*^-16", ",", "7.560579855059409`*^-16", ",", 
   "7.559793993808761`*^-16", ",", "7.557394764776462`*^-16", ",", 
   "5.692496090184602`*^-16", ",", "9.91591387573675`*^-16", ",", 
   "6.626486927335688`*^-16", ",", "3.999999999788795`", ",", 
   "1.0000000004085905`", ",", "1.9999999998025375`", ",", 
   "0.9999999997633668`", ",", "5.031113796139782`*^-16", ",", 
   "5.037695402715172`*^-16", ",", "1.1231024796266313`*^-15", ",", 
   "1.1225588272726058`*^-15", ",", "8.063193754036437`*^-16", ",", 
   "8.061145925836322`*^-16", ",", "6.713228367007505`*^-16", ",", 
   "5.745169593028602`*^-16", ",", "5.7509005560416375`*^-16", ",", 
   "4.0689683283663036`*^-16", ",", "8.393725363732739`*^-16", ",", 
   "8.406237154272644`*^-16", ",", "8.395313151307358`*^-16", ",", 
   "7.246479330578868`*^-16", ",", "7.247463511267218`*^-16", ",", 
   "5.554609101133794`*^-16", ",", "1.9999999989279535`", ",", 
   "1.9063484521571812`*^-11", ",", "1.0531405779391904`*^-9", ",", 
   "4.1042741085256805`*^-16", ",", "6.511120145968843`*^-16"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.6254980878117514`*^9, 3.625498498343467*^9, 3.6254985546977987`*^9, 
   3.6254985923443193`*^9, 3.6254986479231606`*^9, {3.625498688882948*^9, 
   3.6254987091963325`*^9}, 3.625498768903267*^9, 3.6254990414126415`*^9, 
   3.6254990719290786`*^9, 3.625499259419192*^9, 3.625499291504006*^9, 
   3.625499332996714*^9, 3.6254993771324964`*^9, 3.6256455772044926`*^9, 
   3.6256456383985996`*^9, 3.6256457743122396`*^9, 3.625645837027351*^9, 
   3.625645883929034*^9, {3.6256502776120057`*^9, 3.625650284522818*^9}, {
   3.6256503267220926`*^9, 3.625650347102928*^9}, 3.625650404387232*^9, {
   3.625650436038487*^9, 3.6256505082036147`*^9}, 3.625650559376505*^9, 
   3.625650613807802*^9, 3.6256514425810747`*^9, {3.62566340435711*^9, 
   3.6256634300339556`*^9}, 3.625663478342041*^9, 3.62566356137139*^9, {
   3.6256635995726576`*^9, 3.625663644658337*^9}, 3.6256637834519825`*^9, {
   3.625663817788844*^9, 3.6256638909565735`*^9}, {3.625664324537743*^9, 
   3.6256643452389793`*^9}, 3.6256643905982604`*^9, 3.6256644232729187`*^9, 
   3.6264239259715834`*^9, 3.6265295745643597`*^9, 3.6265325123385096`*^9, 
   3.6265327468595304`*^9, 3.6265336500304236`*^9, 3.6265337008564234`*^9, {
   3.626533791152424*^9, 3.6265337995734234`*^9}, 3.6265338534294233`*^9, 
   3.6265339722504234`*^9}],

Cell[BoxData[
 RowBox[{"-", "1435.177999973811`"}]], "Output",
 CellChangeTimes->{
  3.6254980878117514`*^9, 3.625498498343467*^9, 3.6254985546977987`*^9, 
   3.6254985923443193`*^9, 3.6254986479231606`*^9, {3.625498688882948*^9, 
   3.6254987091963325`*^9}, 3.625498768903267*^9, 3.6254990414126415`*^9, 
   3.6254990719290786`*^9, 3.625499259419192*^9, 3.625499291504006*^9, 
   3.625499332996714*^9, 3.6254993771324964`*^9, 3.6256455772044926`*^9, 
   3.6256456383985996`*^9, 3.6256457743122396`*^9, 3.625645837027351*^9, 
   3.625645883929034*^9, {3.6256502776120057`*^9, 3.625650284522818*^9}, {
   3.6256503267220926`*^9, 3.625650347102928*^9}, 3.625650404387232*^9, {
   3.625650436038487*^9, 3.6256505082036147`*^9}, 3.625650559376505*^9, 
   3.625650613807802*^9, 3.6256514425810747`*^9, {3.62566340435711*^9, 
   3.6256634300339556`*^9}, 3.625663478342041*^9, 3.62566356137139*^9, {
   3.6256635995726576`*^9, 3.625663644658337*^9}, 3.6256637834519825`*^9, {
   3.625663817788844*^9, 3.6256638909565735`*^9}, {3.625664324537743*^9, 
   3.6256643452389793`*^9}, 3.6256643905982604`*^9, 3.6256644232729187`*^9, 
   3.6264239259715834`*^9, 3.6265295745643597`*^9, 3.6265325123385096`*^9, 
   3.6265327468595304`*^9, 3.6265336500304236`*^9, 3.6265337008564234`*^9, {
   3.626533791152424*^9, 3.6265337995734234`*^9}, 3.6265338534294233`*^9, 
   3.6265339722804236`*^9}],

Cell[BoxData["2.7181455143045636`*^-11"], "Output",
 CellChangeTimes->{
  3.6254980878117514`*^9, 3.625498498343467*^9, 3.6254985546977987`*^9, 
   3.6254985923443193`*^9, 3.6254986479231606`*^9, {3.625498688882948*^9, 
   3.6254987091963325`*^9}, 3.625498768903267*^9, 3.6254990414126415`*^9, 
   3.6254990719290786`*^9, 3.625499259419192*^9, 3.625499291504006*^9, 
   3.625499332996714*^9, 3.6254993771324964`*^9, 3.6256455772044926`*^9, 
   3.6256456383985996`*^9, 3.6256457743122396`*^9, 3.625645837027351*^9, 
   3.625645883929034*^9, {3.6256502776120057`*^9, 3.625650284522818*^9}, {
   3.6256503267220926`*^9, 3.625650347102928*^9}, 3.625650404387232*^9, {
   3.625650436038487*^9, 3.6256505082036147`*^9}, 3.625650559376505*^9, 
   3.625650613807802*^9, 3.6256514425810747`*^9, {3.62566340435711*^9, 
   3.6256634300339556`*^9}, 3.625663478342041*^9, 3.62566356137139*^9, {
   3.6256635995726576`*^9, 3.625663644658337*^9}, 3.6256637834519825`*^9, {
   3.625663817788844*^9, 3.6256638909565735`*^9}, {3.625664324537743*^9, 
   3.6256643452389793`*^9}, 3.6256643905982604`*^9, 3.6256644232729187`*^9, 
   3.6264239259715834`*^9, 3.6265295745643597`*^9, 3.6265325123385096`*^9, 
   3.6265327468595304`*^9, 3.6265336500304236`*^9, 3.6265337008564234`*^9, {
   3.626533791152424*^9, 3.6265337995734234`*^9}, 3.6265338534294233`*^9, 
   3.6265339722804236`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Min", "[", "mySol", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", "mySol", "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"lb", " ", "-", "mySol"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Max", "[", 
  RowBox[{"mySol", " ", "-", " ", "ub"}], "]"}]}], "Input",
 CellChangeTimes->{{3.625497824812781*^9, 3.625497830941289*^9}}],

Cell[BoxData["2.26993748527111`*^-16"], "Output",
 CellChangeTimes->{
  3.625498097797538*^9, {3.6254985660209026`*^9, 3.6254985924763327`*^9}, 
   3.6254986479611645`*^9, {3.6254986889789257`*^9, 3.6254987092613196`*^9}, 
   3.6254987689512577`*^9, 3.6254990414836416`*^9, 3.625499071985079*^9, 
   3.625499259482192*^9, 3.6254992915490055`*^9, 3.6254993330267143`*^9, 
   3.6256455772644925`*^9, 3.6256456384609995`*^9, 3.625645782567054*^9, 
   3.625645883944634*^9, 3.625650284554018*^9, {3.625650326752093*^9, 
   3.625650347149728*^9}, 3.6256504044340315`*^9, {3.6256504362256875`*^9, 
   3.6256504835113707`*^9}, 3.625650559706506*^9, 3.625650614087803*^9, 
   3.6256514426278744`*^9, {3.62566340438831*^9, 3.625663430065156*^9}, 
   3.6256634784512415`*^9, 3.62566356141819*^9, {3.6256635996038575`*^9, 
   3.6256636447051373`*^9}, 3.625663783483183*^9, {3.625663817820044*^9, 
   3.625663891112574*^9}, {3.625664324584543*^9, 3.62566434528578*^9}, 
   3.6256643906450605`*^9, 3.625664423304119*^9, 3.626423964830583*^9, 
   3.62652958175436*^9, 3.626532524736964*^9, 3.62653275692214*^9, 
   3.6265337168804235`*^9, 3.6265338945564237`*^9, 3.626533977131424*^9}],

Cell[BoxData["4.999999999503649`"], "Output",
 CellChangeTimes->{
  3.625498097797538*^9, {3.6254985660209026`*^9, 3.6254985924763327`*^9}, 
   3.6254986479611645`*^9, {3.6254986889789257`*^9, 3.6254987092613196`*^9}, 
   3.6254987689512577`*^9, 3.6254990414836416`*^9, 3.625499071985079*^9, 
   3.625499259482192*^9, 3.6254992915490055`*^9, 3.6254993330267143`*^9, 
   3.6256455772644925`*^9, 3.6256456384609995`*^9, 3.625645782567054*^9, 
   3.625645883944634*^9, 3.625650284554018*^9, {3.625650326752093*^9, 
   3.625650347149728*^9}, 3.6256504044340315`*^9, {3.6256504362256875`*^9, 
   3.6256504835113707`*^9}, 3.625650559706506*^9, 3.625650614087803*^9, 
   3.6256514426278744`*^9, {3.62566340438831*^9, 3.625663430065156*^9}, 
   3.6256634784512415`*^9, 3.62566356141819*^9, {3.6256635996038575`*^9, 
   3.6256636447051373`*^9}, 3.625663783483183*^9, {3.625663817820044*^9, 
   3.625663891112574*^9}, {3.625664324584543*^9, 3.62566434528578*^9}, 
   3.6256643906450605`*^9, 3.625664423304119*^9, 3.626423964830583*^9, 
   3.62652958175436*^9, 3.626532524736964*^9, 3.62653275692214*^9, 
   3.6265337168804235`*^9, 3.6265338945564237`*^9, 3.626533977131424*^9}],

Cell[BoxData[
 RowBox[{"-", "2.26993748527111`*^-16"}]], "Output",
 CellChangeTimes->{
  3.625498097797538*^9, {3.6254985660209026`*^9, 3.6254985924763327`*^9}, 
   3.6254986479611645`*^9, {3.6254986889789257`*^9, 3.6254987092613196`*^9}, 
   3.6254987689512577`*^9, 3.6254990414836416`*^9, 3.625499071985079*^9, 
   3.625499259482192*^9, 3.6254992915490055`*^9, 3.6254993330267143`*^9, 
   3.6256455772644925`*^9, 3.6256456384609995`*^9, 3.625645782567054*^9, 
   3.625645883944634*^9, 3.625650284554018*^9, {3.625650326752093*^9, 
   3.625650347149728*^9}, 3.6256504044340315`*^9, {3.6256504362256875`*^9, 
   3.6256504835113707`*^9}, 3.625650559706506*^9, 3.625650614087803*^9, 
   3.6256514426278744`*^9, {3.62566340438831*^9, 3.625663430065156*^9}, 
   3.6256634784512415`*^9, 3.62566356141819*^9, {3.6256635996038575`*^9, 
   3.6256636447051373`*^9}, 3.625663783483183*^9, {3.625663817820044*^9, 
   3.625663891112574*^9}, {3.625664324584543*^9, 3.62566434528578*^9}, 
   3.6256643906450605`*^9, 3.625664423304119*^9, 3.626423964830583*^9, 
   3.62652958175436*^9, 3.626532524736964*^9, 3.62653275692214*^9, 
   3.6265337168804235`*^9, 3.6265338945564237`*^9, 3.626533977131424*^9}],

Cell[BoxData[
 RowBox[{"-", "9.999994`*^6"}]], "Output",
 CellChangeTimes->{
  3.625498097797538*^9, {3.6254985660209026`*^9, 3.6254985924763327`*^9}, 
   3.6254986479611645`*^9, {3.6254986889789257`*^9, 3.6254987092613196`*^9}, 
   3.6254987689512577`*^9, 3.6254990414836416`*^9, 3.625499071985079*^9, 
   3.625499259482192*^9, 3.6254992915490055`*^9, 3.6254993330267143`*^9, 
   3.6256455772644925`*^9, 3.6256456384609995`*^9, 3.625645782567054*^9, 
   3.625645883944634*^9, 3.625650284554018*^9, {3.625650326752093*^9, 
   3.625650347149728*^9}, 3.6256504044340315`*^9, {3.6256504362256875`*^9, 
   3.6256504835113707`*^9}, 3.625650559706506*^9, 3.625650614087803*^9, 
   3.6256514426278744`*^9, {3.62566340438831*^9, 3.625663430065156*^9}, 
   3.6256634784512415`*^9, 3.62566356141819*^9, {3.6256635996038575`*^9, 
   3.6256636447051373`*^9}, 3.625663783483183*^9, {3.625663817820044*^9, 
   3.625663891112574*^9}, {3.625664324584543*^9, 3.62566434528578*^9}, 
   3.6256643906450605`*^9, 3.625664423304119*^9, 3.626423964830583*^9, 
   3.62652958175436*^9, 3.626532524736964*^9, 3.62653275692214*^9, 
   3.6265337168804235`*^9, 3.6265338945564237`*^9, 3.626533977131424*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\standardValue.txt\>\""}], 
    "]"}], ",", "myValue", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\standardSolution.txt\>\""}], 
    "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{"myWorkingDir", ",", " ", "\"\<\\\\StandardTolerance.txt\>\""}], 
    "]"}], ",", "myTolerance", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6254978710246153`*^9, 3.6254979329908257`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\netlib\\\\degen2\\\\standardValue.txt\"\>"],\
 "Output",
 CellChangeTimes->{
  3.6254981010437717`*^9, {3.625498566335934*^9, 3.6254985925173364`*^9}, 
   3.6254986479991684`*^9, {3.6254986890389137`*^9, 3.6254987093003116`*^9}, 
   3.6254987689912496`*^9, 3.625499041519642*^9, 3.6254990720780783`*^9, 
   3.625499259518192*^9, 3.625499291583006*^9, 3.625499333064714*^9, 
   3.6256455774144926`*^9, 3.6256456384922*^9, 3.625645783518656*^9, 
   3.625645883975834*^9, 3.6256502846008177`*^9, {3.625650326912093*^9, 
   3.625650347180928*^9}, 3.625650404465232*^9, {3.6256504362568874`*^9, 
   3.625650483542571*^9}, 3.6256505601665063`*^9, 3.625650614547804*^9, 
   3.6256514426590743`*^9, {3.62566340441951*^9, 3.625663430096356*^9}, 
   3.6256634784668417`*^9, 3.62566356144939*^9, {3.6256635996350574`*^9, 
   3.625663644736337*^9}, 3.625663783545583*^9, {3.625663817851244*^9, 
   3.625663891143774*^9}, {3.625664324615743*^9, 3.6256643453169794`*^9}, 
   3.6256643906606607`*^9, 3.6256644233353186`*^9, 3.626532539945653*^9, 
   3.6265327596435757`*^9, 3.6265337208714237`*^9, 3.6265338986774235`*^9, 
   3.6265339835824237`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\netlib\\\\degen2\\\\standardSolution.txt\"\>\
"], "Output",
 CellChangeTimes->{
  3.6254981010437717`*^9, {3.625498566335934*^9, 3.6254985925173364`*^9}, 
   3.6254986479991684`*^9, {3.6254986890389137`*^9, 3.6254987093003116`*^9}, 
   3.6254987689912496`*^9, 3.625499041519642*^9, 3.6254990720780783`*^9, 
   3.625499259518192*^9, 3.625499291583006*^9, 3.625499333064714*^9, 
   3.6256455774144926`*^9, 3.6256456384922*^9, 3.625645783518656*^9, 
   3.625645883975834*^9, 3.6256502846008177`*^9, {3.625650326912093*^9, 
   3.625650347180928*^9}, 3.625650404465232*^9, {3.6256504362568874`*^9, 
   3.625650483542571*^9}, 3.6256505601665063`*^9, 3.625650614547804*^9, 
   3.6256514426590743`*^9, {3.62566340441951*^9, 3.625663430096356*^9}, 
   3.6256634784668417`*^9, 3.62566356144939*^9, {3.6256635996350574`*^9, 
   3.625663644736337*^9}, 3.625663783545583*^9, {3.625663817851244*^9, 
   3.625663891143774*^9}, {3.625664324615743*^9, 3.6256643453169794`*^9}, 
   3.6256643906606607`*^9, 3.6256644233353186`*^9, 3.626532539945653*^9, 
   3.6265327596435757`*^9, 3.6265337208714237`*^9, 3.6265338986774235`*^9, 
   3.6265339835924234`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\netlib\\\\degen2\\\\StandardTolerance.txt\"\
\>"], "Output",
 CellChangeTimes->{
  3.6254981010437717`*^9, {3.625498566335934*^9, 3.6254985925173364`*^9}, 
   3.6254986479991684`*^9, {3.6254986890389137`*^9, 3.6254987093003116`*^9}, 
   3.6254987689912496`*^9, 3.625499041519642*^9, 3.6254990720780783`*^9, 
   3.625499259518192*^9, 3.625499291583006*^9, 3.625499333064714*^9, 
   3.6256455774144926`*^9, 3.6256456384922*^9, 3.625645783518656*^9, 
   3.625645883975834*^9, 3.6256502846008177`*^9, {3.625650326912093*^9, 
   3.625650347180928*^9}, 3.625650404465232*^9, {3.6256504362568874`*^9, 
   3.625650483542571*^9}, 3.6256505601665063`*^9, 3.625650614547804*^9, 
   3.6256514426590743`*^9, {3.62566340441951*^9, 3.625663430096356*^9}, 
   3.6256634784668417`*^9, 3.62566356144939*^9, {3.6256635996350574`*^9, 
   3.625663644736337*^9}, 3.625663783545583*^9, {3.625663817851244*^9, 
   3.625663891143774*^9}, {3.625664324615743*^9, 3.6256643453169794`*^9}, 
   3.6256643906606607`*^9, 3.6256644233353186`*^9, 3.626532539945653*^9, 
   3.6265327596435757`*^9, 3.6265337208714237`*^9, 3.6265338986774235`*^9, 
   3.6265339836024237`*^9}]
}, Open  ]]
},
WindowSize->{1274, 877},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 1863, 29, 83, "Input"],
Cell[2445, 53, 1471, 20, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3953, 78, 3125, 89, 198, "Input"],
Cell[7081, 169, 1567, 22, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8685, 196, 735, 16, 83, "Input"],
Cell[9423, 214, 26276, 400, 1987, "Output"],
Cell[35702, 616, 1375, 20, 36, "Output"],
Cell[37080, 638, 1364, 19, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[38481, 662, 374, 7, 106, "Input"],
Cell[38858, 671, 1171, 16, 38, "Output"],
Cell[40032, 689, 1167, 16, 36, "Output"],
Cell[41202, 707, 1188, 17, 38, "Output"],
Cell[42393, 726, 1178, 17, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43608, 748, 788, 19, 83, "Input"],
Cell[44399, 769, 1246, 18, 36, "Output"],
Cell[45648, 789, 1249, 18, 36, "Output"],
Cell[46900, 809, 1250, 18, 93, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
