(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     33035,        867]
NotebookOptionsPosition[     31815,        824]
NotebookOutlinePosition[     32236,        840]
CellTagsIndexPosition[     32193,        837]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the LP problem defined by:
min(1.x) s.t.
G.x < h
A.x = b
lb <= x <= ub\
\>", "Subtitle",
 CellChangeTimes->{{3.6254016461603594`*^9, 3.625401648776232*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   StyleBox["c", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"Table", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"i", ",", "27"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "c", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "0.0", ",", "0.0", ",", "708422.9929", ",", "1129808.981", ",", 
       "1384181.99", ",", "1670073.038", ",", "1778967.017", ",", 
       "1561124.98", ",", "1004844.003", ",", "346745.9999", ",", 
       "448728.0097", ",", "392109.0064", ",", "408071.9612", ",", 
       "368765.9962", ",", "359735.9895", ",", "381570.0135", ",", 
       "360117.0017", ",", "328766.991", ",", "335106.0027", ",", 
       "325110.0012", ",", "298709.9965", ",", "330431.996", ",", 
       "332652.0015", ",", "288843.0063", ",", "290288.9975", ",", 
       "306455.9965", ",", "0.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0", ",", "0.0", ",", "0.0", ",", "497462.9918", ",", "1285664.99", 
       ",", "1651515.038", ",", "1731852.017", ",", "2095799.973", ",", 
       "2339112.006", ",", "2481407.999", ",", "1966449.042", ",", 
       "1803585.03", ",", "1502177.857", ",", "964109.9901", ",", 
       "744218.9784", ",", "721641.0255", ",", "681018.0032", ",", 
       "622466.9829", ",", "634356.0052", ",", "615228.0023", ",", 
       "565301.9934", ",", "625373.9924", ",", "629601.0029", ",", 
       "546498.0119", ",", "549053.9953", ",", "579569.9934", ",", "0.0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
       "726915.0168", ",", "1525716.015", ",", "2040350.974", ",", 
       "2282712.006", ",", "2407808.999", ",", "2113074.046", ",", 
       "2412375.039", ",", "2514434.761", ",", "2862548.971", ",", 
       "2969933.914", ",", "2546949.09", ",", "2388045.011", ",", 
       "1029968.972", ",", "1049418.009", ",", "1017375.004", ",", 
       "934883.989", ",", "1034303.987", ",", "1041339.005", ",", 
       "903519.0198", ",", "907388.9923", ",", "957698.9891", ",", "0.0"}], 
      "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
       "0.0", ",", "563981.9927", ",", "1364079.003", ",", "2173557.0", ",", 
       "1877850.041", ",", "2206839.036", ",", "2300567.781", ",", 
       "2669330.973", ",", "2781461.919", ",", "2794467.099", ",", 
       "3055377.014", ",", "2895827.92", ",", "2437734.02", ",", 
       "1971567.007", ",", "1369160.984", ",", "1416872.983", ",", 
       "1426575.007", ",", "1237233.027", ",", "1242026.989", ",", 
       "1310717.985", ",", "0.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0", ",", "0.0", ",", 
       RowBox[{"-", "708422.9929"}], ",", 
       RowBox[{"-", "1129808.981"}], ",", 
       RowBox[{"-", "1384181.99"}], ",", 
       RowBox[{"-", "1670073.038"}], ",", 
       RowBox[{"-", "1778967.017"}], ",", 
       RowBox[{"-", "1561124.98"}], ",", 
       RowBox[{"-", "1004844.003"}], ",", 
       RowBox[{"-", "346745.9999"}], ",", 
       RowBox[{"-", "448728.0097"}], ",", 
       RowBox[{"-", "392109.0064"}], ",", 
       RowBox[{"-", "408071.9612"}], ",", 
       RowBox[{"-", "368765.9962"}], ",", 
       RowBox[{"-", "359735.9895"}], ",", 
       RowBox[{"-", "381570.0135"}], ",", 
       RowBox[{"-", "360117.0017"}], ",", 
       RowBox[{"-", "328766.991"}], ",", 
       RowBox[{"-", "335106.0027"}], ",", 
       RowBox[{"-", "325110.0012"}], ",", 
       RowBox[{"-", "298709.9965"}], ",", 
       RowBox[{"-", "330431.996"}], ",", 
       RowBox[{"-", "332652.0015"}], ",", 
       RowBox[{"-", "288843.0063"}], ",", 
       RowBox[{"-", "290288.9975"}], ",", 
       RowBox[{"-", "306455.9965"}], ",", "0.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0", ",", "0.0", ",", "0.0", ",", 
       RowBox[{"-", "497462.9918"}], ",", 
       RowBox[{"-", "1285664.99"}], ",", 
       RowBox[{"-", "1651515.038"}], ",", 
       RowBox[{"-", "1731852.017"}], ",", 
       RowBox[{"-", "2095799.973"}], ",", 
       RowBox[{"-", "2339112.006"}], ",", 
       RowBox[{"-", "2481407.999"}], ",", 
       RowBox[{"-", "1966449.042"}], ",", 
       RowBox[{"-", "1803585.03"}], ",", 
       RowBox[{"-", "1502177.857"}], ",", 
       RowBox[{"-", "964109.9901"}], ",", 
       RowBox[{"-", "744218.9784"}], ",", 
       RowBox[{"-", "721641.0255"}], ",", 
       RowBox[{"-", "681018.0032"}], ",", 
       RowBox[{"-", "622466.9829"}], ",", 
       RowBox[{"-", "634356.0052"}], ",", 
       RowBox[{"-", "615228.0023"}], ",", 
       RowBox[{"-", "565301.9934"}], ",", 
       RowBox[{"-", "625373.9924"}], ",", 
       RowBox[{"-", "629601.0029"}], ",", 
       RowBox[{"-", "546498.0119"}], ",", 
       RowBox[{"-", "549053.9953"}], ",", 
       RowBox[{"-", "579569.9934"}], ",", "0.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
       RowBox[{"-", "726915.0168"}], ",", 
       RowBox[{"-", "1525716.015"}], ",", 
       RowBox[{"-", "2040350.974"}], ",", 
       RowBox[{"-", "2282712.006"}], ",", 
       RowBox[{"-", "2407808.999"}], ",", 
       RowBox[{"-", "2113074.046"}], ",", 
       RowBox[{"-", "2412375.039"}], ",", 
       RowBox[{"-", "2514434.761"}], ",", 
       RowBox[{"-", "2862548.971"}], ",", 
       RowBox[{"-", "2969933.914"}], ",", 
       RowBox[{"-", "2546949.09"}], ",", 
       RowBox[{"-", "2388045.011"}], ",", 
       RowBox[{"-", "1029968.972"}], ",", 
       RowBox[{"-", "1049418.009"}], ",", 
       RowBox[{"-", "1017375.004"}], ",", 
       RowBox[{"-", "934883.989"}], ",", 
       RowBox[{"-", "1034303.987"}], ",", 
       RowBox[{"-", "1041339.005"}], ",", 
       RowBox[{"-", "903519.0198"}], ",", 
       RowBox[{"-", "907388.9923"}], ",", 
       RowBox[{"-", "957698.9891"}], ",", "0.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
       "0.0", ",", 
       RowBox[{"-", "563981.9927"}], ",", 
       RowBox[{"-", "1364079.003"}], ",", 
       RowBox[{"-", "2173557.0"}], ",", 
       RowBox[{"-", "1877850.041"}], ",", 
       RowBox[{"-", "2206839.036"}], ",", 
       RowBox[{"-", "2300567.781"}], ",", 
       RowBox[{"-", "2669330.973"}], ",", 
       RowBox[{"-", "2781461.919"}], ",", 
       RowBox[{"-", "2794467.099"}], ",", 
       RowBox[{"-", "3055377.014"}], ",", 
       RowBox[{"-", "2895827.92"}], ",", 
       RowBox[{"-", "2437734.02"}], ",", 
       RowBox[{"-", "1971567.007"}], ",", 
       RowBox[{"-", "1369160.984"}], ",", 
       RowBox[{"-", "1416872.983"}], ",", 
       RowBox[{"-", "1426575.007"}], ",", 
       RowBox[{"-", "1237233.027"}], ",", 
       RowBox[{"-", "1242026.989"}], ",", 
       RowBox[{"-", "1310717.985"}], ",", "0.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
      "0.004758", ",", "0.013221", ",", "0.02778", ",", "0.049119", ",", 
       "0.073587", ",", "0.104913", ",", "0.126321", ",", "0.171927", ",", 
       "0.213459", ",", "0.247881", ",", "0.236697", ",", "0.28887", ",", 
       "0.319587", ",", "0.398007", ",", "0.42492", ",", "0.452211", ",", 
       "0.511728", ",", "0.789264", ",", "0.826413", ",", "0.899157", ",", 
       "1.021041", ",", "0.985626", ",", "1.027917", ",", "1.235742", ",", 
       "1.293093", ",", "1.285083", ",", "0.0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.004758"}], ",", 
       RowBox[{"-", "0.013221"}], ",", 
       RowBox[{"-", "0.02778"}], ",", 
       RowBox[{"-", "0.049119"}], ",", 
       RowBox[{"-", "0.073587"}], ",", 
       RowBox[{"-", "0.104913"}], ",", 
       RowBox[{"-", "0.126321"}], ",", 
       RowBox[{"-", "0.171927"}], ",", 
       RowBox[{"-", "0.213459"}], ",", 
       RowBox[{"-", "0.247881"}], ",", 
       RowBox[{"-", "0.236697"}], ",", 
       RowBox[{"-", "0.28887"}], ",", 
       RowBox[{"-", "0.319587"}], ",", 
       RowBox[{"-", "0.398007"}], ",", 
       RowBox[{"-", "0.42492"}], ",", 
       RowBox[{"-", "0.452211"}], ",", 
       RowBox[{"-", "0.511728"}], ",", 
       RowBox[{"-", "0.789264"}], ",", 
       RowBox[{"-", "0.826413"}], ",", 
       RowBox[{"-", "0.899157"}], ",", 
       RowBox[{"-", "1.021041"}], ",", 
       RowBox[{"-", "0.985626"}], ",", 
       RowBox[{"-", "1.027917"}], ",", 
       RowBox[{"-", "1.235742"}], ",", 
       RowBox[{"-", "1.293093"}], ",", 
       RowBox[{"-", "1.285083"}], ",", "0.0"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["h", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"{", 
    RowBox[{
    "1260660.85", ",", "2121914.72", ",", "2842225.57", ",", "2116769.48", 
     ",", 
     RowBox[{"-", "260660.85"}], ",", 
     RowBox[{"-", "1121914.72"}], ",", 
     RowBox[{"-", "1842225.57"}], ",", 
     RowBox[{"-", "1116769.48"}], ",", "10002.07", ",", "9997.93"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "h", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"A", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
      "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
      "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
      "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
      "1.0", ",", "1.0", ",", "1.0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
     "310116.0012", ",", "558891.0038", ",", "838802.9916", ",", 
      "1136465.981", ",", "1397297.99", ",", "1681386.039", ",", 
      "1807671.018", ",", "2142965.972", ",", "2387088.006", ",", 
      "2543996.999", ",", "2371542.051", ",", "2638245.043", ",", 
      "2749556.738", ",", "3075098.969", ",", "3177302.908", ",", 
      "3214443.114", ",", "3451632.016", ",", "4233212.883", ",", 
      "4301634.035", ",", "4485147.017", ",", "4813043.944", ",", 
      "4645718.944", ",", "4720185.022", ",", "5258010.115", ",", 
      "5354744.954", ",", "5276186.94", ",", "0.0"}], "}"}]}], 
   "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["b", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"{", 
    RowBox[{"1.0", ",", "2758954.3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GA", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"G", ",", " ", "A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hbCoeff", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"hCoeff", ",", " ", "bCoeff"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["lb", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"{", 
    RowBox[{
    "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
     "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
     "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
     "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", "0.0", ",", 
     "0.0", ",", "0.0", ",", "0.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["ub", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"{", 
    RowBox[{
    "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
     "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
     "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
     "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", "1.0", ",", 
     "1.0", ",", "1.0", ",", "1.0"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"variablesBounds", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lb", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       RowBox[{"ub", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.611924840809389*^9, 3.61192485082139*^9}, 
   3.6119249629436016`*^9, {3.611925075074814*^9, 3.611925075530859*^9}, {
   3.611925106200926*^9, 3.6119252047789845`*^9}, {3.6119252437969847`*^9, 
   3.6119252929149847`*^9}, 3.611925366181985*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
     "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
     "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
     "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", "1.`", ",", 
     "1.`", ",", "1.`", ",", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "310116.0012`", ",", "558891.0038`", ",", "838802.9916`", ",", 
     "1.136465981`*^6", ",", "1.39729799`*^6", ",", "1.681386039`*^6", ",", 
     "1.807671018`*^6", ",", "2.142965972`*^6", ",", "2.387088006`*^6", ",", 
     "2.543996999`*^6", ",", "2.371542051`*^6", ",", "2.638245043`*^6", ",", 
     "2.749556738`*^6", ",", "3.075098969`*^6", ",", "3.177302908`*^6", ",", 
     "3.214443114`*^6", ",", "3.451632016`*^6", ",", "4.233212883`*^6", ",", 
     "4.301634035`*^6", ",", "4.485147017`*^6", ",", "4.813043944`*^6", ",", 
     "4.645718944`*^6", ",", "4.720185022`*^6", ",", "5.258010115`*^6", ",", 
     "5.354744954`*^6", ",", "5.27618694`*^6", ",", "0.`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.611926702655565*^9, 3.625401695245967*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{"n", "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "G", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "h", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "A", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "b", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "lb", "]"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", "ub", "]"}]}], "Input",
 CellChangeTimes->{{3.6119253839759846`*^9, 3.611925418030985*^9}}],

Cell[BoxData["27"], "Output",
 CellChangeTimes->{{3.6119253918899846`*^9, 3.6119254184499846`*^9}, 
   3.6119267027155704`*^9, 3.6254016952959647`*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0.`", "0.`", "708422.9929`", "1.129808981`*^6", "1.38418199`*^6", 
      "1.670073038`*^6", "1.778967017`*^6", "1.56112498`*^6", 
      "1.004844003`*^6", "346745.9999`", "448728.0097`", "392109.0064`", 
      "408071.9612`", "368765.9962`", "359735.9895`", "381570.0135`", 
      "360117.0017`", "328766.991`", "335106.0027`", "325110.0012`", 
      "298709.9965`", "330431.996`", "332652.0015`", "288843.0063`", 
      "290288.9975`", "306455.9965`", "0.`"},
     {"0.`", "0.`", "0.`", "497462.9918`", "1.28566499`*^6", 
      "1.651515038`*^6", "1.731852017`*^6", "2.095799973`*^6", 
      "2.339112006`*^6", "2.481407999`*^6", "1.966449042`*^6", 
      "1.80358503`*^6", "1.502177857`*^6", "964109.9901`", "744218.9784`", 
      "721641.0255`", "681018.0032`", "622466.9829`", "634356.0052`", 
      "615228.0023`", "565301.9934`", "625373.9924`", "629601.0029`", 
      "546498.0119`", "549053.9953`", "579569.9934`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "726915.0168`", "1.525716015`*^6", 
      "2.040350974`*^6", "2.282712006`*^6", "2.407808999`*^6", 
      "2.113074046`*^6", "2.412375039`*^6", "2.514434761`*^6", 
      "2.862548971`*^6", "2.969933914`*^6", "2.54694909`*^6", 
      "2.388045011`*^6", "1.029968972`*^6", "1.049418009`*^6", 
      "1.017375004`*^6", "934883.989`", "1.034303987`*^6", "1.041339005`*^6", 
      "903519.0198`", "907388.9923`", "957698.9891`", "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "563981.9927`", 
      "1.364079003`*^6", "2.173557`*^6", "1.877850041`*^6", "2.206839036`*^6",
       "2.300567781`*^6", "2.669330973`*^6", "2.781461919`*^6", 
      "2.794467099`*^6", "3.055377014`*^6", "2.89582792`*^6", 
      "2.43773402`*^6", "1.971567007`*^6", "1.369160984`*^6", 
      "1.416872983`*^6", "1.426575007`*^6", "1.237233027`*^6", 
      "1.242026989`*^6", "1.310717985`*^6", "0.`"},
     {"0.`", "0.`", 
      RowBox[{"-", "708422.9929`"}], 
      RowBox[{"-", "1.129808981`*^6"}], 
      RowBox[{"-", "1.38418199`*^6"}], 
      RowBox[{"-", "1.670073038`*^6"}], 
      RowBox[{"-", "1.778967017`*^6"}], 
      RowBox[{"-", "1.56112498`*^6"}], 
      RowBox[{"-", "1.004844003`*^6"}], 
      RowBox[{"-", "346745.9999`"}], 
      RowBox[{"-", "448728.0097`"}], 
      RowBox[{"-", "392109.0064`"}], 
      RowBox[{"-", "408071.9612`"}], 
      RowBox[{"-", "368765.9962`"}], 
      RowBox[{"-", "359735.9895`"}], 
      RowBox[{"-", "381570.0135`"}], 
      RowBox[{"-", "360117.0017`"}], 
      RowBox[{"-", "328766.991`"}], 
      RowBox[{"-", "335106.0027`"}], 
      RowBox[{"-", "325110.0012`"}], 
      RowBox[{"-", "298709.9965`"}], 
      RowBox[{"-", "330431.996`"}], 
      RowBox[{"-", "332652.0015`"}], 
      RowBox[{"-", "288843.0063`"}], 
      RowBox[{"-", "290288.9975`"}], 
      RowBox[{"-", "306455.9965`"}], "0.`"},
     {"0.`", "0.`", "0.`", 
      RowBox[{"-", "497462.9918`"}], 
      RowBox[{"-", "1.28566499`*^6"}], 
      RowBox[{"-", "1.651515038`*^6"}], 
      RowBox[{"-", "1.731852017`*^6"}], 
      RowBox[{"-", "2.095799973`*^6"}], 
      RowBox[{"-", "2.339112006`*^6"}], 
      RowBox[{"-", "2.481407999`*^6"}], 
      RowBox[{"-", "1.966449042`*^6"}], 
      RowBox[{"-", "1.80358503`*^6"}], 
      RowBox[{"-", "1.502177857`*^6"}], 
      RowBox[{"-", "964109.9901`"}], 
      RowBox[{"-", "744218.9784`"}], 
      RowBox[{"-", "721641.0255`"}], 
      RowBox[{"-", "681018.0032`"}], 
      RowBox[{"-", "622466.9829`"}], 
      RowBox[{"-", "634356.0052`"}], 
      RowBox[{"-", "615228.0023`"}], 
      RowBox[{"-", "565301.9934`"}], 
      RowBox[{"-", "625373.9924`"}], 
      RowBox[{"-", "629601.0029`"}], 
      RowBox[{"-", "546498.0119`"}], 
      RowBox[{"-", "549053.9953`"}], 
      RowBox[{"-", "579569.9934`"}], "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", 
      RowBox[{"-", "726915.0168`"}], 
      RowBox[{"-", "1.525716015`*^6"}], 
      RowBox[{"-", "2.040350974`*^6"}], 
      RowBox[{"-", "2.282712006`*^6"}], 
      RowBox[{"-", "2.407808999`*^6"}], 
      RowBox[{"-", "2.113074046`*^6"}], 
      RowBox[{"-", "2.412375039`*^6"}], 
      RowBox[{"-", "2.514434761`*^6"}], 
      RowBox[{"-", "2.862548971`*^6"}], 
      RowBox[{"-", "2.969933914`*^6"}], 
      RowBox[{"-", "2.54694909`*^6"}], 
      RowBox[{"-", "2.388045011`*^6"}], 
      RowBox[{"-", "1.029968972`*^6"}], 
      RowBox[{"-", "1.049418009`*^6"}], 
      RowBox[{"-", "1.017375004`*^6"}], 
      RowBox[{"-", "934883.989`"}], 
      RowBox[{"-", "1.034303987`*^6"}], 
      RowBox[{"-", "1.041339005`*^6"}], 
      RowBox[{"-", "903519.0198`"}], 
      RowBox[{"-", "907388.9923`"}], 
      RowBox[{"-", "957698.9891`"}], "0.`"},
     {"0.`", "0.`", "0.`", "0.`", "0.`", "0.`", "0.`", 
      RowBox[{"-", "563981.9927`"}], 
      RowBox[{"-", "1.364079003`*^6"}], 
      RowBox[{"-", "2.173557`*^6"}], 
      RowBox[{"-", "1.877850041`*^6"}], 
      RowBox[{"-", "2.206839036`*^6"}], 
      RowBox[{"-", "2.300567781`*^6"}], 
      RowBox[{"-", "2.669330973`*^6"}], 
      RowBox[{"-", "2.781461919`*^6"}], 
      RowBox[{"-", "2.794467099`*^6"}], 
      RowBox[{"-", "3.055377014`*^6"}], 
      RowBox[{"-", "2.89582792`*^6"}], 
      RowBox[{"-", "2.43773402`*^6"}], 
      RowBox[{"-", "1.971567007`*^6"}], 
      RowBox[{"-", "1.369160984`*^6"}], 
      RowBox[{"-", "1.416872983`*^6"}], 
      RowBox[{"-", "1.426575007`*^6"}], 
      RowBox[{"-", "1.237233027`*^6"}], 
      RowBox[{"-", "1.242026989`*^6"}], 
      RowBox[{"-", "1.310717985`*^6"}], "0.`"},
     {"0.004758`", "0.013221`", "0.02778`", "0.049119`", "0.073587`", 
      "0.104913`", "0.126321`", "0.171927`", "0.213459`", "0.247881`", 
      "0.236697`", "0.28887`", "0.319587`", "0.398007`", "0.42492`", 
      "0.452211`", "0.511728`", "0.789264`", "0.826413`", "0.899157`", 
      "1.021041`", "0.985626`", "1.027917`", "1.235742`", "1.293093`", 
      "1.285083`", "0.`"},
     {
      RowBox[{"-", "0.004758`"}], 
      RowBox[{"-", "0.013221`"}], 
      RowBox[{"-", "0.02778`"}], 
      RowBox[{"-", "0.049119`"}], 
      RowBox[{"-", "0.073587`"}], 
      RowBox[{"-", "0.104913`"}], 
      RowBox[{"-", "0.126321`"}], 
      RowBox[{"-", "0.171927`"}], 
      RowBox[{"-", "0.213459`"}], 
      RowBox[{"-", "0.247881`"}], 
      RowBox[{"-", "0.236697`"}], 
      RowBox[{"-", "0.28887`"}], 
      RowBox[{"-", "0.319587`"}], 
      RowBox[{"-", "0.398007`"}], 
      RowBox[{"-", "0.42492`"}], 
      RowBox[{"-", "0.452211`"}], 
      RowBox[{"-", "0.511728`"}], 
      RowBox[{"-", "0.789264`"}], 
      RowBox[{"-", "0.826413`"}], 
      RowBox[{"-", "0.899157`"}], 
      RowBox[{"-", "1.021041`"}], 
      RowBox[{"-", "0.985626`"}], 
      RowBox[{"-", "1.027917`"}], 
      RowBox[{"-", "1.235742`"}], 
      RowBox[{"-", "1.293093`"}], 
      RowBox[{"-", "1.285083`"}], "0.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6119253918899846`*^9, 3.6119254184499846`*^9}, 
   3.6119267027155704`*^9, 3.6254016953159637`*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"1.26066085`*^6"},
      {"2.12191472`*^6"},
      {"2.84222557`*^6"},
      {"2.11676948`*^6"},
      {
       RowBox[{"-", "260660.85`"}]},
      {
       RowBox[{"-", "1.12191472`*^6"}]},
      {
       RowBox[{"-", "1.84222557`*^6"}]},
      {
       RowBox[{"-", "1.11676948`*^6"}]},
      {"10002.07`"},
      {"9997.93`"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6119253918899846`*^9, 3.6119254184499846`*^9}, 
   3.6119267027155704`*^9, 3.625401695325963*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", 
      "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", 
      "1.`", "1.`", "1.`", "1.`", "1.`", "1.`", "1.`"},
     {"310116.0012`", "558891.0038`", "838802.9916`", "1.136465981`*^6", 
      "1.39729799`*^6", "1.681386039`*^6", "1.807671018`*^6", 
      "2.142965972`*^6", "2.387088006`*^6", "2.543996999`*^6", 
      "2.371542051`*^6", "2.638245043`*^6", "2.749556738`*^6", 
      "3.075098969`*^6", "3.177302908`*^6", "3.214443114`*^6", 
      "3.451632016`*^6", "4.233212883`*^6", "4.301634035`*^6", 
      "4.485147017`*^6", "4.813043944`*^6", "4.645718944`*^6", 
      "4.720185022`*^6", "5.258010115`*^6", "5.354744954`*^6", 
      "5.27618694`*^6", "0.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6119253918899846`*^9, 3.6119254184499846`*^9}, 
   3.6119267027155704`*^9, 3.625401695325963*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"1.`"},
      {"2.7589543`*^6"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6119253918899846`*^9, 3.6119254184499846`*^9}, 
   3.6119267027155704`*^9, 3.625401695325963*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"},
      {"0.`"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6119253918899846`*^9, 3.6119254184499846`*^9}, 
   3.6119267027155704`*^9, 3.625401695325963*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", 
   TagBox[GridBox[{
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"},
      {"1.`"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}],
    Column], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6119253918899846`*^9, 3.6119254184499846`*^9}, 
   3.6119267027155704`*^9, 3.6254016953359623`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{
   "c", ",", "GA", ",", "hbCoeff", ",", " ", "variablesBounds", ",", " ", 
    StyleBox[
     RowBox[{"Method", "->", "\"\<InteriorPoint\>\""}], "MR"]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}]}], "Input",
 CellChangeTimes->{{3.6119261075260572`*^9, 3.6119261088231874`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.008056802222459093`", ",", "0.007821549652810723`", ",", 
   "0.009287090593132012`", ",", "0.012595576917586665`", ",", 
   "0.01851846844028819`", ",", "0.03776184875025691`", ",", 
   "0.06449118266982193`", ",", "0.08696399142294287`", ",", 
   "0.091293844566163`", ",", "0.08689981190030051`", ",", 
   "0.06681634661790854`", ",", "0.07166445428208915`", ",", 
   "0.06855804560702546`", ",", "0.06724857263736311`", ",", 
   "0.06579606717957524`", ",", "0.05115495945739355`", ",", 
   "0.044127504788937`", ",", "0.015951127837103438`", ",", 
   "0.01637460452256654`", ",", "0.015692877923664694`", ",", 
   "0.01392734979107911`", ",", "0.0158544010743056`", ",", 
   "0.015838786551602545`", ",", "0.012754012909222772`", ",", 
   "0.012662176192945292`", ",", "0.01352971229979526`", ",", 
   "0.008358833191660316`"}], "}"}]], "Output",
 CellChangeTimes->{3.6119254487239847`*^9, 3.6119267028115807`*^9, 
  3.625401695405959*^9}],

Cell[BoxData["0.9999999999999996`"], "Output",
 CellChangeTimes->{3.6119254487239847`*^9, 3.6119267028115807`*^9, 
  3.625401695405959*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"G", ".", "mySol"}], "-", "h"}]], "Input",
 CellChangeTimes->{{3.6119261115754623`*^9, 3.6119261153118362`*^9}, {
  3.611926168483153*^9, 3.6119261711774225`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "566850.7376532247`"}], ",", 
   RowBox[{"-", "682453.2880797144`"}], ",", 
   RowBox[{"-", "879812.7151676025`"}], ",", 
   RowBox[{"-", "442253.2769695553`"}], ",", 
   RowBox[{"-", "433149.2623467754`"}], ",", 
   RowBox[{"-", "317546.71192028583`"}], ",", 
   RowBox[{"-", "120187.28483239724`"}], ",", 
   RowBox[{"-", "557746.7230304447`"}], ",", 
   RowBox[{"-", "10001.704785110607`"}], ",", 
   RowBox[{"-", "9998.295214889393`"}]}], "}"}]], "Output",
 CellChangeTimes->{3.611926117243029*^9, 3.611926172774582*^9, 
  3.611926702830582*^9, 3.6254016954259577`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}]], "Input",
 CellChangeTimes->{{3.6119261938736916`*^9, 3.61192620125843*^9}, {
  3.611926683238623*^9, 3.611926687177017*^9}, {3.6119274281041794`*^9, 
  3.61192742983418*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "4.440892098500626`*^-16"}], ",", 
   RowBox[{"-", "9.313225746154785`*^-10"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.6119262027125754`*^9, {3.6119266889961987`*^9, 3.611926702850584*^9}, 
   3.6119274307921796`*^9, 3.625401695435958*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 880},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 173, 7, 207, "Subtitle"],
Cell[CellGroupData[{
Cell[777, 33, 13060, 308, 1325, "Input"],
Cell[13840, 343, 1229, 22, 140, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15106, 370, 483, 7, 175, "Input"],
Cell[15592, 379, 151, 2, 36, "Output"],
Cell[15746, 383, 7462, 169, 262, "Output"],
Cell[23211, 554, 1058, 33, 258, "Output"],
Cell[24272, 589, 1434, 29, 74, "Output"],
Cell[25709, 620, 761, 21, 74, "Output"],
Cell[26473, 643, 1126, 46, 570, "Output"],
Cell[27602, 691, 1128, 46, 570, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[28767, 742, 428, 10, 60, "Input"],
Cell[29198, 754, 989, 18, 83, "Output"],
Cell[30190, 774, 139, 2, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[30366, 781, 197, 4, 36, "Input"],
Cell[30566, 787, 629, 14, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31232, 806, 252, 5, 36, "Input"],
Cell[31487, 813, 300, 7, 73, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
