(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     19405,        442]
NotebookOptionsPosition[     18405,        405]
NotebookOutlinePosition[     18826,        421]
CellTagsIndexPosition[     18783,        418]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the LP problem defined by:
min(c) s.t.
G.x < h
A.x = b
lb <= x <= ub\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myProblemId", " ", "=", " ", 
  RowBox[{"ToString", "[", "\"\<12\>\"", "]"}]}]}], "Input",
 CellChangeTimes->{{3.6252305629102526`*^9, 3.625230565209299*^9}, {
  3.62523066501033*^9, 3.6252306653723373`*^9}, {3.6252319230833654`*^9, 
  3.6252319231533704`*^9}, {3.6252322779407177`*^9, 3.6252322780317225`*^9}, {
  3.625232861163457*^9, 3.6252328612544603`*^9}, {3.6761933257314773`*^9, 
  3.6761933258114777`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\JOptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\\"\>"], "Output",
 CellChangeTimes->{3.6252306311246395`*^9, 3.6252307247285433`*^9, 
  3.625231926943636*^9, 3.6252322818619146`*^9, 3.625232862194498*^9, 
  3.676193303618256*^9, 3.676193361178832*^9}],

Cell[BoxData["\<\"12\"\>"], "Output",
 CellChangeTimes->{3.6252306311246395`*^9, 3.6252307247285433`*^9, 
  3.625231926943636*^9, 3.6252322818619146`*^9, 3.625232862194498*^9, 
  3.676193303618256*^9, 3.676193361178832*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   StyleBox["c", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<c\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "c", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<G\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<h\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"h", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", 
       RowBox[{"-", "1"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "h", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<A\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<b\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GA", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"G", ",", " ", "A"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"hbCoeff", " ", "=", " ", 
   RowBox[{"Join", "[", 
    RowBox[{"hCoeff", ",", " ", "bCoeff"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["lb", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<lb\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", "9999999"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["ub", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<ub\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"+", 
       StyleBox["99999999", "MR"]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"variablesBounds", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lb", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       RowBox[{"ub", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "n"}], "Input",
 CellChangeTimes->{{3.6252305728014526`*^9, 3.6252306250545163`*^9}, {
  3.6252307005180507`*^9, 3.625230704089123*^9}, {3.6258435263269196`*^9, 
  3.6258435291789193`*^9}}],

Cell[BoxData["588"], "Output",
 CellChangeTimes->{3.6252307411148777`*^9, 3.6252319271236486`*^9, 
  3.6252322822239327`*^9, 3.6252328672057*^9, 3.625232914681615*^9, 
  3.6761933041582613`*^9, 3.6761933614488354`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{
   "c", ",", "GA", ",", "hbCoeff", ",", " ", "variablesBounds", ",", " ", 
    StyleBox[
     RowBox[{"Method", "->", "\"\<InteriorPoint\>\""}], "MR"]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}], "\[IndentingNewLine]", 
 RowBox[{"myTolerance", " ", "=", " ", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6252307544471474`*^9, 3.6252307545971503`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "1011.9999999915065`", ",", "4.473804054487904`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "5.865367083470929`*^-10", ",", 
   "3.4393165478775764`*^-9", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "810.9999999924313`", ",", "3.730761050179663`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "1.1689512831468185`*^-9", ",", 
   "2.675190091178005`*^-9", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "731.9999999926576`", ",", "3.172246872825672`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "1.1212613793083627`*^-9", ",", 
   "3.055352101570953`*^-9", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "371.9999999921257`", ",", "3.737633578067901`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "2.061231064518366`*^-12", ",", "1.319736536901485`*^-12", ",", "0.`", ",",
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "8.821753166356267`*^-10", ",", "3.261003832587359`*^-9", ",", 
   "1.5830100009631243`*^-12", ",", "1.3233235713585556`*^-12", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "207.99999999579245`", ",", "1.812162998761531`*^-9", ",",
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "7.5858212726623`*^-10", 
   ",", "1.6430442410600555`*^-9", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "210.99999999575815`", ",", "1.8308025941600039`*^-9", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "7.582777031445073`*^-10", 
   ",", "1.6590146608958686`*^-9", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "287.9999999556584`", ",", "2.2925174603391832`*^-8", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "3.2356345418504827`*^-10",
    ",", "2.109924145318867`*^-8", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "8.614195243422174`*^-9", ",", "8.057830324276926`*^-9", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "37.449857925300016`", ",", "2.1532065298116086`*^-8", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "59.999999964815984`", ",", "1.851827435164988`*^-8", ",", 
   "202.55014203285154`", ",", "2.0322715427402622`*^-8", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "22.55014198681576`", ",", "2.0118738533758684`*^-8", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "277.4498579735646`", ",", 
   "1.9507208831197114`*^-8", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "133.52021929006054`", ",", "2.6404433017326653`*^-9", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "2.1208845224153844`*^-12", ",", "1.3171130273229477`*^-12", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "5.90712625388122`*^-9", ",", "166.47978070139817`", ",", 
   "1.5288866356375682`*^-12", ",", "1.320416988368112`*^-12", ",", "0.`", 
   ",", "0.`", ",", "114.82276467552323`", ",", "3.2273690031796507`*^-9", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "14.99999999798814`", ",", "8.631945541225631`*^-10", ",", "0.`", ",",
    "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "38.99999999668624`", ",", "1.4419239073059383`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "8.879107370077748`*^-9", ",", "131.17723531237655`", ",", 
   "4.961120231179801`*^-10", ",", "6.591301528280648`*^-10", ",", 
   "6.70996632535914`*^-10", ",", "1.2071180675249074`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "442.99999999187577`", ",", "3.693194753749362`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "9.31450172685045`*^-10", ",", 
   "3.5057738626502517`*^-9", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "157.421102704169`", ",", "2.1307934483402014`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "3.945580926189698`*^-9", ",", 
   "202.57889728976076`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",",
    "194.23591330265893`", ",", "1.6447313590003723`*^-9", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "1.8383141535141276`*^-9", ",", 
   "242.76408669386427`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.6252307789906454`*^9, 3.6252319271636515`*^9, 
  3.6252322822739353`*^9, 3.6252329225309305`*^9, 3.676193304438264*^9, 
  3.676193361468835*^9}],

Cell[BoxData[
 RowBox[{"-", "5.030195191712362`*^6"}]], "Output",
 CellChangeTimes->{3.6252307789906454`*^9, 3.6252319271636515`*^9, 
  3.6252322822739353`*^9, 3.6252329225309305`*^9, 3.676193304438264*^9, 
  3.676193361478835*^9}],

Cell[BoxData["2.745553669466417`*^-11"], "Output",
 CellChangeTimes->{3.6252307789906454`*^9, 3.6252319271636515`*^9, 
  3.6252322822739353`*^9, 3.6252329225309305`*^9, 3.676193304438264*^9, 
  3.676193361518836*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<tolerance\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myTolerance", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}]}], "Input"],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\JOptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\value12.txt\"\>"], "Output",
 CellChangeTimes->{3.625230797025013*^9, 3.625231927196654*^9, 
  3.625232282303937*^9, 3.625232925479049*^9, 3.676193304498265*^9, 
  3.676193361538836*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\JOptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\sol12.txt\"\>"], "Output",
 CellChangeTimes->{3.625230797025013*^9, 3.625231927196654*^9, 
  3.625232282303937*^9, 3.625232925479049*^9, 3.676193304498265*^9, 
  3.676193361558836*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\JOptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\tolerance12.txt\"\>"], "Output",
 CellChangeTimes->{3.625230797025013*^9, 3.625231927196654*^9, 
  3.625232282303937*^9, 3.625232925479049*^9, 3.676193304498265*^9, 
  3.676193361568836*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1915, 938},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 103, 6, 207, "Subtitle"],
Cell[CellGroupData[{
Cell[707, 32, 537, 9, 60, "Input"],
Cell[1247, 43, 314, 4, 36, "Output"],
Cell[1564, 49, 223, 3, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1824, 57, 4357, 139, 336, "Input"],
Cell[6184, 198, 218, 3, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6439, 206, 592, 14, 83, "Input"],
Cell[7034, 222, 9152, 124, 427, "Output"],
Cell[16189, 348, 231, 4, 38, "Output"],
Cell[16423, 354, 216, 3, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16676, 362, 799, 21, 83, "Input"],
Cell[17478, 385, 297, 4, 36, "Output"],
Cell[17778, 391, 295, 4, 36, "Output"],
Cell[18076, 397, 301, 4, 93, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
