(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     12575,        392]
NotebookOptionsPosition[     11647,        358]
NotebookOutlinePosition[     12067,        374]
CellTagsIndexPosition[     12024,        371]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the LP problem defined by:
min(c) s.t.
G.x < h\
\>", "Subtitle",
 CellChangeTimes->{3.615715061810238*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myProblemId", " ", "=", " ", 
  RowBox[{"ToString", "[", "\"\<4\>\"", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["c", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<c\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "c", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<G\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["h", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<h\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"hCoeff", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"h", "[", 
       RowBox[{"[", "i", "]"}], "]"}], ",", 
      RowBox[{"-", "1"}]}], "}"}], ",", " ", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "h", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", "n"}], "Input",
 CellChangeTimes->{{3.615715136535675*^9, 3.6157152079226475`*^9}, {
   3.615716130333332*^9, 3.6157162642302847`*^9}, {3.615716362649439*^9, 
   3.6157163921916723`*^9}, 3.6157166576050406`*^9, {3.615717255568964*^9, 
   3.615717261092886*^9}, 3.6157173064409823`*^9, {3.62514254858633*^9, 
   3.625142593499809*^9}, {3.6258435068929195`*^9, 3.6258435071829195`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\\"\>"], "Output",
 CellChangeTimes->{{3.6157163404845724`*^9, 3.615716394468951*^9}, 
   3.6157165466064606`*^9, 3.615716659309145*^9, 3.615717262700129*^9, 
   3.615717312074135*^9, 3.6251426372266855`*^9, 3.625229049466045*^9, 
   3.6252316016619797`*^9}],

Cell[BoxData["\<\"4\"\>"], "Output",
 CellChangeTimes->{{3.6157163404845724`*^9, 3.615716394468951*^9}, 
   3.6157165466064606`*^9, 3.615716659309145*^9, 3.615717262700129*^9, 
   3.615717312074135*^9, 3.6251426372266855`*^9, 3.625229049466045*^9, 
   3.6252316016619797`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.001`"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.`", ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.6157163404845724`*^9, 3.615716394468951*^9}, 
   3.6157165466064606`*^9, 3.615716659309145*^9, 3.615717262700129*^9, 
   3.615717312074135*^9, 3.6251426372266855`*^9, 3.625229049466045*^9, 
   3.625231601731988*^9}],

Cell[BoxData["23"], "Output",
 CellChangeTimes->{{3.6157163404845724`*^9, 3.615716394468951*^9}, 
   3.6157165466064606`*^9, 3.615716659309145*^9, 3.615717262700129*^9, 
   3.615717312074135*^9, 3.6251426372266855`*^9, 3.625229049466045*^9, 
   3.625231601731988*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{"c", ",", "G", ",", "hCoeff"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G", ".", "mySol"}], "-", "h"}]}], "Input",
 CellChangeTimes->{{3.6157150402194223`*^9, 3.615715043167879*^9}, {
  3.6157164601824827`*^9, 3.615716462943293*^9}, {3.6157171719581237`*^9, 
  3.615717195552826*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.731497961732242`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`"}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.615715069017576*^9, 3.6157164677318172`*^9, 3.6157165550604787`*^9, {
   3.6157171829289465`*^9, 3.6157171992978573`*^9}, 3.615717312183365*^9, 
   3.6251426424058948`*^9, 3.625229049786083*^9, 3.6252316017719927`*^9}],

Cell[BoxData["0.`"], "Output",
 CellChangeTimes->{
  3.615715069017576*^9, 3.6157164677318172`*^9, 3.6157165550604787`*^9, {
   3.6157171829289465`*^9, 3.6157171992978573`*^9}, 3.615717312183365*^9, 
   3.6251426424058948`*^9, 3.625229049786083*^9, 3.6252316017719927`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   RowBox[{"-", "0.731497961732242`"}], ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "1.268502038267758`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", 
   RowBox[{"-", "2.`"}], ",", "0.`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.615715069017576*^9, 3.6157164677318172`*^9, 3.6157165550604787`*^9, {
   3.6157171829289465`*^9, 3.6157171992978573`*^9}, 3.615717312183365*^9, 
   3.6251426424058948`*^9, 3.625229049786083*^9, 3.6252316017719927`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{3.6251426341066804`*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\value4.txt\"\>"], "Output",
 CellChangeTimes->{3.625142646259102*^9, 3.625229049797085*^9, 
  3.625231601791995*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\sol4.txt\"\>"], "Output",
 CellChangeTimes->{3.625142646259102*^9, 3.625229049797085*^9, 
  3.625231601801996*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1274, 877},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> True}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 123, 5, 135, "Subtitle"],
Cell[CellGroupData[{
Cell[727, 31, 2085, 58, 190, "Input"],
Cell[2815, 91, 368, 5, 35, "Output"],
Cell[3186, 98, 276, 4, 35, "Output"],
Cell[3465, 104, 4087, 145, 102, "Output"],
Cell[7555, 251, 267, 4, 35, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7859, 260, 478, 10, 80, "Input"],
Cell[8340, 272, 605, 11, 35, "Output"],
Cell[8948, 285, 273, 4, 35, "Output"],
Cell[9224, 291, 1330, 33, 58, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10591, 329, 570, 15, 58, "Input"],
Cell[11164, 346, 227, 3, 35, "Output"],
Cell[11394, 351, 225, 3, 35, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
