(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     12871,        334]
NotebookOptionsPosition[     11876,        297]
NotebookOutlinePosition[     12297,        313]
CellTagsIndexPosition[     12254,        310]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Solves the LP problem defined by:
min(c) s.t.
A.x = b
lb <= x <= ub\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myProblemId", " ", "=", " ", 
  RowBox[{"ToString", "[", "\"\<8\>\"", "]"}]}]}], "Input",
 CellChangeTimes->{{3.6250643853360825`*^9, 3.6250643934480968`*^9}, 
   3.6250645690752044`*^9, {3.625064861950119*^9, 3.625064862886121*^9}, {
   3.6252318149707756`*^9, 3.6252318150507812`*^9}, {3.625232074329481*^9, 
   3.6252320744104853`*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\\"\>"], "Output",
 CellChangeTimes->{
  3.6250645263759303`*^9, 3.625064569980006*^9, 3.6250648652885246`*^9, 
   3.6252293312633343`*^9, {3.625231803460969*^9, 3.625231819116067*^9}, 
   3.6252320780826693`*^9, 3.625232119982772*^9}],

Cell[BoxData["\<\"8\"\>"], "Output",
 CellChangeTimes->{
  3.6250645263759303`*^9, 3.625064569980006*^9, 3.6250648652885246`*^9, 
   3.6252293312633343`*^9, {3.625231803460969*^9, 3.625231819116067*^9}, 
   3.6252320780826693`*^9, 3.625232119992772*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   StyleBox["c", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<c\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Length", "[", "c", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<A\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", 
   StyleBox["=", "MR"], 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<b\>\"", ",", "myProblemId", ",", 
        "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bCoeff", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"b", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", "0"}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", 
       RowBox[{"Length", "[", "b", "]"}]}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["lb", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<lb\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", "9999999"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   StyleBox["ub", "MR"], 
   StyleBox["=", "MR"], 
   RowBox[{
    RowBox[{"Import", "[", 
     RowBox[{
      RowBox[{"StringJoin", "[", 
       RowBox[{"{", 
        RowBox[{
        "myRootDir", ",", " ", "\"\<ub\>\"", ",", "myProblemId", ",", 
         "\"\<.txt\>\""}], "}"}], "]"}], ",", "\"\<List\>\""}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{"\"\<NaN\>\"", "\[Rule]", 
      RowBox[{"+", 
       StyleBox["99999999", "MR"]}]}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"variablesBounds", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"lb", "[", 
        RowBox[{"[", "i", "]"}], "]"}], ",", " ", 
       RowBox[{"ub", "[", 
        RowBox[{"[", "i", "]"}], "]"}]}], "}"}], ",", " ", 
     RowBox[{"{", 
      RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", "n"}], "Input",
 CellChangeTimes->{{3.6250644083305225`*^9, 3.6250644900434666`*^9}, 
   3.6250645476231675`*^9, {3.625064908755801*^9, 3.6250649106434045`*^9}, {
   3.625064946445467*^9, 3.625064960611292*^9}, {3.6250650271922092`*^9, 
   3.625065031591417*^9}, {3.6258434972719193`*^9, 3.6258434975019193`*^9}}],

Cell[BoxData["156"], "Output",
 CellChangeTimes->{{3.6250645312475395`*^9, 3.625064553598778*^9}, 
   3.62506486828373*^9, 3.625064914574611*^9, {3.625064946960268*^9, 
   3.6250649618904943`*^9}, {3.6250650177697926`*^9, 3.6250650332138195`*^9}, 
   3.625229331422366*^9, {3.6252318036209803`*^9, 3.625231819266077*^9}, 
   3.6252320782326765`*^9, 3.6252321201427794`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"mySol", "=", 
  RowBox[{"LinearProgramming", "[", 
   RowBox[{"c", ",", "A", ",", "bCoeff", ",", " ", "variablesBounds"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"myValue", " ", "=", " ", 
  RowBox[{"c", ".", "mySol"}]}], "\[IndentingNewLine]", 
 RowBox[{"myTolerance", " ", "=", " ", 
  RowBox[{"Norm", "[", 
   RowBox[{
    RowBox[{"A", ".", "mySol"}], " ", "-", " ", "b"}], "]"}]}]}], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.5199999999999997`", ",", "0.`", ",", "0.0033999999999996945`", ",", 
   "0.06800000000000023`", ",", "1.4439999999999997`", ",", 
   "0.13489898989898988`", ",", "0.`", ",", "0.003400000000000009`", ",", 
   "0.`", ",", "0.`", ",", "0.39000000000000007`", ",", 
   "0.006088335017231806`", ",", "0.0034000000000000002`", ",", 
   "0.27906898620746173`", ",", "1.1298453082434108`", ",", "0.`", ",", "0.`",
    ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.20227272727272702`", ",", 
   "0.009522471719946937`", ",", "0.06926100299720085`", ",", 
   "0.2864347672167407`", ",", "1.4823616829009096`", ",", "0.`", ",", "0.`", 
   ",", "0.`", ",", "0.`", ",", "0.`", ",", "6.426803288786642`*^-16", ",", 
   "0.`", ",", "2.899773643900533`*^-16", ",", "0.`", ",", "0.`", ",", 
   "1.0952705412859401`*^-16", ",", "0.`", ",", "2.5228481475470666`*^-16", 
   ",", "0.`", ",", "0.`", ",", "2.6398138599955934`*^-16", ",", 
   "2.6398138599955934`*^-16", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "5.924494934083893`*^-17", ",", "0.`", ",", "0.007`", ",", "0.006`", ",", 
   "0.005865599999999999`", ",", "0.45352441538697075`", ",", 
   "0.11231011015110068`", ",", "0.27223113933060983`", ",", 
   "0.09008027105120447`", ",", "0.`", ",", "0.`", ",", "0.215`", ",", 
   "0.6290000000000002`", ",", "0.08`", ",", "0.42`", ",", "0.16`", ",", 
   "0.055`", ",", "0.06088335017231803`", ",", "0.073`", ",", 
   RowBox[{"-", "3.255568363043433`*^-17"}], ",", "0.`", ",", 
   RowBox[{"-", "1.4689124454051984`*^-17"}], ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "0.`", ",", "0.`", ",", "1.7142997615850265`*^-16", ",", "0.`",
    ",", 
   RowBox[{"-", "1.5870713268510201`*^-16"}], ",", 
   RowBox[{"-", "1.5870713268510201`*^-16"}], ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", 
   RowBox[{"-", "1.9944256155311588`*^-17"}], ",", 
   RowBox[{"-", "2.403412138241809`*^-16"}], ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "3.001700577487578`*^-18", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "0.2983164543617195`", ",", "0.`", ",", "0.289311903414117`", ",", 
   "0.013535999999999996`", ",", "0.`", ",", "0.7879227353708047`", ",", 
   "0.1887939789494016`", ",", "0.16243312903000007`", ",", 
   "0.06010518167928414`", ",", "0.`", ",", "0.26499999999999996`", ",", 
   "0.7679999999999999`", ",", "0.1`", ",", "0.5`", ",", "0.2`", ",", 
   "0.065`", ",", "0.09522471719946929`", ",", "0.11`", ",", 
   "0.0034341367027151365`", ",", "0.20227272727272744`", ",", 
   "0.08148353293788277`", ",", "0.33698207907851846`", ",", 
   "1.5603807188430632`", ",", "1.1261124880046177`*^-17", ",", 
   "0.006088335017231794`", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`", 
   ",", "3.3786621484980463`*^-16", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "0.`", ",", "2.835915378132726`*^-16", ",", "2.0882285002573377`*^-16", 
   ",", "0.`", ",", "1.6187679555691917`*^-16", ",", 
   "1.6187679555691917`*^-16", ",", "0.`", ",", "0.`", ",", "0.`", ",", 
   "4.7231283657868955`*^-18", ",", "0.`", ",", "0.`", ",", "0.`", ",", "0.`",
    ",", "0.`", ",", "0.`", ",", "0.`", ",", "1.0997341860264054`", ",", 
   "0.1509118302264458`", ",", "0.1796309141812249`", ",", 
   "0.2908808387193577`", ",", "0.`", ",", "0.28`", ",", "1.009`", ",", 
   "0.12`", ",", "0.6`", ",", "0.2`", ",", "0.08`", ",", 
   "0.14288805910466182`", ",", "0.2`", ",", "0.01428880591046618`", ",", 
   "0.5477272727272728`", ",", "0.5516001796172444`", ",", 
   "0.9367486137944565`", ",", "2.677185320673853`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.6250648868165627`*^9, 3.6250650214357986`*^9, 3.625229331452372*^9, {
   3.6252318036309805`*^9, 3.625231819276078*^9}, 3.625232078392685*^9, 
   3.625232120174781*^9}],

Cell[BoxData["817.4663549737365`"], "Output",
 CellChangeTimes->{
  3.6250648868165627`*^9, 3.6250650214357986`*^9, 3.625229331452372*^9, {
   3.6252318036309805`*^9, 3.625231819276078*^9}, 3.625232078392685*^9, 
   3.6252321201947823`*^9}],

Cell[BoxData["1.957201528811115`*^-15"], "Output",
 CellChangeTimes->{
  3.6250648868165627`*^9, 3.6250650214357986`*^9, 3.625229331452372*^9, {
   3.6252318036309805`*^9, 3.625231819276078*^9}, 3.625232078392685*^9, 
   3.6252321202047825`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<value\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myValue", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<sol\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "mySol", " ", ",", " ", "\"\<Lines\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{
   RowBox[{"StringJoin", "[", 
    RowBox[{
    "myRootDir", ",", " ", "\"\<tolerance\>\"", ",", "myProblemId", ",", 
     "\"\<.txt\>\""}], "]"}], ",", "myTolerance", " ", ",", " ", 
   "\"\<Lines\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.6250650826347065`*^9, 3.625065110777156*^9}}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\value8.txt\"\>"], "Output",
 CellChangeTimes->{
  3.6250651133667603`*^9, 3.625229331471376*^9, {3.6252318036509824`*^9, 
   3.625231819296079*^9}, 3.625232078562693*^9, 3.625232120224784*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\sol8.txt\"\>"], "Output",
 CellChangeTimes->{
  3.6250651133667603`*^9, 3.625229331471376*^9, {3.6252318036509824`*^9, 
   3.625231819296079*^9}, 3.625232078562693*^9, 3.625232120244785*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\lp\\\\tolerance8.txt\"\>"], "Output",
 CellChangeTimes->{
  3.6250651133667603`*^9, 3.625229331471376*^9, {3.6252318036509824`*^9, 
   3.625231819296079*^9}, 3.625232078562693*^9, 3.625232120244785*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1274, 877},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 95, 5, 171, "Subtitle"],
Cell[CellGroupData[{
Cell[699, 31, 461, 8, 60, "Input"],
Cell[1163, 41, 345, 5, 36, "Output"],
Cell[1511, 48, 253, 4, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1801, 57, 3154, 97, 221, "Input"],
Cell[4958, 156, 373, 5, 36, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5368, 166, 428, 10, 83, "Input"],
Cell[5799, 178, 3734, 58, 279, "Output"],
Cell[9536, 238, 240, 4, 36, "Output"],
Cell[9779, 244, 245, 4, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10061, 253, 867, 22, 83, "Input"],
Cell[10931, 277, 303, 4, 36, "Output"],
Cell[11237, 283, 301, 4, 36, "Output"],
Cell[11541, 289, 307, 4, 36, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
