(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     26438,        500]
NotebookOptionsPosition[     25459,        462]
NotebookOutlinePosition[     25880,        478]
CellTagsIndexPosition[     25837,        475]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Cholesky decomposition of the matrix m:
m = Transpose[u].u, 
with u upper left triangular\
\>", "Subtitle",
 CellChangeTimes->{{3.6253223843486595`*^9, 3.625322388079548*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"myRootDir", "=", 
  RowBox[{"NotebookDirectory", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"myProblemId", " ", "=", " ", 
   RowBox[{"ToString", "[", "\"\<10\>\"", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.625323121165713*^9, 3.625323123246919*^9}, 
   3.625323365000929*^9}],

Cell[BoxData["\<\"C:\\\\DATADIR\\\\Programmazione\\\\java\\\\joptimizer\\\\\
src\\\\test\\\\resources\\\\factorization\\\\\"\>"], "Output",
 CellChangeTimes->{3.625323123917308*^9, 3.625323307008441*^9, 
  3.625323366331221*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"G", "=", 
   RowBox[{"Import", "[", 
    RowBox[{
     RowBox[{"StringJoin", "[", 
      RowBox[{"{", 
       RowBox[{
       "myRootDir", ",", " ", "\"\<matrix\>\"", ",", "myProblemId", ",", 
        "\"\<.csv\>\""}], "}"}], "]"}], ",", "\"\<CSV\>\""}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.625323149656228*^9, 3.6253231850927696`*^9}, {
  3.6253235883710003`*^9, 3.6253235896512823`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "[", "G", "]"}]], "Input",
 CellChangeTimes->{{3.625323381258505*^9, 3.625323388141019*^9}, {
  3.625323453019633*^9, 3.6253234537068386`*^9}, {3.625323544023926*^9, 
  3.6253235736418085`*^9}}],

Cell[BoxData["761"], "Output",
 CellChangeTimes->{3.6253235743850317`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"CholeskyDecomposition", "[", "G", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{3.6253232022957416`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", 
  StyleBox["[", "MR"], 
  RowBox[{
   RowBox[{
    RowBox[{
     StyleBox["Transpose", "MR"], 
     StyleBox["[", "MR"], 
     StyleBox["u", "TI"], 
     StyleBox["]", "MR"]}], 
    StyleBox[".", "MR"], 
    StyleBox["u", "MR"]}], 
   StyleBox[" ", "MR"], 
   StyleBox["-", "MR"], 
   StyleBox[" ", "MR"], 
   StyleBox["G", "MR"]}], 
  StyleBox["]", "MR"]}]], "Input",
 CellChangeTimes->{3.6253233026249*^9}],

Cell[BoxData["9.100903556280165`*^-13"], "Output",
 CellChangeTimes->{3.625323326442706*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Eigenvalues", "[", "G", "]"}]], "Input",
 CellChangeTimes->{3.625323331346549*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7820.93404948337`", ",", "107.10948294419921`", ",", "49.19838078840756`", 
   ",", "48.69791574978322`", ",", "30.355331113999874`", ",", 
   "25.285161253868672`", ",", "25.183821925268308`", ",", 
   "20.537292967041303`", ",", "20.481003295060493`", ",", 
   "18.43361943641942`", ",", "18.392607185980197`", ",", 
   "16.426606386911025`", ",", "16.399792800116952`", ",", 
   "15.291780283936628`", ",", "15.285564755215162`", ",", 
   "15.276207343445764`", ",", "15.247511582281815`", ",", 
   "15.147234049428917`", ",", "15.120713411997546`", ",", 
   "14.81951653855731`", ",", "14.120965310769662`", ",", 
   "13.994498455680159`", ",", "13.979910074351132`", ",", 
   "13.794101123403559`", ",", "13.779448498616803`", ",", 
   "13.337529324558917`", ",", "13.329862433699978`", ",", 
   "13.29728748275699`", ",", "13.287610079246955`", ",", 
   "13.250991364300184`", ",", "13.242657422333108`", ",", 
   "13.227779062198431`", ",", "13.204840500625835`", ",", 
   "12.853853780261977`", ",", "12.731864331166635`", ",", 
   "12.721448741884988`", ",", "12.434015465715337`", ",", 
   "12.425496969084394`", ",", "12.142123184229751`", ",", 
   "12.135481698566576`", ",", "12.00568651634055`", ",", 
   "11.916341407853839`", ",", "11.911809362125087`", ",", 
   "11.880298451231706`", ",", "11.866837143363538`", ",", 
   "11.862169098286898`", ",", "11.845998169591873`", ",", 
   "11.840393228463842`", ",", "11.825232256832967`", ",", 
   "11.816352278398096`", ",", "11.697817062334085`", ",", 
   "11.693441341330702`", ",", "11.66327839409855`", ",", 
   "11.658980824432408`", ",", "11.629663596167337`", ",", 
   "11.629217584205415`", ",", "11.628696757836499`", ",", 
   "11.62599181009188`", ",", "11.624023843350233`", ",", 
   "11.60746817844397`", ",", "11.429191247697997`", ",", 
   "11.427645875375898`", ",", "11.425182831930288`", ",", 
   "11.41885227235062`", ",", "11.375055222507374`", ",", 
   "11.372502318736743`", ",", "11.364446447046356`", ",", 
   "11.362198465439377`", ",", "11.356942046641992`", ",", 
   "11.34943416967904`", ",", "11.343522393269895`", ",", 
   "11.331325043086984`", ",", "11.254370732508367`", ",", 
   "11.250054768651623`", ",", "11.205598816094577`", ",", 
   "11.202875385574536`", ",", "11.195708473139936`", ",", 
   "11.156484912372521`", ",", "11.153367633490104`", ",", 
   "11.139333408927053`", ",", "11.136203889737935`", ",", 
   "11.128537820101371`", ",", "11.122796041262974`", ",", 
   "11.0875382219544`", ",", "11.083772155736654`", ",", 
   "11.060478866978578`", ",", "11.058891296829586`", ",", 
   "11.056590866438887`", ",", "11.049152464660718`", ",", 
   "11.016807115920594`", ",", "11.01189352004236`", ",", 
   "10.923639049284382`", ",", "10.92100903173913`", ",", 
   "10.900799501495435`", ",", "10.898271554514258`", ",", 
   "10.879514644639155`", ",", "10.879136704462937`", ",", 
   "10.878698691488875`", ",", "10.87472534749979`", ",", 
   "10.869048839016806`", ",", "10.864050730768358`", ",", 
   "10.838828493652096`", ",", "10.836457977244136`", ",", 
   "10.829665593270475`", ",", "10.826644875281`", ",", "10.820798335629162`",
    ",", "10.8147473521291`", ",", "10.766558715150527`", ",", 
   "10.715786917125081`", ",", "10.714444687377359`", ",", 
   "10.71089013028707`", ",", "10.698767961819215`", ",", 
   "10.697925313440617`", ",", "10.696693144895727`", ",", 
   "10.692896793534064`", ",", "10.678920278217818`", ",", 
   "10.676300002780062`", ",", "10.654133295116425`", ",", 
   "10.652423469275899`", ",", "10.643677486585991`", ",", 
   "10.641935841286863`", ",", "10.633106747558577`", ",", 
   "10.631748625246635`", ",", "10.626218171423806`", ",", 
   "10.625925813634481`", ",", "10.625593956415221`", ",", 
   "10.622609149017396`", ",", "10.618052799325774`", ",", 
   "10.616310399562268`", ",", "10.613638011970759`", ",", 
   "10.61086535374479`", ",", "10.607316479056687`", ",", 
   "10.602347191904036`", ",", "10.588285094078485`", ",", 
   "10.585400852537683`", ",", "10.567965784051026`", ",", 
   "10.566624719096673`", ",", "10.56342883373797`", ",", 
   "10.561283705349695`", ",", "10.556564368005287`", ",", 
   "10.548061838486221`", ",", "10.547027871515734`", ",", 
   "10.545310095244329`", ",", "10.543227040019529`", ",", 
   "10.539532657821447`", ",", "10.533213986707217`", ",", 
   "10.532845934868643`", ",", "10.532463023308706`", ",", 
   "10.525277624953826`", ",", "10.512694569782978`", ",", 
   "10.509001448373846`", ",", "10.487798877377148`", ",", 
   "10.485633904534144`", ",", "10.474052805033994`", ",", 
   "10.472252131038267`", ",", "10.465690726856261`", ",", 
   "10.463606700852313`", ",", "10.452327335275605`", ",", 
   "10.449586177149742`", ",", "10.448582954135544`", ",", 
   "10.445919371998784`", ",", "10.444914139161108`", ",", 
   "10.444086845324168`", ",", "10.44277359580946`", ",", 
   "10.440845917060477`", ",", "10.44056237035607`", ",", 
   "10.44029314439345`", ",", "10.436445909836165`", ",", 
   "10.43454716194949`", ",", "10.424931743895403`", ",", 
   "10.398670885381618`", ",", "10.398604705448209`", ",", 
   "10.398536988499211`", ",", "10.393930321569975`", ",", 
   "10.38535637826381`", ",", "10.382488362770674`", ",", 
   "10.375334880832947`", ",", "10.37150630265879`", ",", 
   "10.339073194307268`", ",", "10.338055094905592`", ",", 
   "10.335943368682301`", ",", "10.333459505694528`", ",", 
   "10.321549068428446`", ",", "10.319907871604528`", ",", 
   "10.31003643183147`", ",", "10.308977568769366`", ",", 
   "10.305746360299198`", ",", "10.304574881016281`", ",", 
   "10.302104578978055`", ",", "10.300438157684336`", ",", 
   "10.296138768294954`", ",", "10.295733238920604`", ",", 
   "10.295288648582817`", ",", "10.29112977531665`", ",", 
   "10.282961654235281`", ",", "10.28230516894393`", ",", "10.2789043692379`",
    ",", "10.269339902438036`", ",", "10.26711357113167`", ",", 
   "10.250993459315119`", ",", "10.25042192939822`", ",", 
   "10.249198161706238`", ",", "10.248681201815854`", ",", 
   "10.248136607807941`", ",", "10.244400696013212`", ",", 
   "10.229956419395062`", ",", "10.229422608389585`", ",", 
   "10.228329579257851`", ",", "10.228095294604286`", ",", 
   "10.225612400777507`", ",", "10.22016766862004`", ",", 
   "10.219075738098828`", ",", "10.217032883322242`", ",", 
   "10.214960303814433`", ",", "10.20772812128134`", ",", 
   "10.207426347872566`", ",", "10.207071021390686`", ",", 
   "10.204522672562154`", ",", "10.198547647207407`", ",", 
   "10.19824461426768`", ",", "10.197901095714565`", ",", 
   "10.194970024681815`", ",", "10.19019696436392`", ",", 
   "10.188248558376186`", ",", "10.180148432737123`", ",", 
   "10.17958945013074`", ",", "10.178694316036797`", ",", 
   "10.177305705733355`", ",", "10.175445140160262`", ",", 
   "10.173156635643553`", ",", "10.16636888588478`", ",", 
   "10.165523410285168`", ",", "10.163521858497415`", ",", 
   "10.162784423099563`", ",", "10.161838878289052`", ",", 
   "10.15955289687199`", ",", "10.154553895622197`", ",", 
   "10.153984399298464`", ",", "10.15322282569872`", ",", 
   "10.151205984146747`", ",", "10.148061695999324`", ",", 
   "10.145467905514028`", ",", "10.144311674649773`", ",", 
   "10.141807710165274`", ",", "10.14173970078926`", ",", 
   "10.139591553106104`", ",", "10.136585529403634`", ",", 
   "10.13535704106906`", ",", "10.132388502014434`", ",", 
   "10.132378784537673`", ",", "10.132369040612897`", ",", 
   "10.13045510552047`", ",", "10.12932676110483`", ",", 
   "10.126342345066757`", ",", "10.123985481534898`", ",", 
   "10.120640993198135`", ",", "10.11486057506265`", ",", 
   "10.113883360498507`", ",", "10.112513023868084`", ",", 
   "10.110266500141135`", ",", "10.107266099954716`", ",", 
   "10.105062894286673`", ",", "10.09960219226049`", ",", 
   "10.099378463122335`", ",", "10.098040933474174`", ",", 
   "10.095858008717856`", ",", "10.095419654601566`", ",", 
   "10.09488558678851`", ",", "10.094271345352894`", ",", 
   "10.093848300599149`", ",", "10.086269718369442`", ",", 
   "10.073577825027446`", ",", "10.073197184086974`", ",", 
   "10.072512811502381`", ",", "10.072086539766639`", ",", 
   "10.071671737170336`", ",", "10.069470913445235`", ",", 
   "10.067337552708452`", ",", "10.065693780195886`", ",", 
   "10.062782338887034`", ",", "10.062250459615054`", ",", 
   "10.06150501989008`", ",", "10.061059442190837`", ",", 
   "10.060703625227173`", ",", "10.057090644918542`", ",", 
   "10.055522545678748`", ",", "10.04878266315266`", ",", 
   "10.041421623758017`", ",", "10.03924128171366`", ",", 
   "10.033242646613553`", ",", "10.033222688615329`", ",", 
   "10.03167822526256`", ",", "10.030197662040898`", ",", 
   "10.028275417908707`", ",", "10.026702440533459`", ",", 
   "10.020613257872562`", ",", "10.005018486696516`", ",", 
   "10.002742957653915`", ",", "10.001465901954473`", ",", 
   "9.996727620652507`", ",", "9.996051508197972`", ",", "9.994359492164339`",
    ",", "9.994159563084034`", ",", "9.993953075266063`", ",", 
   "9.991119092005608`", ",", "9.987548028556159`", ",", "9.986081823499989`",
    ",", "9.983141926045406`", ",", "9.98184119267816`", ",", 
   "9.978984307178848`", ",", "9.97865210066594`", ",", "9.978303574880018`", 
   ",", "9.974897715637939`", ",", "9.970672448447617`", ",", 
   "9.968744732850887`", ",", "9.961885746260144`", ",", "9.9616341560734`", 
   ",", "9.96130386775516`", ",", "9.960525791540265`", ",", 
   "9.959890884491278`", ",", "9.956762099471817`", ",", "9.951454317427258`",
    ",", "9.950507230308451`", ",", "9.948559095866017`", ",", 
   "9.947704268023871`", ",", "9.946661445298446`", ",", "9.944157926542802`",
    ",", "9.9385894492955`", ",", "9.937695392426903`", ",", 
   "9.935654018143572`", ",", "9.93467230732368`", ",", "9.932998208563824`", 
   ",", "9.931469700396608`", ",", "9.924800920053881`", ",", 
   "9.924752425353006`", ",", "9.924694103757028`", ",", "9.924401259619108`",
    ",", "9.924076347189391`", ",", "9.923994295497014`", ",", 
   "9.923679163821273`", ",", "9.923497595661996`", ",", "9.920633242669652`",
    ",", "9.91635914532774`", ",", "9.916302981293635`", ",", 
   "9.916221826469412`", ",", "9.916130396532957`", ",", "9.916057068259754`",
    ",", "9.91551168462821`", ",", "9.915219361630076`", ",", 
   "9.914688445845638`", ",", "9.914413169534196`", ",", "9.912023628938238`",
    ",", "9.911216245975645`", ",", "9.907996796367911`", ",", 
   "9.906485369757041`", ",", "9.902987117636622`", ",", "9.899506769264889`",
    ",", "9.898124174846028`", ",", "9.895819637955064`", ",", 
   "9.894656303445984`", ",", "9.893707238705934`", ",", "9.89265431480321`", 
   ",", "9.891295415755678`", ",", "9.889535547801177`", ",", 
   "9.888099539852274`", ",", "9.88670062395563`", ",", "9.88529479450597`", 
   ",", "9.883838941470906`", ",", "9.882505785368963`", ",", 
   "9.880652726384598`", ",", "9.878880014445501`", ",", "9.877459203119624`",
    ",", "9.875989830563485`", ",", "9.874549655818761`", ",", 
   "9.8728982356847`", ",", "9.872488551681885`", ",", "9.872129304469297`", 
   ",", "9.869094883261715`", ",", "9.865583483062904`", ",", 
   "9.861703161159134`", ",", "9.86155221031676`", ",", "9.861401265249334`", 
   ",", "9.857523896809388`", ",", "9.854020959320241`", ",", 
   "9.850997757858826`", ",", "9.85064006572049`", ",", "9.850232234078687`", 
   ",", "9.848588850493398`", ",", "9.847156742053627`", ",", 
   "9.84569628398104`", ",", "9.844285087711892`", ",", "9.842525275879778`", 
   ",", "9.840687302866675`", ",", "9.839365680311433`", ",", 
   "9.837923404282213`", ",", "9.836531330217953`", ",", "9.835147047497708`",
    ",", "9.833726716122817`", ",", "9.831987283229006`", ",", 
   "9.830645061561246`", ",", "9.829605473023845`", ",", "9.828668889371366`",
    ",", "9.827521260209858`", ",", "9.825249394299322`", ",", 
   "9.823887575361704`", ",", "9.820462251619826`", ",", "9.817024821069161`",
    ",", "9.815540877809449`", ",", "9.812383416455376`", ",", 
   "9.811592136388798`", ",", "9.809251943353356`", ",", "9.80898248523216`", 
   ",", "9.808462890603035`", ",", "9.80817684028398`", ",", 
   "9.807643263667654`", ",", "9.80757153080277`", ",", "9.80748209374491`", 
   ",", "9.807402710114651`", ",", "9.807347773707836`", ",", 
   "9.803170558739575`", ",", "9.800375391065701`", ",", "9.800198304719482`",
    ",", "9.799890987992061`", ",", "9.799810977173529`", ",", 
   "9.79949416814031`", ",", "9.799208668871517`", ",", "9.79915181328929`", 
   ",", "9.79910453884467`", ",", "9.792612126073495`", ",", 
   "9.791126665830033`", ",", "9.789500529069992`", ",", "9.788547548855693`",
    ",", "9.786566923952682`", ",", "9.78570006780062`", ",", 
   "9.780307299629298`", ",", "9.777887104751509`", ",", "9.776879540738173`",
    ",", "9.776053999781343`", ",", "9.774173506480574`", ",", 
   "9.773259924471743`", ",", "9.768145598613179`", ",", "9.765136439267904`",
    ",", "9.76452617612578`", ",", "9.763778555847738`", ",", 
   "9.763461253475914`", ",", "9.763219589647205`", ",", "9.756640165207756`",
    ",", "9.754794566820571`", ",", "9.750753315007955`", ",", 
   "9.747501353457492`", ",", "9.747168781826325`", ",", "9.746851835783053`",
    ",", "9.744127752586879`", ",", "9.742888661296044`", ",", 
   "9.740090054663167`", ",", "9.738695737126896`", ",", "9.73530256582805`", 
   ",", "9.732613597394872`", ",", "9.73241777365554`", ",", 
   "9.73222818893014`", ",", "9.73062426805401`", ",", "9.729983703283194`", 
   ",", "9.725498983850873`", ",", "9.724291857914018`", ",", 
   "9.722142183117755`", ",", "9.707460698759272`", ",", "9.701754216854807`",
    ",", "9.700281876495078`", ",", "9.698484115506819`", ",", 
   "9.697100183906336`", ",", "9.695657541392844`", ",", "9.695638903826977`",
    ",", "9.690043437190138`", ",", "9.688013310597366`", ",", 
   "9.68117013764487`", ",", "9.67492360339515`", ",", "9.673472257752893`", 
   ",", "9.670132150595594`", ",", "9.66980344013125`", ",", 
   "9.669391886453091`", ",", "9.668703501210311`", ",", "9.668212479476363`",
    ",", "9.665526273421106`", ",", "9.664011218405`", ",", 
   "9.662046052871936`", ",", "9.660020724228348`", ",", "9.659639159694867`",
    ",", "9.65924712447283`", ",", "9.65861783253996`", ",", 
   "9.658267913944627`", ",", "9.646628708396882`", ",", "9.639707548410817`",
    ",", "9.63932173591239`", ",", "9.638761691323522`", ",", 
   "9.638274836257454`", ",", "9.637875326206295`", ",", "9.635886723878407`",
    ",", "9.634669210449944`", ",", "9.634465607415247`", ",", 
   "9.62950129000062`", ",", "9.627501691285994`", ",", "9.624780736192813`", 
   ",", "9.62274588021752`", ",", "9.621505340288586`", ",", 
   "9.620621177328424`", ",", "9.615397234685839`", ",", "9.612380724354017`",
    ",", "9.61025679256377`", ",", "9.607570583843309`", ",", 
   "9.606555645953097`", ",", "9.60483524561473`", ",", "9.604826489909128`", 
   ",", "9.604817758010016`", ",", "9.602151736539565`", ",", 
   "9.601049452404407`", ",", "9.598354064676833`", ",", "9.596430078364403`",
    ",", "9.596369186868829`", ",", "9.594128310159327`", ",", 
   "9.593094404244948`", ",", "9.590776446926284`", ",", "9.58796961331781`", 
   ",", "9.586171230449317`", ",", "9.585492429877513`", ",", 
   "9.584984990015373`", ",", "9.580535084863257`", ",", "9.578503356640923`",
    ",", "9.577663377542292`", ",", "9.577008532824394`", ",", 
   "9.575231957303666`", ",", "9.574481989694762`", ",", "9.56846912355656`", 
   ",", "9.56644574277305`", ",", "9.564801719093497`", ",", 
   "9.563575632121`", ",", "9.56278553472725`", ",", "9.562292310851165`", 
   ",", "9.555156342613564`", ",", "9.553443439783695`", ",", 
   "9.549251755936465`", ",", "9.546681945344162`", ",", "9.546380914243114`",
    ",", "9.546115402017787`", ",", "9.540886089258375`", ",", 
   "9.53865974147684`", ",", "9.538349444976458`", ",", "9.538085955733788`", 
   ",", "9.531779931877223`", ",", "9.529976262314197`", ",", 
   "9.528199532389568`", ",", "9.527250522527114`", ",", "9.522523687629961`",
    ",", "9.520371734042664`", ",", "9.520168760421855`", ",", 
   "9.51922202176393`", ",", "9.518759823995135`", ",", "9.5062875950737`", 
   ",", "9.503073393029666`", ",", "9.502605143903237`", ",", 
   "9.502160765194118`", ",", "9.50110911212492`", ",", "9.500618159807358`", 
   ",", "9.486813144623065`", ",", "9.484913496433599`", ",", 
   "9.476768451473967`", ",", "9.473880073249502`", ",", "9.47332284274171`", 
   ",", "9.466400353234414`", ",", "9.462884625382006`", ",", 
   "9.462509045610725`", ",", "9.462166531371938`", ",", "9.458538177643122`",
    ",", "9.457133620510943`", ",", "9.455052800903749`", ",", 
   "9.454066812050694`", ",", "9.451349156225826`", ",", "9.450459394020136`",
    ",", "9.44218035867253`", ",", "9.440807072990758`", ",", 
   "9.43086416140216`", ",", "9.42879657697105`", ",", "9.42703988317412`", 
   ",", "9.426193535847009`", ",", "9.39939469083727`", ",", 
   "9.396253291947026`", ",", "9.390393418595911`", ",", "9.388049036823093`",
    ",", "9.381053087933271`", ",", "9.377304313621382`", ",", 
   "9.377249244917358`", ",", "9.377195427790799`", ",", "9.355940388708989`",
    ",", "9.348211487923518`", ",", "9.346687875437693`", ",", 
   "9.343604458672914`", ",", "9.343388830866337`", ",", "9.343161761759541`",
    ",", "9.341618582438828`", ",", "9.340567998037928`", ",", 
   "9.339906377773051`", ",", "9.339102738665268`", ",", "9.336974682156272`",
    ",", "9.336173770190893`", ",", "9.333986692343476`", ",", 
   "9.325009958475894`", ",", "9.323355696106345`", ",", "9.318154441995894`",
    ",", "9.316729453916075`", ",", "9.30758505162693`", ",", 
   "9.305880185432514`", ",", "9.289249815889246`", ",", "9.286366957836265`",
    ",", "9.276569162035562`", ",", "9.270995999657922`", ",", 
   "9.270699332953853`", ",", "9.270414226802666`", ",", "9.265525007393508`",
    ",", "9.262671825723764`", ",", "9.261064789463273`", ",", 
   "9.259740283316981`", ",", "9.2589435082631`", ",", "9.25240191162314`", 
   ",", "9.248779645286477`", ",", "9.247135408041657`", ",", 
   "9.24468765667788`", ",", "9.243661494832214`", ",", "9.230362959758402`", 
   ",", "9.228171487566444`", ",", "9.21751554228819`", ",", 
   "9.213763876497415`", ",", "9.211087631411079`", ",", "9.208999543207126`",
    ",", "9.206988509241096`", ",", "9.205678543060406`", ",", 
   "9.202256212018671`", ",", "9.200017657731326`", ",", "9.199768885233274`",
    ",", "9.199549752936338`", ",", "9.195408555182317`", ",", 
   "9.194392954055646`", ",", "9.187801491763583`", ",", "9.1865038661802`", 
   ",", "9.179998478970615`", ",", "9.178729220434825`", ",", 
   "9.162339858961897`", ",", "9.160411318358625`", ",", "9.150151402893274`",
    ",", "9.147373887847401`", ",", "9.146472968730679`", ",", 
   "9.145857126267929`", ",", "9.137016970175647`", ",", "9.134431989173493`",
    ",", "9.133456756097623`", ",", "9.096892795446085`", ",", 
   "9.062771699794505`", ",", "9.058528438444915`", ",", "9.054434822396967`",
    ",", "9.052323568275435`", ",", "9.047582910970855`", ",", 
   "9.045931389205506`", ",", "9.028436862475498`", ",", "9.024989034503326`",
    ",", "9.021078629378234`", ",", "9.018346622773345`", ",", 
   "9.018045626055729`", ",", "9.017785954991625`", ",", "9.004939405065219`",
    ",", "9.003214585024264`", ",", "8.989474830677212`", ",", 
   "8.987694014281415`", ",", "8.928815252035987`", ",", "8.925588645870176`",
    ",", "8.90446785714697`", ",", "8.89964456631887`", ",", 
   "8.898154604863699`", ",", "8.897127158327349`", ",", "8.882111123551798`",
    ",", "8.879694797117404`", ",", "8.857207981335762`", ",", 
   "8.853571805152281`", ",", "8.848725244065236`", ",", "8.84675075360181`", 
   ",", "8.837918342439957`", ",", "8.835962447442023`", ",", 
   "8.81151197780309`", ",", "8.807078137026734`", ",", "8.80539601475358`", 
   ",", "8.778137301654567`", ",", "8.775512277813306`", ",", 
   "8.72928438738866`", ",", "8.722060789791477`", ",", "8.718569871487551`", 
   ",", "8.714143970202919`", ",", "8.711052186183442`", ",", 
   "8.709731462366957`", ",", "8.70500533047697`", ",", "8.703510426913617`", 
   ",", "8.678041761081477`", ",", "8.674390268523842`", ",", 
   "8.672970942451906`", ",", "8.67208109594696`", ",", "8.572178387044078`", 
   ",", "8.563176093328034`", ",", "8.562108313096932`", ",", 
   "8.560641889743904`", ",", "8.560359650841294`", ",", "8.560117997772133`",
    ",", "8.54430295369942`", ",", "8.541997009601157`", ",", 
   "8.525889462413451`", ",", "8.523565502901462`", ",", "8.461713107500934`",
    ",", "8.457167813247862`", ",", "8.449429301321425`", ",", 
   "8.446578313463348`", ",", "8.438375255108623`", ",", "8.436015299441662`",
    ",", "8.429225350924295`", ",", "8.413433637651812`", ",", 
   "8.411174892023027`", ",", "8.367222312984401`", ",", "8.305312713884526`",
    ",", "8.302206260788791`", ",", "8.174731135134255`", ",", 
   "8.171050316980939`", ",", "8.05149914045378`", ",", "8.04733526983218`", 
   ",", "7.999349169278815`", ",", "7.869172948803559`", ",", 
   "7.861057452672535`", ",", "7.855811126222269`", ",", 
   "7.8528823545820705`", ",", "7.840076297714337`", ",", 
   "7.836712869960321`", ",", "7.82544138434049`", ",", "7.8228025951472135`",
    ",", "7.678365700131035`", ",", "7.673827156016406`", ",", 
   "7.617499728319853`", ",", "7.613178772097326`", ",", "7.576264580233897`",
    ",", "7.389382890617442`", ",", "7.31670600013424`", ",", 
   "7.310519959466911`", ",", "7.2873831064129915`", ",", "7.28085242829218`",
    ",", "7.278728419224416`", ",", "7.277320183917627`", ",", 
   "7.050616698970792`", ",", "7.045677979150316`", ",", 
   "6.7368039150969805`", ",", "6.731326730682757`", ",", 
   "6.4942513639928245`", ",", "6.488622306342267`", ",", 
   "6.131200630295225`", ",", "6.1252387642184765`", ",", 
   "5.8870293029874885`", ",", "5.486238708332211`", ",", 
   "5.479993827439488`", ",", "5.168676637001784`", ",", 
   "2.842170943040401`*^-14"}], "}"}]], "Output",
 CellChangeTimes->{3.6253233324171696`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", "G", "]"}]], "Input",
 CellChangeTimes->{3.6253233385301046`*^9}],

Cell[BoxData["2.15788663537504137070670405285595937`15.954589770191005*^749"],\
 "Output",
 CellChangeTimes->{3.625323342781039*^9}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1268, 871},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 185, 5, 135, "Subtitle"],
Cell[CellGroupData[{
Cell[789, 31, 323, 7, 60, "Input"],
Cell[1115, 40, 228, 3, 36, "Output"]
}, Open  ]],
Cell[1358, 46, 439, 12, 36, "Input"],
Cell[CellGroupData[{
Cell[1822, 62, 227, 4, 36, "Input"],
Cell[2052, 68, 74, 1, 36, "Output"]
}, Open  ]],
Cell[2141, 72, 160, 4, 36, "Input"],
Cell[CellGroupData[{
Cell[2326, 80, 440, 17, 36, "Input"],
Cell[2769, 99, 92, 1, 38, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2898, 105, 106, 2, 36, "Input"],
Cell[3007, 109, 22152, 338, 1468, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25196, 452, 100, 2, 36, "Input"],
Cell[25299, 456, 132, 2, 70, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
