package com.solver4j.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import junit.framework.TestCase;

public class Solver4JBaseTest extends TestCase {
	
	public void testTrue() {
		assertTrue(true);
	}
	
	 /**
	  * Get the index of the maximum entry.
	  * @param v double vector
	  * @return index of the max value
	  */
	protected int getMaxIndex(RealVector v){
	  	return ColtUtils.getMaxIndex(DoubleFactory1D.dense.make(v.toArray()));
	  } 
	
	protected double[] getConditionNumberRange(RealMatrix A, int p) {
		return ColtUtils.getConditionNumberRange(DoubleFactory2D.dense.make(A.getData()), p);
	}

	protected void writeDoubleArrayToFile(double[] v, String fileName) throws IOException {
		DecimalFormat df = (DecimalFormat) NumberFormat.getInstance(Locale.US);
		df.applyPattern("#");
		df.setMaximumFractionDigits(16);
		String[][] ret = new String[v.length][1];
		for(int j=0; j<v.length; j++){
			if(Double.isNaN(v[j])){
				ret[j][0] = String.valueOf(v[j]);
			}else{
				ret[j][0] = df.format(v[j]);
				//ret[j][0] = String.valueOf(v[j]);
			}
		}
		CSVPrinter csvPrinter = new CSVPrinter(new FileWriter(fileName), CSVFormat.DEFAULT.withDelimiter(','));
		try{
			csvPrinter.printRecords(ret);
		}finally{
			csvPrinter.close();
		}
	}
	
	protected void writeDoubleMatrixToFile(double[][] m, String fileName) throws IOException {
		DecimalFormat df = (DecimalFormat) NumberFormat.getInstance(Locale.US);
		df.applyPattern("#");
		df.setMaximumFractionDigits(16);
		String[][] ret = new String[m.length][];
		for(int i=0; i<m.length; i++){
			double[] MI = m[i];
			String[] retI = new String[MI.length];
			for(int j=0; j<MI.length; j++){
				if(Double.isNaN(MI[j])){
					retI[j] = String.valueOf(MI[j]);
				}else{
					retI[j] = df.format(MI[j]);
					//retI[j] = String.valueOf(MI[j]);
				}
			}
			ret[i] = retI;
		}
		CSVPrinter csvPrinter = new CSVPrinter(new FileWriter(fileName), CSVFormat.DEFAULT.withDelimiter(','));
		try{
			csvPrinter.printRecords(ret);
		}finally{
			csvPrinter.close();
		}
	}
	
	public static final double[] loadDoubleArrayFromFile(String classpathFileName) throws IOException {
		//FileReader fr = new FileReader(classpathFileName);
		InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
		CSVParser parser = new CSVParser(new InputStreamReader(is), CSVFormat.DEFAULT.withDelimiter(',').withCommentMarker('#'));
		List<CSVRecord> records = parser.getRecords();
		double[] v = new double[records.size()];
		for(int i=0; i<records.size(); i++){
			v[i] = Double.parseDouble(records.get(i).get(0));
		}
		return v;
	}
	
	public static final int[] loadIntArrayFromFile(String classpathFileName) throws IOException {
		//FileReader fr = new FileReader(classpathFileName);
		InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
		CSVParser parser = new CSVParser(new InputStreamReader(is), CSVFormat.DEFAULT.withDelimiter(',').withCommentMarker('#'));
		List<CSVRecord> records = parser.getRecords();
		int[] v = new int[records.size()];
		for(int i=0; i<records.size(); i++){
			v[i] = (int) Double.parseDouble(records.get(i).get(0));
		}
		return v;
	}
		
	public static final double[][] loadDoubleMatrixFromFile(String classpathFileName, char fieldSeparator) throws IOException {
		InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
		CSVParser parser = new CSVParser(new InputStreamReader(is), CSVFormat.DEFAULT.withDelimiter(fieldSeparator).withCommentMarker('#'));
		List<CSVRecord> records = parser.getRecords();
		double[][] m = new double[records.size()][records.get(0).size()];
		for(int i=0; i<records.size(); i++){
			for(int j=0; j<records.get(0).size(); j++){
				m[i][j] = Double.parseDouble(records.get(i).get(j));
			}
		}
		return m;
	}
	
	public static final double[][] loadDoubleMatrixFromFile(String classpathFileName) throws IOException {
		return loadDoubleMatrixFromFile(classpathFileName, ",".charAt(0));
	}
	
	public static final int[][] loadIntMatrixFromFile(String classpathFileName, char fieldSeparator) throws IOException {
		InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(classpathFileName);
		CSVParser parser = new CSVParser(new InputStreamReader(is), CSVFormat.DEFAULT.withDelimiter(fieldSeparator).withCommentMarker('#'));
		List<CSVRecord> records = parser.getRecords();
		int[][] m = new int[records.size()][records.get(0).size()];
		for(int i=0; i<records.size(); i++){
			for(int j=0; j<records.get(0).size(); j++){
				m[i][j] = (int) Double.parseDouble(records.get(i).get(j));
			}
		}
		return m;
	}
	
	public static final int[][] loadIntMatrixFromFile(String classpathFileName) throws IOException {
		return loadIntMatrixFromFile(classpathFileName, ",".charAt(0));
	}
	
	
}
