/*
 * Copyright 2025-present Solver4J
 *
 * This work is licensed under the Creative Commons Attribution-NoDerivatives 4.0 
 * International License. To view a copy of this license, visit 
 *
 *        http://creativecommons.org/licenses/by-nd/4.0/ 
 *
 * or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
 */
package com.solver4j.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class BitwiseMathTest extends Solver4JBaseTest{
	
	private Logger logger = LoggerFactory.getLogger(this.getClass().getName());

	public void testAdd() {
		logger.debug("testAdd");
		logger.debug("2 + 3 = " + BitwiseMath.add(2, 3));
	}

	public void testSubtract() {
		logger.debug("testSubtract");
		logger.debug("2 - 3 = " + BitwiseMath.subtract(2, 3));
	}
	
	public void testMultiply() {
		logger.debug("testMultiply");
		logger.debug("7 * 100 = " + BitwiseMath.multiply(7, 100));
	}

	public void testDivide() {
		logger.debug("testDivide");
		logger.debug("7 / 3 = " + BitwiseMath.divide(7, 3));
	}
	
	public void testDivide2() {
		logger.debug("testDivide2");
		logger.debug("7*100 / 3 = " + BitwiseMath.divide(7*100, 3));
	}

}
