/*
 * Copyright 2025-present Solver4J
 *
 * This work is licensed under the Creative Commons Attribution-NoDerivatives 4.0 
 * International License. To view a copy of this license, visit 
 *
 *        http://creativecommons.org/licenses/by-nd/4.0/ 
 *
 * or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
 */
package com.solver4j.solvers;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.solver4j.functions.ConvexMultivariateRealFunction;
import com.solver4j.functions.LinearMultivariateRealFunction;
import com.solver4j.functions.PDQuadraticMultivariateRealFunction;
import com.solver4j.util.Solver4JBaseTest;

public class RunManyTimesTest extends Solver4JBaseTest{
	
	private Logger logger = LoggerFactory.getLogger(this.getClass().getName());
	
	/**
	 * The speed test of quadratic programming.
	 * Submitted 01/05/2017 by Luke Finlay (dr.luke.finlay@gmail.com).
	 */
	public void testQP() throws Exception {
		logger.debug("testQP");
		int nDim = 16;
		double[] diagQ = { 250, 250, 160, 160, 0.099007, 250, 0.657462, 0.088166, 0.023795, 0.033412, 0.024387,
				0.015439, 0.022145, 0.016, 0.03629, 0.019666 };

		double[][] Q = new double[nDim][nDim];
		for (int i = 0; i < nDim; i++){
			Q[i][i] = diagQ[i];
		}

		double[] P = { -24800, -24950, -15904, -15936, -9.177991, -24800, -63.971072, -8.058366, -1.829863, -2.646263, -1.71925, -0.821365, -1.643183, -0.9216,
				-3.033822, -1.305795 };

		// Objective function
		PDQuadraticMultivariateRealFunction objectiveFunction = new PDQuadraticMultivariateRealFunction(Q, P, 0);

		// inequalities
		ConvexMultivariateRealFunction[] inequalities = new ConvexMultivariateRealFunction[12];
		int[] pos = { 5, 15, 12, 13, 12, 4, 3, 3, 7, 10, 7, 5 };
		int[] neg = { 6, 13, 10, 11, 8, 12, 10, 9, 12, 14, 10, 8 };

		for (int i = 0; i < inequalities.length; i++) {
			double[] q = new double[nDim];
			q[pos[i]] = 1;
			q[neg[i]] = -1;
			inequalities[i] = new LinearMultivariateRealFunction(q, 0.);
		}

		OptimizationRequest or = new OptimizationRequest();
		or.setInitialPoint(new double[] { 99.2, 99.8, 99.4, 79.098125, 76.69624999999999, 76.798125, 97.3, 76.69624999999999, 76.9, 79.2, 83.49812499999999,
				53.2, 76.798125, 53.098125, 83.6, 52.99625 });
		or.setF0(objectiveFunction);
		or.setFi(inequalities);
		or.setToleranceFeas(1.E-8);
		or.setTolerance(1.E-9);

		// optimization
		Solver4J opt = new Solver4J();
		opt.setOptimizationRequest(or);
		for (int i = 0; i < 25000; i++) {
			opt.optimize();
		}
	}
}
