/*
 * Copyright 2025-present Solver4J
 *
 * This work is licensed under the Creative Commons Attribution-NoDerivatives 4.0 
 * International License. To view a copy of this license, visit 
 *
 *        http://creativecommons.org/licenses/by-nd/4.0/ 
 *
 * or send a letter to Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.
 */
package com.solver4j.linear.kkt;

import java.io.File;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.solver4j.util.Solver4JBaseTest;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Property;
import cern.jet.math.Functions;

/**
 * @author <a href="mailto:orion.waverly@gmail.com">Orion Waverly</a>
 */
public class DiagonalHKKTSolverTest extends Solver4JBaseTest {

	private Algebra ALG = Algebra.DEFAULT;
	private DoubleFactory1D F1 = DoubleFactory1D.dense;
	private DoubleFactory2D F2 = DoubleFactory2D.sparse;
	private Property P = Property.TWELVE;
	private Logger logger = LoggerFactory.getLogger(this.getClass().getName());

	public void testDummy(){
		assertTrue(true);
	}
	
	/**
	 * this is the KKT system relative to the first iteration of the minimization phase
	 * in the primal dual method for the afiro netlib problem.
	 * TODO: solve this test
	 */
	public void xxxtestSolve() throws Exception {
		logger.debug("testSolve");
		double[][] H = super.loadDoubleMatrixFromFile("lp" + File.separator	+ "H13.csv");
		double[][] A = super.loadDoubleMatrixFromFile("lp" + File.separator	+ "A13.csv");
		double[] g = super.loadDoubleArrayFromFile("lp" + File.separator	+ "g13.csv");
		double[] h = super.loadDoubleArrayFromFile("lp" + File.separator	+ "hh13.csv");
		DoubleMatrix2D HMatrix = F2.make(H);
		DoubleMatrix2D AMatrix = F2.make(A);
		DoubleMatrix1D gVector = F1.make(g);
		DoubleMatrix1D hVector = F1.make(h);

		DiagonalHKKTSolver solver = new DiagonalHKKTSolver();
		solver.setHMatrix(HMatrix);
		solver.setAMatrix(AMatrix);
		solver.setGVector(gVector);
		solver.setHVector(hVector);
		DoubleMatrix1D[] sol = solver.solve();
		DoubleMatrix1D v = sol[0];
		DoubleMatrix1D w = sol[1];
		logger.debug("v: " + ArrayUtils.toString(v.toArray()));
		logger.debug("w: " + ArrayUtils.toString(w.toArray()));

		DoubleMatrix1D a = ALG.mult(HMatrix, v).assign(ALG.mult(ALG.transpose(AMatrix), w), Functions.plus).assign(gVector, Functions.plus);
		DoubleMatrix1D b = ALG.mult(AMatrix, v).assign(hVector, Functions.plus);
		logger.debug("a: " + ArrayUtils.toString(a.toArray()));
		logger.debug("b: " + ArrayUtils.toString(b.toArray()));
		for (int i = 0; i < a.size(); i++) {
			assertEquals(0, a.get(i), 1.E-14);
		}
		for (int i = 0; i < b.size(); i++) {
			assertEquals(0, b.get(i), 1.E-14);
		}
	}
}
